function $CONVERT_EXPRESSION$( aURI )
{
    var requestNetworkURI = '$INSERT_PAGE_NETWORK_URI$';
    var requestBaseURI = '$INSERT_PAGE_BASE_URI$';
    var gatewayURI = '$INSERT_GATEWAY_URI$';

    if( aURI == null ||
	'string' != ( typeof aURI ) )
    {
	return aURI;
    }

    var splitArray = psSplit( aURI );
    if( splitArray[1].length == 0 ||
	splitArray[1].indexOf( '#' ) == 0 )
    {
	return aURI;
    }

    if( psGetProtocol( splitArray[1] ).length != 0 )
    {
	var lURIObject = new URIObject( splitArray[1] );

	//absolute URL
	if( lURIObject.defaultPort.length == 0 )
	{
	    //protocol is other than 'http' or 'https'
	    return aURI;
	}
	else
	{
	    lURI = lURIObject.normalizedURI;
	}

       var lLowerURIObject = new URIObject( lURI.toLowerCase() );

	if ( lLowerURIObject.hostName == '127.0.0.1' ||
	     lLowerURIObject.hostName == 'localhost' )
	{
	    return aURI;
	}

	var lGatewayURIObject = new URIObject( gatewayURI.toLowerCase() );
	if ( lLowerURIObject.networkURI.indexOf( lGatewayURIObject.networkURI ) == 0 &&
	     lGatewayURIObject.networkURI.indexOf( lLowerURIObject.networkURI ) == 0 )
	{
	    return lURI;
	}
    }
    else
    {
    	//handling of relative URI
    	//Need not check for localhost, protocol and normalization
    	//as it is relative URI's

	//check if this starts with '/'
	if ( splitArray[1].charAt( 0 ) == '/' )
	{
	    lURI = requestNetworkURI + splitArray[1];
	}
	else
	{
	    //check if this is relative path
	    if ( ( splitArray[1].charAt(0) == '.' ) ||
		 ( splitArray[1].charAt( splitArray[1].length - 1 ) == '.' ) )
	    {
	       lURI = requestBaseURI + splitArray[1];
	    }
	    else
	    {
		//this mean that URI does not start with . or /
		//but like dir/abc.html
		lURI = requestBaseURI + splitArray[1];
	    }
	}
    }

    return splitArray[0] + gatewayURI + '/redirect/' + lURI + splitArray[2];
}//$CONVERT_EXPRESSION$()


