/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.xml;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.urlscraper.URLScraperProvider;
import com.sun.portal.ubt.UBTLogManager;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XMLProvider
extends URLScraperProvider {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$providers$xml$XMLProvider == null ? (class$com$sun$portal$providers$xml$XMLProvider = XMLProvider.class$("com.sun.portal.providers.xml.XMLProvider")) : class$com$sun$portal$providers$xml$XMLProvider));
    private ResourceBundle bundle = null;
    private static Map xslTransformerMap = new HashMap(10);
    private static final String EMPTY_XML_URL = "urlnotspecified";
    private static final String EMPTY_XSL_FILENAME = "emptyXslFileName";
    private static final String XML_FETCH_ERROR = "xmlFetchError";
    private static final String XML_TRANSFOMING_ERROR = "xmlTransformingError";
    private static final String OLD_TRANSFORMER_FACTORY = "org.apache.xalan.xsltc.trax.TransformerFactoryImpl";
    private static final String DEFAULT_TRANSFORMER_FACTORY = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    static /* synthetic */ Class class$com$sun$portal$providers$xml$XMLProvider;

    protected File getXSL(String xslFileName) throws ProviderException {
        File xslFile = null;
        logger.log(Level.FINEST, "PSCR_CSPPX0001", xslFileName);
        if (xslFileName == null || xslFileName.equals("")) {
            return null;
        }
        logger.log(Level.FINEST, "PSCR_CSPPX0001", xslFileName);
        xslFile = super.getFile(xslFileName);
        if (xslFile == null) {
            try {
                xslFile = this.getProviderContext().getTemplatePath(this.getName(), xslFileName);
            }
            catch (ProviderContextException pce) {
                throw new ProviderException("XMLProvider.getXSL(): ", pce);
            }
        }
        if (xslFile != null) {
            logger.log(Level.FINEST, "PSCR_CSPPX0003", xslFile.getName());
        }
        if (xslFile == null) {
            try {
                URL xslFileUrl = new URL(xslFileName);
                throw new ProviderException("XMLProvider.getXSL(): Unsupported URL type :" + xslFileUrl.getProtocol());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return xslFile;
    }

    protected StringBuffer getXML(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String xmlURL = this.getURL();
        StringBuffer content = new StringBuffer();
        String proto = null;
        try {
            proto = xmlURL.substring(0, xmlURL.indexOf(58));
        }
        catch (IndexOutOfBoundsException iobe) {
            // empty catch block
        }
        if (proto != null && proto.equalsIgnoreCase("file")) {
            String PathName = null;
            try {
                PathName = xmlURL.substring(xmlURL.indexOf(47));
            }
            catch (IndexOutOfBoundsException iobe) {
                if (logger.isLoggable(Level.FINE)) {
                    LogRecord record = new LogRecord(Level.FINE, "PSCR_CSPPX0004");
                    record.setLoggerName(logger.getName());
                    record.setParameters(new Object[]{xmlURL});
                    record.setThrown(iobe);
                    logger.log(record);
                }
                throw new ProviderException("XMLProvider.getXML():Getting XML Content failed.  Unsupported URL type : " + xmlURL, iobe);
            }
            try {
                content = this.getFileAsBuffer(PathName);
            }
            catch (UnsupportedEncodingException ue) {
                if (logger.isLoggable(Level.FINE)) {
                    LogRecord record = new LogRecord(Level.FINE, "PSCR_CSPPX0005");
                    record.setLoggerName(logger.getName());
                    record.setParameters(new Object[]{PathName});
                    record.setThrown(ue);
                    logger.log(record);
                }
                throw new ProviderException("XMLProvider.getXML():Getting XML Content failed.  UnsupportedEncoding specified : " + PathName, ue);
            }
            catch (IOException ioe) {
                if (logger.isLoggable(Level.FINE)) {
                    LogRecord record = new LogRecord(Level.FINE, "PSCR_CSPPX0006");
                    record.setLoggerName(logger.getName());
                    record.setParameters(new Object[]{PathName});
                    record.setThrown(ioe);
                    logger.log(record);
                }
                throw new ProviderException("XMLProvider.getXML():Getting XML Content failed.  IOException received : " + PathName, ioe);
            }
        }
        try {
            content = UBTLogManager.getInstance().isUBTEnabled() ? this.getHttpContent(req, res, xmlURL, true) : this.getHttpContent(req, res, xmlURL, false);
        }
        catch (InterruptedException ie) {
            if (logger.isLoggable(Level.FINE)) {
                LogRecord record = new LogRecord(Level.FINE, "PSCR_CSPPX0007");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{xmlURL});
                record.setThrown(ie);
                logger.log(record);
            }
            throw new ProviderException("XMLProvider.getXML():Getting XML Content failed fetcher did not finish : " + xmlURL, ie);
        }
        catch (MalformedURLException mue) {
            if (logger.isLoggable(Level.FINE)) {
                LogRecord record = new LogRecord(Level.FINE, "PSCR_CSPPX0008");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{xmlURL});
                record.setThrown(mue);
                logger.log(record);
            }
            throw new ProviderException("XMLProvider.getXML():Getting XML Content failed Malformed URL : " + xmlURL, mue);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized StringBuffer doTransform(StringBuffer XMLFile, String xslFileName) throws ProviderException {
        StringWriter contentWriter;
        StringBuffer XformedContent;
        block14: {
            Transformer xslTransformer;
            block13: {
                LogRecord record;
                XformedContent = null;
                xslTransformer = null;
                try {
                    xslTransformer = this.getXslTransformer(xslFileName);
                }
                catch (TransformerConfigurationException tce) {
                    if (logger.isLoggable(Level.INFO)) {
                        record = new LogRecord(Level.FINE, "PSCR_CSPPX0009");
                        record.setLoggerName(logger.getName());
                        record.setParameters(new Object[]{xslFileName});
                        record.setThrown(tce);
                        logger.log(record);
                    }
                }
                catch (TransformerException te) {
                    if (!logger.isLoggable(Level.INFO)) break block13;
                    record = new LogRecord(Level.FINE, "PSCR_CSPPX0009");
                    record.setLoggerName(logger.getName());
                    record.setParameters(new Object[]{xslFileName});
                    record.setThrown(te);
                    logger.log(record);
                }
            }
            if (xslTransformer != null) {
                InputSource xmlSource = new InputSource(new StringReader(XMLFile.toString()));
                contentWriter = new StringWriter();
                StreamResult contentResult = new StreamResult(contentWriter);
                try {
                    Transformer transformer = xslTransformer;
                    synchronized (transformer) {
                        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        Document dom = builder.parse(xmlSource);
                        xslTransformer.transform(new DOMSource(dom), contentResult);
                        break block14;
                    }
                }
                catch (TransformerException te) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        LogRecord record = new LogRecord(Level.FINE, "PSCR_CSPPX0010");
                        record.setLoggerName(logger.getName());
                        record.setParameters(new Object[]{XMLFile, xslFileName});
                        record.setThrown(te);
                        logger.log(record);
                    }
                    throw new ProviderException("XMLProvider.doTransform():Error in transforming xml : " + XMLFile + " using XSL file : " + xslFileName);
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        LogRecord record = new LogRecord(Level.FINE, "PSCR_CSPPX0010");
                        record.setParameters(new Object[]{XMLFile, xslFileName});
                        record.setThrown(e);
                        logger.log(record);
                    }
                    throw new ProviderException("XMLProvider.doTransform():Error in transforming xml : " + XMLFile + " using XSL file : " + xslFileName);
                }
            }
            logger.log(Level.FINE, "PSCR_CSPPX0011", new Object[]{XMLFile, xslFileName});
            throw new ProviderException("XMLProvider.doTransform(): Error in getting XSL transformer to transform xml : " + XMLFile + " using XSL file : " + xslFileName);
        }
        XformedContent = contentWriter.getBuffer();
        return XformedContent;
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String xslFilePath;
        File xslFile;
        String xslFileName;
        StringBuffer content;
        block11: {
            content = new StringBuffer();
            this.bundle = this.getResourceBundle();
            String xmlURL = this.getURL();
            if (xmlURL == null || xmlURL.equals("")) {
                content = content.append(this.bundle.getString(EMPTY_XML_URL));
                return content;
            }
            xslFileName = this.getStringProperty("xslFileName");
            xslFile = null;
            xslFilePath = null;
            try {
                xslFile = this.getXSL(xslFileName);
            }
            catch (ProviderException xe) {
                if (!logger.isLoggable(Level.INFO)) break block11;
                LogRecord record = new LogRecord(Level.FINE, "PSCR_CSPPX0012");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{xslFileName});
                record.setThrown(xe);
                logger.log(record);
            }
        }
        if (xslFile != null) {
            xslFilePath = xslFile.getPath();
        }
        if (xslFilePath == null || xslFilePath.equals("")) {
            content = content.append(this.bundle.getString(EMPTY_XSL_FILENAME));
            return content;
        }
        StringBuffer Xmlfile = new StringBuffer();
        try {
            Xmlfile = this.getXML(req, res);
        }
        catch (ProviderException xe) {
            logger.log(Level.INFO, "PSCR_CSPPX0013", xe);
            content = content.append(this.bundle.getString(XML_FETCH_ERROR));
            return content;
        }
        if (Xmlfile == null) {
            logger.log(Level.INFO, "PSCR_CSPPX0013");
            content = content.append(this.bundle.getString(XML_FETCH_ERROR));
            return content;
        }
        logger.log(Level.FINER, "PSCR_CSPPX0014");
        try {
            content = this.doTransform(Xmlfile, xslFilePath);
        }
        catch (ProviderException p) {
            if (logger.isLoggable(Level.INFO)) {
                LogRecord record = new LogRecord(Level.FINE, "PSCR_CSPPX0015");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{xslFileName});
                record.setThrown(p);
                logger.log(record);
            }
            content = content.append(this.bundle.getString(XML_TRANSFOMING_ERROR));
        }
        return content;
    }

    protected String getContentEncodingFromContentBytes(byte[] contentBytes) {
        String headerstr;
        String header;
        int encoding;
        int end;
        String contentString;
        String str;
        int start;
        String charset = null;
        int len = contentBytes.length;
        int count = 1000;
        if (len < count) {
            count = len;
        }
        if ((start = (str = (contentString = new String(contentBytes, 0, count)).toLowerCase()).indexOf("<?xml")) != -1 && (end = str.indexOf(">", start)) != -1 && (encoding = (header = (headerstr = contentString.substring(start, end)).toLowerCase()).indexOf("encoding=")) != -1) {
            int startencoding = header.indexOf("\"", encoding);
            int endencoding = header.indexOf("\"", startencoding + 1);
            charset = headerstr.substring(startencoding + 1, endencoding);
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformer getXslTransformer(String xslFileName) throws TransformerConfigurationException, TransformerException {
        ProviderContext pc = this.getProviderContext();
        String transformerFactoryClassName = DEFAULT_TRANSFORMER_FACTORY;
        try {
            if (this.existsStringProperty("transformerFactoryClassName") && ((transformerFactoryClassName = this.getStringProperty("transformerFactoryClassName")) == null || transformerFactoryClassName.equals(""))) {
                transformerFactoryClassName = DEFAULT_TRANSFORMER_FACTORY;
            }
        }
        catch (ProviderException pe) {
            logger.log(Level.INFO, "PSCR_CSPPX0016", pe);
        }
        if (!this.isTransformerAvailable(transformerFactoryClassName)) {
            transformerFactoryClassName = OLD_TRANSFORMER_FACTORY;
        }
        StringBuffer sb = new StringBuffer(xslFileName);
        sb.append("|");
        sb.append(transformerFactoryClassName);
        String cacheKey = sb.toString();
        CacheEntry cacheEntry = (CacheEntry)xslTransformerMap.get(cacheKey);
        if (cacheEntry == null) {
            Class clazz = class$com$sun$portal$providers$xml$XMLProvider == null ? (class$com$sun$portal$providers$xml$XMLProvider = XMLProvider.class$("com.sun.portal.providers.xml.XMLProvider")) : class$com$sun$portal$providers$xml$XMLProvider;
            synchronized (clazz) {
                cacheEntry = (CacheEntry)xslTransformerMap.get(cacheKey);
                if (cacheEntry == null) {
                    File xslFile = null;
                    cacheEntry = new CacheEntry();
                    try {
                        xslFile = this.getXSL(xslFileName);
                        if (xslFile == null) {
                            logger.log(Level.INFO, "PSCR_CSPPX0017", xslFileName);
                            return null;
                        }
                    }
                    catch (ProviderException xpe) {
                        if (logger.isLoggable(Level.INFO)) {
                            LogRecord record = new LogRecord(Level.FINE, "PSCR_CSPPX0018");
                            record.setLoggerName(logger.getName());
                            record.setParameters(new Object[]{xslFileName});
                            record.setThrown(xpe);
                            logger.log(record);
                        }
                        return null;
                    }
                    cacheEntry.xslFile = xslFile;
                    cacheEntry.lastModTime = -1L;
                    xslTransformerMap.put(cacheKey, cacheEntry);
                }
            }
        }
        if (cacheEntry.lastModTime == -1L || cacheEntry.lastModTime < cacheEntry.xslFile.lastModified()) {
            TransformerFactory factory = null;
            try {
                Class<?> transformerFactoryClass = Class.forName(transformerFactoryClassName);
                factory = (TransformerFactory)transformerFactoryClass.newInstance();
            }
            catch (ClassCastException cce) {
                logger.log(Level.INFO, "PSCR_CSPPX0002", cce);
                return null;
            }
            catch (ClassNotFoundException cnfe) {
                logger.log(Level.INFO, "PSCR_CSPPX0002", cnfe);
                return null;
            }
            catch (InstantiationException ie) {
                logger.log(Level.INFO, "PSCR_CSPPX0002", ie);
                return null;
            }
            catch (IllegalAccessException iae) {
                logger.log(Level.INFO, "PSCR_CSPPX0002", iae);
                return null;
            }
            cacheEntry.xslTransformer = factory.newTransformer(new StreamSource(cacheEntry.xslFile));
            cacheEntry.lastModTime = cacheEntry.xslFile.lastModified();
        }
        return cacheEntry.xslTransformer;
    }

    private boolean isTransformerAvailable(String transformerName) {
        boolean result = true;
        try {
            Class.forName(transformerName);
        }
        catch (ClassNotFoundException e) {
            result = false;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CacheEntry {
        private Transformer xslTransformer;
        private File xslFile;
        private long lastModTime;
    }
}

