/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.urlscraper;

import com.sun.identity.security.DecryptAction;
import com.sun.identity.security.EncryptAction;
import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.urlscraper.ContentFilter;
import com.sun.portal.providers.urlscraper.ContentFilterImpl;
import com.sun.portal.providers.urlscraper.Fetcher;
import com.sun.portal.providers.util.ProviderProperties;
import com.sun.portal.ubt.UBTEvent;
import com.sun.portal.ubt.UBTLogManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class URLScraperProvider
extends ProfileProviderAdapter
implements ProviderProperties {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$providers$urlscraper$URLScraperProvider == null ? (class$com$sun$portal$providers$urlscraper$URLScraperProvider = URLScraperProvider.class$("com.sun.portal.providers.urlscraper.URLScraperProvider")) : class$com$sun$portal$providers$urlscraper$URLScraperProvider));
    private ResourceBundle bundle = null;
    private List pflist = null;
    private Fetcher httpFetcher = null;
    protected static String[][] typeTable = new String[][]{{".html", "text/html"}, {".htm", "text/html"}, {".gif", "image/gif"}, {".txt", "text/plain"}, {".jpg", "image/jpeg"}, {".xml", "text/xml"}, {".wml", "text/vnd.wap.wml"}};
    static /* synthetic */ Class class$com$sun$portal$providers$urlscraper$URLScraperProvider;

    protected int getTimeout() throws ProviderException {
        return this.getIntegerProperty("timeout");
    }

    protected String getURL() throws ProviderException {
        return this.getPropertyValue("url");
    }

    protected String getRuleSetID() throws ProviderException {
        return this.getPropertyValue("urlScraperRulesetID");
    }

    public String getInputEncoding() throws ProviderException {
        return this.getPropertyValue("inputEncoding");
    }

    private String getPropertyValue(String key) throws ProviderException {
        String val = null;
        try {
            if (RequestThreadLocalizer.getRequest() != null || this.pflist == null) {
                this.pflist = this.getProviderContext().getClientAndLocalePropertiesFilters();
            }
            val = this.getStringProperty(key, this.pflist);
        }
        catch (ProviderContextException pce) {
            logger.log(Level.INFO, "PSCR_CSPPU0014", pce);
        }
        if (val == null) {
            val = this.getStringProperty(key);
        }
        return val;
    }

    public boolean isPresentable(HttpServletRequest request) {
        return true;
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        StringBuffer content = new StringBuffer();
        this.bundle = this.getResourceBundle();
        String url = this.getURL();
        if (url == null || url.trim().length() == 0) {
            content.append(this.bundle.getString("urlnotspecified"));
            return content;
        }
        String proto = null;
        try {
            proto = url.substring(0, url.indexOf(58));
        }
        catch (IndexOutOfBoundsException iobe) {
            // empty catch block
        }
        if (proto != null && proto.equalsIgnoreCase("file")) {
            String PathName = null;
            try {
                PathName = url.substring(url.indexOf(47));
            }
            catch (IndexOutOfBoundsException iobe) {
                logger.log(Level.INFO, "PSCR_CSPPU0015", iobe);
                content = content.append(this.bundle.getString("unsupportedurl"));
                return content;
            }
            try {
                content = this.getFileAsBuffer(PathName);
            }
            catch (UnsupportedEncodingException ue) {
                logger.log(Level.INFO, "PSCR_CSPPU0016", ue);
                content = content.append(this.bundle.getString("unsupportedencoding"));
            }
            catch (IOException ioe) {
                logger.log(Level.INFO, "PSCR_CSPPU0017", ioe);
                return null;
            }
            return content;
        }
        try {
            boolean enable = false;
            try {
                enable = UBTLogManager.getInstance().isUBTEnabled() && this.getBooleanProperty("enableUBT", false) && Logger.getLogger(UBTEvent.getInstance((String)"USER_CLICK_EX_LINK").getLoggerName()).isLoggable(UBTEvent.getInstance((String)"USER_CLICK_EX_LINK").getLevel());
            }
            catch (Exception e) {
                logger.log(Level.INFO, "PSCR_CSPPU0025", e);
            }
            content = enable ? this.getHttpContent(req, res, url, true) : this.getHttpContent(req, res, url, false);
        }
        catch (InterruptedException ie) {
            logger.log(Level.INFO, "PSCR_CSPPU0018", ie);
            content = content.append(this.bundle.getString("timeout"));
            return content;
        }
        catch (MalformedURLException mue) {
            logger.log(Level.INFO, "PSCR_CSPPU0019", mue);
            content = content.append(this.bundle.getString("unsupportedurl"));
            return content;
        }
        return content;
    }

    protected StringBuffer getHttpContent(HttpServletRequest req, HttpServletResponse res, String url) throws InterruptedException, MalformedURLException, ProviderException {
        return this.getHttpContent(req, res, url, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuffer getHttpContent(HttpServletRequest req, HttpServletResponse res, String url, boolean ubt) throws InterruptedException, MalformedURLException, ProviderException {
        StringBuffer content = new StringBuffer();
        if (this.httpFetcher == null) {
            HashMap<String, Object> config = new HashMap<String, Object>();
            try {
                Iterator it = this.getProviderContext().getNames(this.getName());
                while (it.hasNext()) {
                    String propertyName = (String)it.next();
                    config.put(propertyName, this.getProviderContext().getProperty(this.getName(), propertyName));
                }
            }
            catch (ProviderContextException pcEx) {
                logger.log(Level.INFO, "PSCR_CSPPU0027", pcEx);
            }
            config.put("urlScraperRulesetID", this.getRuleSetID());
            config.put("cookiesToForwardAll", new Boolean(this.getCookiesToForwardAll()));
            config.put("cookiesToForwardList", this.getcookiesToForwardList());
            config.put("rb", this.bundle);
            config.put("inputEncoding", this.getInputEncoding());
            try {
                config.put("password", this.getHttpAuthPassword());
            }
            catch (ProviderException pEx) {
                // empty catch block
            }
            String ubtAppendUrl = this.getProviderContext().getDesktopURL(req) + "?action=ubt&url=";
            this.httpFetcher = ubt ? new Fetcher(config, ubt, ubtAppendUrl) : new Fetcher(config);
        }
        content = this.httpFetcher.getFilteredContent(this.getTimeout(), req, res, url);
        return content;
    }

    protected File getFile(String pathname) {
        File returnFile = null;
        try {
            returnFile = new File(pathname);
            if (returnFile.exists() && returnFile.isFile() && returnFile.canRead()) {
                return returnFile;
            }
            return null;
        }
        catch (SecurityException se) {
            logger.log(Level.INFO, "PSCR_CSPPU0021", se);
            return null;
        }
        catch (NullPointerException npe) {
            logger.log(Level.INFO, "PSCR_CSPPU0022", npe);
            return null;
        }
    }

    protected StringBuffer getFileAsBuffer(String pathName) throws IOException, ProviderException {
        StringBuffer result = null;
        File f = null;
        try {
            String charset;
            String MIMEType;
            byte[] bytes;
            f = this.getFile(pathName);
            if (f != null) {
                FileInputStream fin = new FileInputStream(f);
                bytes = Fetcher.readContent(fin, -1);
                MIMEType = URLScraperProvider.getMIMEType(f.getName());
                charset = Fetcher.getContentEncoding(null, bytes, MIMEType, this.getInputEncoding());
                if (fin != null) {
                    fin.close();
                }
            } else {
                logger.log(Level.INFO, "PSCR_CSPPU0023");
                return null;
            }
            result = charset != null && charset.length() != 0 ? new StringBuffer(new String(bytes, charset)) : new StringBuffer(new String(bytes));
            ContentFilter conFilter = ContentFilterImpl.getInstance(MIMEType);
            result = conFilter.filter(result);
        }
        catch (NegativeArraySizeException nas) {
            logger.log(Level.INFO, "PSCR_CSPPU0024", nas);
            return null;
        }
        catch (FileNotFoundException fe) {
            logger.log(Level.INFO, "PSCR_CSPPU0024", fe);
            return null;
        }
        return result;
    }

    private static String getMIMEType(String filename) {
        String MIMEType = null;
        if (filename != null) {
            try {
                FileNameMap fnm = URLConnection.getFileNameMap();
                if (fnm.getContentTypeFor(filename) != null) {
                    MIMEType = fnm.getContentTypeFor(filename);
                }
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            if (MIMEType == null) {
                String fname = filename.toLowerCase();
                for (int i = 0; i < typeTable.length && MIMEType == null; ++i) {
                    if (!fname.endsWith(typeTable[i][0])) continue;
                    MIMEType = typeTable[i][1];
                }
            }
        }
        return MIMEType;
    }

    protected boolean getCookiesToForwardAll() throws ProviderException {
        return this.getBooleanProperty("cookiesToForwardAll");
    }

    protected List getcookiesToForwardList() throws ProviderException {
        return this.getListProperty("cookiesToForwardList");
    }

    protected boolean isHttpAuth() throws ProviderException {
        return this.getBooleanProperty("isHttpAuth");
    }

    protected String getHttpAuthUid() throws ProviderException {
        return this.getStringProperty("uid");
    }

    protected String getHttpAuthPassword() throws ProviderException {
        String password = this.getStringProperty("password");
        if (password == null) {
            return "";
        }
        password = (String)AccessController.doPrivileged(new DecryptAction(password));
        return password;
    }

    protected String getLoginUrl() throws ProviderException {
        return this.getStringProperty("loginUrl");
    }

    protected String getLogoutUrl() throws ProviderException {
        return this.getStringProperty("logoutUrl");
    }

    protected String getLoginFormData() throws ProviderException {
        return this.getStringProperty("loginFormData");
    }

    protected String getFormData() throws ProviderException {
        return this.getStringProperty("formData");
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String loginUrl;
        StringBuffer content = new StringBuffer();
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        tagTable.put("fontFace1", this.getStringProperty("fontFace1"));
        if (!this.isHttpAuth() && ((loginUrl = this.getLoginUrl()) == null || loginUrl.equals(""))) {
            content = this.getTemplate("editError.template", tagTable);
            return content;
        }
        tagTable.put("Name", this.getName());
        tagTable.put("uid", this.getHttpAuthUid());
        tagTable.put("password", "********");
        content = this.getTemplate("edit.template", tagTable);
        return content;
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        block4: {
            String uid = req.getParameter("uid");
            String password = req.getParameter("password");
            try {
                if (uid != null) {
                    this.getProviderContext().setStringProperty(this.getName(), "uid", uid);
                }
                if (password != null && !password.equals("") && !password.equals("********")) {
                    password = (String)AccessController.doPrivileged(new EncryptAction(password));
                    this.getProviderContext().setStringProperty(this.getName(), "password", password);
                }
            }
            catch (ProviderContextException pce) {
                if (!logger.isLoggable(Level.WARNING)) break block4;
                LogRecord rec = new LogRecord(Level.WARNING, "PSDT_CSPPB0001");
                rec.setLoggerName(logger.getName());
                Object[] param = new String[]{"uid", "password"};
                rec.setParameters(param);
                rec.setThrown(pce);
                logger.log(rec);
            }
        }
        this.httpFetcher = null;
        this.getProviderContext().contentChanged(this.getName());
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

