/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.urlscraper;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.urlscraper.ContentFilter;
import com.sun.portal.providers.urlscraper.ContentFilterException;
import com.sun.portal.providers.urlscraper.ContentFilterImpl;
import com.sun.portal.providers.urlscraper.FetcherThread;
import com.sun.portal.providers.urlscraper.Header;
import com.sun.portal.rewriter.AbsoluteTranslator;
import com.sun.portal.rewriter.Rewriter;
import com.sun.portal.rewriter.RewriterModule;
import com.sun.portal.rewriter.RewriterPool;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.rom.InvalidXMLException;
import com.sun.portal.rewriter.util.uri.PageSpec;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Encoder;

public class Fetcher {
    public static final String KEY_RULESET_ID = "urlScraperRulesetID";
    public static final String KEY_COOKIES_TO_FORWARD_ALL = "cookiesToForwardAll";
    public static final String KEY_COOKIES_TO_FORWARD_LIST = "cookiesToForwardList";
    public static final String KEY_RESOURCE_BUNDLE = "rb";
    public static final String KEY_INPUT_ENCODING = "inputEncoding";
    public static final String KEY_FORM_DATA = "formData";
    public static final String KEY_LOGIN_URL = "loginUrl";
    public static final String KEY_LOGIN_FORM_DATA = "loginFormData";
    public static final String KEY_HTTP_AUTH = "isHttpAuth";
    public static final String KEY_HTTP_AUTH_UID = "uid";
    public static final String KEY_HTTP_AUTH_PASSWORD = "password";
    public static final String KEY_LOGOUT_URL = "logoutUrl";
    private static final int CONTENT_BUFFER_SIZE = 2048;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$providers$urlscraper$Fetcher == null ? (class$com$sun$portal$providers$urlscraper$Fetcher = Fetcher.class$("com.sun.portal.providers.urlscraper.Fetcher")) : class$com$sun$portal$providers$urlscraper$Fetcher));
    private boolean ubt = false;
    private String ubtAppendUrl = null;
    private Map config = new Hashtable();
    private Hashtable domainPathCookieTable = new Hashtable();
    private Hashtable sessionCookieTable = new Hashtable();
    private boolean isAuthenticated = false;
    private String postLoginUrl = null;
    int loop = 0;
    private static List ignoreHeaders = new ArrayList();
    static /* synthetic */ Class class$com$sun$portal$providers$urlscraper$Fetcher;

    public Fetcher(Map config) throws MalformedURLException {
        this(config, false, null);
    }

    public Fetcher(Map configMap, boolean ubt, String ubtAppendUrlSt) throws MalformedURLException {
        this.config = configMap;
        this.ubt = ubt;
        this.ubtAppendUrl = ubtAppendUrlSt;
    }

    private boolean getCookiesToForwardAll() {
        Object obj = this.config.get(KEY_COOKIES_TO_FORWARD_ALL);
        if (obj != null && obj instanceof String) {
            return Boolean.getBoolean(obj.toString());
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return true;
    }

    private List getCookiesToForwardList() {
        return (List)this.config.get(KEY_COOKIES_TO_FORWARD_LIST);
    }

    private FetcherThread createFetcherThread(HttpServletRequest request, HttpServletResponse response, String u) {
        return new FetcherThread(this, request, response, u);
    }

    StringBuffer fetch(FetcherThread ft, String u) {
        StringBuffer content = this.setFormAuth(ft);
        if (Fetcher.isEmpty(u)) {
            u = this.postLoginUrl;
        } else if (u.equals(this.postLoginUrl) && content != null) {
            return content;
        }
        return this.fetch(ft, u, this.getFormData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private StringBuffer fetch(FetcherThread ft, String u, String formData) {
        StringBuffer content;
        block55: {
            int contentLength;
            HttpURLConnection uc;
            String charset;
            InputStream in;
            block53: {
                int responseCode;
                block51: {
                    CharSequence domain;
                    URL url;
                    block49: {
                        String hkey;
                        content = null;
                        in = null;
                        charset = null;
                        uc = null;
                        url = new URL(Fetcher.getAbsURL(u, ft.getDesktopRequestURL()));
                        try {
                            uc = (HttpURLConnection)url.openConnection();
                        }
                        catch (ClassCastException ce) {
                            throw new Exception("Fetcher doesn't support ftp, file urls. URL:" + url, ce);
                        }
                        uc.setDoInput(true);
                        uc.setUseCaches(false);
                        HttpURLConnection.setFollowRedirects(false);
                        if (ft.getHttpServletRequest() != null) {
                            Cookie[] ca = ft.getHttpServletRequest().getCookies();
                            HashMap<String, Cookie> forwardedCookies = new HashMap<String, Cookie>();
                            if (ca != null) {
                                for (int j = 0; j < ca.length; ++j) {
                                    if (!Fetcher.forward(ca[j].getName(), this.getCookiesToForwardAll(), this.getCookiesToForwardList())) continue;
                                    forwardedCookies.put(ca[j].getName(), ca[j]);
                                }
                            }
                            Iterator it = this.sessionCookieTable.values().iterator();
                            while (it.hasNext()) {
                                Cookie c = (Cookie)it.next();
                                forwardedCookies.put(c.getName(), c);
                            }
                            if (forwardedCookies != null && !forwardedCookies.isEmpty()) {
                                StringBuffer cs = new StringBuffer();
                                logger.log(Level.FINEST, "PSCR_CSPPU0001", this.domainPathCookieTable);
                                Iterator fci = forwardedCookies.values().iterator();
                                while (fci.hasNext()) {
                                    Cookie c = (Cookie)fci.next();
                                    String path = null;
                                    domain = null;
                                    if (this.domainPathCookieTable != null && this.domainPathCookieTable.containsKey(c.getName())) {
                                        domainPathEntry dp = (domainPathEntry)this.domainPathCookieTable.get(c.getName());
                                        path = dp.getPath();
                                        domain = dp.getDomain();
                                    }
                                    cs.append(c.getName()).append("=").append(c.getValue());
                                    if (path != null) {
                                        cs.append("; ").append("$Path=" + path);
                                    }
                                    if (domain != null) {
                                        cs.append("; ").append("$Domain=" + domain);
                                    }
                                    if (!fci.hasNext()) continue;
                                    cs.append("; ");
                                }
                                logger.log(Level.FINEST, "PSCR_CSPPU0002", cs.toString());
                                logger.log(Level.FINEST, "PSCR_CSPPU0003", this.domainPathCookieTable);
                                uc.setRequestProperty("Cookie", cs.toString());
                            }
                        }
                        this.setHeaders(uc, ft.getHttpServletRequest());
                        this.setBasicAuthHeader(uc);
                        responseCode = 200;
                        Fetcher.setPostData(uc, formData);
                        responseCode = uc.getResponseCode();
                        contentLength = uc.getContentLength();
                        int i = 1;
                        while ((hkey = uc.getHeaderFieldKey(i)) != null) {
                            if (hkey.equalsIgnoreCase("Set-cookie")) {
                                String setCookie = uc.getHeaderField(i);
                                this.processSetCookieHeader(setCookie, ft, url);
                            }
                            ++i;
                        }
                        logger.log(Level.FINEST, "PSCR_CSPPU0004", new Integer(responseCode));
                        if (responseCode != -1) break block49;
                        logger.log(Level.INFO, "PSCR_CSPPU0005");
                        try {
                            uc.disconnect();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        StringBuffer ex = content;
                        Object var18_32 = null;
                        try {
                            uc.disconnect();
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        return ex;
                    }
                    if (responseCode != 301) {
                        if (responseCode != 302) break block51;
                    }
                    String loc = uc.getHeaderField("Location");
                    Header h = new Header(loc);
                    logger.log(Level.FINEST, "PSCR_CSPPU0006", h.getValue());
                    String newUrlSt = Fetcher.getAbsURL(h.getValue(), url);
                    if (this.loop >= 3) break block51;
                    if (u.equalsIgnoreCase(newUrlSt)) {
                        ++this.loop;
                    }
                    ft.setLastFetchedUrl(u);
                    domain = this.fetch(ft, newUrlSt, formData);
                    Object var18_33 = null;
                    try {
                        uc.disconnect();
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    return domain;
                }
                if (responseCode != 401) break block53;
                content = new StringBuffer(this.getResourceBundle().getString("authFailed"));
                try {
                    uc.disconnect();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                StringBuffer ex = content;
                Object var18_34 = null;
                try {
                    uc.disconnect();
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return ex;
            }
            ft.setContentType(uc.getContentType());
            PageSpec pageSpec = new PageSpec(uc.getURL().toString(), ft.getContentType());
            in = uc.getInputStream();
            byte[] bytes = Fetcher.readContent(in, contentLength);
            charset = Fetcher.getContentEncoding(ft.getContentType(), bytes, pageSpec.getMIME(), this.getInputEncoding());
            String data = null;
            data = charset != null && charset.length() != 0 ? new String(bytes, charset) : new String(bytes);
            Rewriter rewriter = RewriterPool.getDefault().getRewriter(this.getRuleSetId(), pageSpec);
            if (rewriter != null) {
                AbsoluteTranslator t = this.ubt ? new AbsoluteTranslator(pageSpec, this.ubtAppendUrl) : new AbsoluteTranslator(pageSpec);
                content = new StringBuffer(rewriter.rewrite(data, (Translator)t));
            } else {
                content = new StringBuffer(data);
            }
            logger.log(Level.FINEST, "PSCR_CSPPU0007", content.toString());
            Object var18_35 = null;
            try {
                uc.disconnect();
                if (in != null) {
                    in.close();
                }
                break block55;
            }
            catch (IOException e2) {}
            break block55;
            {
                catch (InvalidXMLException ixe) {
                    logger.log(Level.INFO, "PSCR_CSPPU0008", ixe);
                    content = new StringBuffer(this.getResourceBundle().getString("invalidruleset"));
                    Object var18_36 = null;
                    try {
                        uc.disconnect();
                        if (in != null) {
                            in.close();
                        }
                        break block55;
                    }
                    catch (IOException e2) {}
                    break block55;
                }
                catch (UnsupportedEncodingException ue) {
                    if (logger.isLoggable(Level.INFO)) {
                        LogRecord record = new LogRecord(Level.INFO, "PSCR_CSPPU0009");
                        record.setLoggerName(logger.getName());
                        record.setParameters(new Object[]{charset});
                        record.setThrown(ue);
                        logger.log(record);
                    }
                    content = new StringBuffer(this.getResourceBundle().getString("unsupportedencoding"));
                    Object var18_37 = null;
                    try {
                        uc.disconnect();
                        if (in != null) {
                            in.close();
                        }
                        break block55;
                    }
                    catch (IOException e2) {}
                    break block55;
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "PSCR_CSPPU0008", e);
                    if (e instanceof InterruptedException) {
                        content = new StringBuffer(this.getResourceBundle().getString("timeout"));
                    }
                    content = null;
                    Object var18_38 = null;
                    try {
                        uc.disconnect();
                        if (in != null) {
                            in.close();
                        }
                        break block55;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var18_39 = null;
                try {
                    uc.disconnect();
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return content;
    }

    private String getCookieName(String cookieStr) {
        String name = null;
        int index = cookieStr.indexOf("=");
        if (index != -1) {
            name = cookieStr.substring(0, index);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSetCookieHeader(String cookieStr, FetcherThread ft, URL url) throws MalformedURLException {
        block6: {
            String newCookieStr = this.modifyCookieHeader(cookieStr, url, ft);
            logger.log(Level.FINEST, "PSCR_CSPPU0010", new Object[]{cookieStr, newCookieStr});
            if (newCookieStr != null) {
                cookieStr = newCookieStr;
            }
            try {
                String cookieName;
                if (cookieStr == null || ft.getHttpServletResponse() == null || (cookieName = this.getCookieName(cookieStr)) == null || !Fetcher.forward(cookieName, this.getCookiesToForwardAll(), this.getCookiesToForwardList())) break block6;
                HttpServletResponse httpServletResponse = ft.getHttpServletResponse();
                synchronized (httpServletResponse) {
                    ft.getHttpServletResponse().addHeader("Set-Cookie", cookieStr);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.INFO)) break block6;
                LogRecord record = new LogRecord(Level.INFO, "PSCR_CSPPU0011");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{cookieStr});
                record.setThrown(e);
                logger.log(record);
            }
        }
    }

    private static String getAbsURL(String u, URL lastFetchedUrl) throws MalformedURLException {
        if (!u.regionMatches(true, 0, "http://", 0, 7) && !u.regionMatches(true, 0, "https://", 0, 8)) {
            String path;
            int lastIndex;
            String scheme = lastFetchedUrl.getProtocol();
            StringBuffer absURL = new StringBuffer().append(scheme).append("://").append(lastFetchedUrl.getHost()).append(":");
            int port = lastFetchedUrl.getPort();
            if (scheme.equals("http") && port <= 0) {
                port = 80;
            } else if (scheme.equals("https") && port <= 0) {
                port = 443;
            }
            absURL.append(port);
            if (!u.startsWith("/") && (lastIndex = (path = lastFetchedUrl.getPath()).lastIndexOf("/")) > 0) {
                absURL.append(path.substring(0, lastIndex)).append("/");
            }
            absURL.append(u);
            return absURL.toString();
        }
        return u;
    }

    private String modifyCookieHeader(String cookieStr, URL url, FetcherThread ft) throws MalformedURLException {
        if (cookieStr == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(cookieStr, ";");
        if (!tokens.hasMoreTokens()) {
            return cookieStr;
        }
        String nameAndValue = tokens.nextToken().trim();
        String cookieName = this.getCookieName(cookieStr);
        String host = url.getHost();
        String portalHost = ft.getDesktopRequestURL().getHost();
        StringBuffer sb = new StringBuffer();
        sb.append(nameAndValue);
        String cookieValue = this.getValueFromNameValuePair(nameAndValue);
        Cookie sessionCookie = new Cookie(cookieName, cookieValue);
        this.sessionCookieTable.put(cookieName, sessionCookie);
        String path = null;
        String domain = null;
        while (tokens.hasMoreTokens()) {
            String val;
            String attr;
            String token = tokens.nextToken().trim();
            if (token.length() == 0) continue;
            int equIndex = token.indexOf(61);
            if (equIndex < 0) {
                attr = token;
                val = null;
            } else {
                attr = token.substring(0, equIndex).trim();
                val = equIndex + 1 == token.length() ? null : token.substring(equIndex + 1).trim();
            }
            if (attr.equalsIgnoreCase("path")) {
                path = val;
                if (path == null || path.startsWith("/")) continue;
                return null;
            }
            if (attr.equalsIgnoreCase("domain")) {
                domain = val;
                if (domain == null) continue;
                if (domain.charAt(0) != '.') {
                    domain = "." + domain;
                }
                if (domain.length() < 4) {
                    return null;
                }
                if (domain.charAt(domain.length() - 1) == '.') {
                    return null;
                }
                if (host.toLowerCase().endsWith(domain.toLowerCase())) continue;
                return null;
            }
            sb.append(";" + token);
        }
        String portalDomain = this.getDomain(portalHost);
        if (domain != null && path != null) {
            if (!domain.equalsIgnoreCase(portalDomain) || !path.equalsIgnoreCase(this.getPath(ft.getHttpServletRequest()))) {
                this.domainPathCookieTable.put(cookieName, new domainPathEntry(domain, path));
            }
        } else {
            this.domainPathCookieTable.put(cookieName, new domainPathEntry(domain, path));
        }
        sb.append(";domain=").append(portalDomain).append(";path=/");
        if (path != null) {
            sessionCookie.setPath(path);
        }
        if (domain != null) {
            sessionCookie.setDomain(domain);
        }
        return sb.toString();
    }

    private String getPath(HttpServletRequest request) {
        return request.getContextPath() + request.getServletPath();
    }

    private String getDomain(String host) {
        int index1 = host.lastIndexOf(46);
        if (index1 == -1) {
            return host;
        }
        int index2 = host.substring(0, index1).lastIndexOf(46);
        if (index1 == -1 || index2 == -1) {
            return host;
        }
        return host.substring(index2);
    }

    private void setHeaders(URLConnection uc, HttpServletRequest request) {
        Enumeration names = request.getHeaderNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name == null) continue;
                String nameLC = name.toLowerCase();
                String value = request.getHeader(name);
                logger.log(Level.FINEST, "PSCR_CSPPU0012", new Object[]{name, value});
                if (ignoreHeaders.contains(nameLC) || value == null) continue;
                uc.setRequestProperty(name, value);
                logger.log(Level.FINEST, "PSCR_CSPPU0013", new Object[]{name, value});
            }
        }
    }

    static byte[] readContent(InputStream in, int contentLength) throws IOException {
        byte[] contentbytes = new byte[2048];
        contentbytes = contentLength != -1 ? new byte[contentLength] : new byte[2048];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int count = 0;
        while ((count = in.read(contentbytes)) > 0) {
            baos.write(contentbytes, 0, count);
        }
        byte[] content = baos.toByteArray();
        if (baos != null) {
            baos.close();
        }
        return content;
    }

    private static void setPostData(HttpURLConnection conn, String formData) throws IOException {
        if (!Fetcher.isEmpty(formData)) {
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            OutputStream outSt = conn.getOutputStream();
            DataOutputStream dataOS = new DataOutputStream(outSt);
            dataOS.writeBytes(formData);
            dataOS.flush();
            dataOS.close();
        }
    }

    private String getFormData() {
        String formData = (String)this.config.get(KEY_FORM_DATA);
        return this.replaceValuesInFormData(formData);
    }

    private String getLoginFormData() {
        String loginFormData = (String)this.config.get(KEY_LOGIN_FORM_DATA);
        return this.replaceValuesInFormData(loginFormData);
    }

    private String replaceValuesInFormData(String formData) {
        if (formData != null) {
            int startPos = 0;
            boolean loopFlag = true;
            while (loopFlag) {
                int position = formData.indexOf("[", startPos);
                if (position > 0) {
                    String key;
                    String value;
                    startPos = position + 1;
                    int lastPos = formData.indexOf("]", startPos);
                    if (lastPos <= 0 || (value = this.getPropertyValue(key = formData.substring(startPos, lastPos))) == null) continue;
                    key = "\\[" + key.trim() + "\\]";
                    formData = formData.replaceFirst(key, value);
                    continue;
                }
                loopFlag = false;
            }
        }
        return formData;
    }

    private static boolean isEmpty(String param) {
        if (param == null) {
            return true;
        }
        return param.trim().equals("");
    }

    private static boolean forward(String cookieName, boolean allCookies, List cookiesToForwardList) {
        if (allCookies) {
            return true;
        }
        return cookiesToForwardList.contains(cookieName);
    }

    public static String getContentEncoding(String contentType, byte[] bytes, String MIMEType, String profileCharset) {
        int charsetidx;
        String charset = null;
        if (contentType != null && (charsetidx = contentType.indexOf("charset=")) != -1 && (charset = contentType.substring(charsetidx + 8).trim()) != null && charset.length() != 0) {
            if (charset.startsWith("\"") && charset.endsWith("\"")) {
                charset = charset.substring(1, charset.length() - 1);
            }
            return charset;
        }
        charset = profileCharset;
        if (charset != null && charset.length() != 0) {
            return charset;
        }
        if (MIMEType != null && (MIMEType.equalsIgnoreCase("text/html") || MIMEType.equalsIgnoreCase("text/xml") || MIMEType.equalsIgnoreCase("application/xml")) || MIMEType.equalsIgnoreCase("text/vnd.wap.wml")) {
            charset = Fetcher.getContentEncodingFromContentBytes(bytes);
        }
        return charset;
    }

    private String getPropertyValue(String key) {
        return (String)this.config.get(key);
    }

    private ResourceBundle getResourceBundle() {
        return (ResourceBundle)this.config.get(KEY_RESOURCE_BUNDLE);
    }

    private String getRuleSetId() {
        return (String)this.config.get(KEY_RULESET_ID);
    }

    private String getInputEncoding() {
        return (String)this.config.get(KEY_INPUT_ENCODING);
    }

    private String getLoginUrl() {
        return (String)this.config.get(KEY_LOGIN_URL);
    }

    private String getLogoutUrl() {
        return (String)this.config.get(KEY_LOGOUT_URL);
    }

    static String getContentEncodingFromContentBytes(byte[] contentBytes) {
        int idxCloseArrowBracket;
        int idxMetaTag;
        String charset = null;
        String contentString = new String(contentBytes);
        String str = contentString.toLowerCase();
        int startIdx = 0;
        while ((idxMetaTag = str.indexOf("<meta", startIdx)) != -1 && (idxCloseArrowBracket = str.indexOf(">", idxMetaTag)) != -1) {
            String headerstr = contentString.substring(idxMetaTag, idxCloseArrowBracket);
            String header = headerstr.toLowerCase();
            int idxCharset = header.indexOf("charset=");
            if (idxCharset == -1) {
                startIdx = idxCloseArrowBracket + 1;
                continue;
            }
            int startCE = idxCharset + 8;
            char chquotes = header.charAt(startCE);
            if (chquotes == '\"') {
                ++startCE;
            }
            int endCE = startCE;
            char ch = header.charAt(endCE);
            while (Character.isLetterOrDigit(ch) || ch == '-' || ch == '_') {
                ch = header.charAt(++endCE);
            }
            if (endCE <= startCE) break;
            charset = headerstr.substring(startCE, endCE);
            return charset;
        }
        return charset;
    }

    private String getValueFromNameValuePair(String nameValuePair) {
        int i = nameValuePair.indexOf("=");
        if (i > -1) {
            return nameValuePair.substring(i + 1);
        }
        return null;
    }

    private boolean isHttpAuth() {
        Object obj = this.config.get(KEY_HTTP_AUTH);
        if (obj != null && obj instanceof String) {
            return Boolean.getBoolean(obj.toString());
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    private String getHttpAuthUid() {
        return (String)this.config.get(KEY_HTTP_AUTH_UID);
    }

    private String getHttpAuthPassword() {
        return (String)this.config.get(KEY_HTTP_AUTH_PASSWORD);
    }

    private void setBasicAuthHeader(HttpURLConnection conn) {
        if (this.isHttpAuth()) {
            String uid = this.getHttpAuthUid();
            String password = this.getHttpAuthPassword();
            String userAndPassword = uid + ":" + password;
            BASE64Encoder encoder = new BASE64Encoder();
            String encUidPwd = encoder.encodeBuffer(userAndPassword.getBytes());
            conn.setRequestProperty("Authorization", "Basic " + URLEncoder.encode(encUidPwd));
        }
    }

    private StringBuffer setFormAuth(FetcherThread ft) {
        String loginUrl;
        if (this.isHttpAuth()) {
            return null;
        }
        StringBuffer content = null;
        if (!this.isAuthenticated && !Fetcher.isEmpty(loginUrl = this.getLoginUrl())) {
            String loginFormData = this.getLoginFormData();
            content = this.fetch(ft, loginUrl, this.getLoginFormData());
            this.isAuthenticated = true;
            this.postLoginUrl = ft.getLastFetchedUrl();
        }
        return content;
    }

    public StringBuffer getFilteredContent(int timeOut, HttpServletRequest req, HttpServletResponse res, String urlAsString) {
        String url = this.replaceValuesInFormData(urlAsString);
        FetcherThread ft = this.createFetcherThread(req, res, url);
        return this.getFilteredContent(timeOut, ft);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getFilteredContent(int timeOut, FetcherThread ft) {
        StringBuffer buff = null;
        try {
            ft.start();
            try {
                ft.join(timeOut * 1000);
            }
            catch (InterruptedException ex) {
                buff = new StringBuffer(this.getResourceBundle().getString("timeout"));
                logger.log(Level.INFO, "PSCR_CSPPU0018", ex);
            }
            if (ft.isFinished() && (buff = ft.getContentBuffer()) != null) {
                String contentType = ft.getContentType();
                ContentFilter conFilter = ContentFilterImpl.getInstance(contentType);
                logger.log(Level.FINEST, "PSCR_CSPPU0020", conFilter.getClass().getName());
                buff = conFilter.filter(buff);
            }
        }
        catch (ContentFilterException ex) {
            logger.log(Level.SEVERE, "PSCR_CSPPU0029", ex);
        }
        finally {
            if (ft.isAlive()) {
                ft.terminate();
            }
        }
        return buff;
    }

    public void logout(int timeOut, HttpServletRequest req, HttpServletResponse res) {
        if (this.isAuthenticated) {
            String logoutUrl = this.getLogoutUrl();
            if (!Fetcher.isEmpty(logoutUrl)) {
                FetcherThread ft = this.createFetcherThread(req, res, logoutUrl);
                this.fetch(ft, logoutUrl, null);
            }
            this.isAuthenticated = false;
            this.sessionCookieTable = new Hashtable();
            this.domainPathCookieTable = new Hashtable();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ignoreHeaders.add("host");
        ignoreHeaders.add("cookie");
        ignoreHeaders.add("connection");
        ignoreHeaders.add("content-length");
        ignoreHeaders.add("accept-encoding");
        ignoreHeaders.add("location");
        RewriterModule.initIDSAME();
    }

    static class domainPathEntry {
        String domain = null;
        String path = null;

        domainPathEntry(String d, String p) {
            this.domain = d;
            this.path = p;
        }

        String getPath() {
            return this.path;
        }

        String getDomain() {
            return this.domain;
        }
    }
}

