/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.urlscraper;

import com.sun.portal.providers.urlscraper.ContentFilter;
import com.sun.portal.providers.urlscraper.ContentFilterException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ContentFilterImpl
implements ContentFilter {
    private static final String defaultFilterClassName = "com.sun.portal.providers.urlscraper.ContentFilterImpl";
    private static HashMap filterClassNames = new HashMap();
    private static Map filterClassCache;
    private static ContentFilter defaultFilterInstance;

    ContentFilterImpl() {
    }

    public StringBuffer filter(StringBuffer contentBuf) {
        return contentBuf;
    }

    public static ContentFilter getInstance(String contentType) throws ContentFilterException {
        ContentFilter filter = (ContentFilter)filterClassCache.get(contentType);
        if (filter == null) {
            String filterClassName = (String)filterClassNames.get(contentType);
            if (filterClassName == null) {
                if (defaultFilterInstance == null) {
                    defaultFilterInstance = ContentFilterImpl.createInstance(defaultFilterClassName);
                }
                filter = defaultFilterInstance;
            } else {
                filter = ContentFilterImpl.createInstance(filterClassName);
            }
            ContentFilterImpl.addToCache(contentType, filter);
        }
        return filter;
    }

    private static ContentFilter createInstance(String filterClassName) throws ContentFilterException {
        ContentFilter filterInst = null;
        ReflectiveOperationException ex = null;
        try {
            filterInst = (ContentFilter)Class.forName(filterClassName).newInstance();
        }
        catch (ClassNotFoundException ex1) {
            ex = ex1;
        }
        catch (InstantiationException ex2) {
            ex = ex2;
        }
        catch (IllegalAccessException ex3) {
            ex = ex3;
        }
        if (ex != null) {
            throw new ContentFilterException("ContentFilterImpl.getInstance failed ", ex);
        }
        return filterInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToCache(String contentType, ContentFilter filter) {
        Map map = filterClassCache;
        synchronized (map) {
            filterClassCache.put(contentType, filter);
        }
    }

    static {
        filterClassNames.put("text/vnd.wap.wml", "com.sun.portal.providers.urlscraper.WMLContentFilter");
        filterClassCache = Collections.synchronizedMap(new HashMap());
        defaultFilterInstance = null;
    }
}

