/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.personalnote;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.InvalidEditFormDataException;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PersonalNoteProvider
extends ProfileProviderAdapter {
    private static final String sccsID = "$Id: PersonalNoteProvider.java,v 1.12 2005/09/21 10:45:59 dg154973 Exp $";
    private ResourceBundle bundle = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$providers$personalnote$PersonalNoteProvider == null ? (class$com$sun$portal$providers$personalnote$PersonalNoteProvider = PersonalNoteProvider.class$("com.sun.portal.providers.personalnote.PersonalNoteProvider")) : class$com$sun$portal$providers$personalnote$PersonalNoteProvider));
    static /* synthetic */ Class class$com$sun$portal$providers$personalnote$PersonalNoteProvider;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
        this.bundle = this.getResourceBundle();
    }

    private List setNotes(List notes) throws ProviderException {
        this.setListProperty("notes", notes);
        return notes;
    }

    private List getNotes() throws ProviderException {
        return this.getListProperty("notes");
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        StringBuffer content = new StringBuffer();
        List pnotes = this.getNotes();
        if (!pnotes.isEmpty()) {
            int num_notes = pnotes.size();
            String text_color = this.bundle.getString("textColor");
            String dark_color = this.bundle.getString("darkColor");
            String light_color = this.bundle.getString("lightColor");
            String font_face = this.getStringProperty("fontFace1");
            String linebreak = this.getTemplate("linebreak.template").toString();
            String msgSuffix = this.getTemplate("msgSuffix.template").toString();
            Hashtable<String, String> tagTable = new Hashtable<String, String>();
            tagTable.put("textColor", text_color);
            tagTable.put("fontFace1", font_face);
            for (int i = 0; i < num_notes; ++i) {
                String pnote = pnotes.get(i).toString();
                tagTable.put("bgColor", i % 2 == 0 ? light_color : dark_color);
                StringBuffer msgPrefix = this.getTemplate("msgPrefix.template", tagTable);
                content.append(msgPrefix).append(this.encode(pnote)).append(msgSuffix);
                if (i >= num_notes - 1) continue;
                content.append(linebreak);
            }
            tagTable.clear();
            tagTable.put("note", content.toString());
            tagTable.put("count", Integer.toString(num_notes));
            content = this.getTemplate("content.template", tagTable);
        } else {
            try {
                content = this.getTemplate("noContent.template", new Hashtable());
            }
            catch (ProviderException e) {
                logger.log(Level.FINEST, "PSDT_CSPPPN0001", e);
            }
        }
        return content;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String editContainer = req.getParameter("provider");
        String container = req.getParameter("containerName");
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        tagTable.put("fontFace1", this.getStringProperty("fontFace1"));
        StringBuffer pnoteList = new StringBuffer("");
        List pnotes = this.getNotes();
        int num_notes = pnotes.size();
        for (int i = 0; i < num_notes; ++i) {
            String pnote = pnotes.get(i).toString();
            String string_i = String.valueOf(i);
            tagTable.put("removeId", string_i);
            tagTable.put("nameId", string_i);
            tagTable.put("note", pnote);
            pnoteList.append(this.getTemplate("editNoteListWrapper.template", tagTable));
            tagTable.remove("note");
        }
        tagTable.put("noteCount", Integer.toString(num_notes));
        tagTable.put("noteList", pnoteList.toString());
        tagTable.put("container", container);
        tagTable.put("editContainer", editContainer);
        return this.getTemplate("edit.template", tagTable);
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        this.getProviderContext().contentChanged(this.getName());
        URL next = null;
        int count = 0;
        String noteCount = req.getParameter("noteCount");
        if (noteCount != null) {
            try {
                count = Integer.parseInt(noteCount);
            }
            catch (NumberFormatException e) {
                String err = this.bundle.getString("linesNAN");
                throw new InvalidEditFormDataException(err);
            }
        }
        ArrayList<String> pnotes = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            boolean remove_i = false;
            String param = req.getParameter("remove" + i);
            if (param != null) {
                try {
                    remove_i = Integer.parseInt(param) == 1;
                }
                catch (NumberFormatException ne) {
                    logger.log(Level.FINEST, "PSDT_CSPPPN0002", ne);
                    throw new ProviderException("PersonalNoteProvider.processEdit(): Non numeric value cannot be removed", ne);
                }
            }
            if (remove_i) continue;
            pnotes.add(req.getParameter("name" + i));
        }
        String newNoteValue = req.getParameter("noteTextbox");
        if (newNoteValue != null && !newNoteValue.equals("")) {
            pnotes.add(newNoteValue);
            String addMore = req.getParameter("add_more");
            if (addMore != null && addMore.length() > 0) {
                StringBuffer urlString = new StringBuffer();
                urlString.append(this.getProviderContext().getDesktopURL(req)).append("?action=edit&provider=").append(URLEncoder.encode(req.getParameter("editContainer"))).append("&targetprovider=").append(URLEncoder.encode(this.getName())).append("&containerName=").append(URLEncoder.encode(req.getParameter("container")));
                try {
                    next = new URL(urlString.toString());
                }
                catch (MalformedURLException me) {
                    throw new ProviderException(this.getName() + ".processEdit()", me);
                }
            }
        }
        pnotes.trimToSize();
        this.setNotes(pnotes);
        String windowPref = req.getParameter("windowPref");
        if (windowPref != null) {
            this.setStringProperty("windowPref", windowPref);
        }
        return next;
    }

    public boolean isEditable() throws ProviderException {
        boolean editable = false;
        if (this.getTemplatePath("edit.template") != null && this.getBooleanProperty("isEditable")) {
            editable = true;
        }
        return editable;
    }

    public boolean isPresentable() {
        logger.log(Level.FINER, "PSDT_CSPPPN0003");
        return false;
    }

    public boolean isPresentable(HttpServletRequest req) {
        boolean isPresentable = false;
        ProviderContext pc = this.getProviderContext();
        try {
            if (this.getTemplatePath("content.template") != null) {
                isPresentable = true;
            }
        }
        catch (ProviderException pe) {
            logger.log(Level.FINE, "PSDT_CSPPPN0004");
        }
        return isPresentable;
    }

    private String encode(String raw_data) throws ProviderException {
        String encoded_data = null;
        try {
            encoded_data = this.getProviderContext().escape(raw_data);
        }
        catch (ProviderContextException e) {
            logger.log(Level.FINE, "PSDT_CSPPPN0005", e);
            throw new ProviderException("Error escaping data", e);
        }
        return encoded_data;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

