/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.notes;

import com.sun.portal.desktop.util.Integers;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.InvalidEditFormDataException;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NotesProvider
extends ProfileProviderAdapter {
    private File motdFile = null;
    private String editContainer = null;
    private String container = null;
    private String fileLockingLogger = "com.org.portal.locklogger";
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$providers$notes$NotesProvider == null ? (class$com$sun$portal$providers$notes$NotesProvider = NotesProvider.class$("com.sun.portal.providers.notes.NotesProvider")) : class$com$sun$portal$providers$notes$NotesProvider));
    private static final String COMMON_NAME = "cn";
    private ResourceBundle bundle = null;
    static /* synthetic */ Class class$com$sun$portal$providers$notes$NotesProvider;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FileLock getLock(String filename, File lockFile) throws ProviderException {
        int timeout = 100;
        FileLock filelock = null;
        try {
            FileOutputStream fo = new FileOutputStream(lockFile);
            FileChannel fc = fo.getChannel();
            filelock = fc.lock();
            if (filelock == null) return filelock;
            while (true) {
                if (this.checkForMyHandler(filename)) {
                    Thread.sleep(timeout);
                    continue;
                }
                Logger logger = Logger.getLogger(this.fileLockingLogger);
                synchronized (logger) {
                    if (this.addMyHandler(filename)) {
                        return filelock;
                    }
                }
            }
        }
        catch (IOException ioe) {
            Object record;
            if (logger.isLoggable(Level.FINE)) {
                record = new LogRecord(Level.FINE, "PSDT_CSPPN0001");
                ((LogRecord)record).setLoggerName(logger.getName());
                ((LogRecord)record).setParameters(new Object[]{filename});
                ((LogRecord)record).setThrown(ioe);
                logger.log((LogRecord)record);
            }
            this.Release(filelock, filename, lockFile);
            record = Logger.getLogger(this.fileLockingLogger);
            synchronized (record) {
                this.removeMyHandler(filename);
                throw new ProviderException(ioe.getMessage());
            }
        }
        catch (InterruptedException ie) {
            if (logger.isLoggable(Level.FINEST)) {
                LogRecord record = new LogRecord(Level.FINEST, "PSDT_CSPPN0001");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{filename});
                record.setThrown(ie);
                logger.log(record);
            }
            this.Release(filelock, filename, lockFile);
            throw new ProviderException(" Error while waiting to read the notes file");
        }
    }

    public boolean isPresentable(HttpServletRequest request) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        FileLock filelock;
        ArrayList<String> errList = new ArrayList<String>();
        boolean isFormatCorrect = false;
        StringBuffer content = new StringBuffer();
        ProviderContext pc = this.getProviderContext();
        String filename = this.getStringProperty("location");
        File lockFile = new File(filename + ".lock");
        this.motdFile = new File(filename);
        try {
            this.motdFile.createNewFile();
        }
        catch (IOException ioe) {
            return null;
        }
        if (this.motdFile.exists() && this.motdFile.length() == 0L) {
            logger.log(Level.INFO, "PSDT_CSPPN0007");
            return this.getTemplate("noContent.template", new Hashtable());
        }
        String readLines = this.getStringProperty("lines");
        int lines = Integer.parseInt(readLines);
        Locale locale = null;
        locale = pc.getLocale();
        String timezone = this.getStringProperty("timezone");
        TimeZone tz = TimeZone.getTimeZone(timezone);
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle();
        }
        if ((filelock = this.getLock(filename, lockFile)) != null) {
            int nonEmptyLines;
            Hashtable<String, String> tagTable;
            block28: {
                BufferedReader in = null;
                try {
                    in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.motdFile), "UTF-8"));
                }
                catch (UnsupportedEncodingException uec) {
                    logger.log(Level.FINE, "PSDT_CSPPN0002", uec);
                    this.Release(filelock, filename, lockFile);
                    throw new ProviderException("error creating input stream", uec);
                }
                catch (FileNotFoundException fnfe) {
                    logger.log(Level.FINE, "PSDT_CSPPN0002", fnfe);
                    this.Release(filelock, filename, lockFile);
                    throw new ProviderException("error creating input stream", fnfe);
                }
                tagTable = new Hashtable<String, String>();
                tagTable.put("fontface", this.getStringProperty("fontFace1"));
                StringBuffer linebreak = this.getTemplate("linebreak.template");
                StringBuffer msgSuffix = this.getTemplate("msgSuffix.template");
                nonEmptyLines = 0;
                MessageFormat mf = new MessageFormat("");
                String textColor = this.bundle.getString("textColor");
                String darkColor = this.bundle.getString("darkColor");
                String lightColor = this.bundle.getString("lightColor");
                String line = null;
                for (int i = 0; i < lines; ++i) {
                    line = in.readLine();
                    if (line == null) continue;
                    ++nonEmptyLines;
                    String bgColor = i % 2 == 0 ? lightColor : darkColor;
                    StringTokenizer tok = new StringTokenizer(line, "|");
                    String dateMessage = this.bundle.getString("dateMessage");
                    mf.setLocale(locale);
                    mf.applyPattern(dateMessage);
                    ((DateFormat)mf.getFormats()[0]).setTimeZone(tz);
                    String user = null;
                    String date = null;
                    String mesg = null;
                    tagTable.put("textcolor", textColor);
                    try {
                        user = (String)tok.nextElement();
                        String time = (String)tok.nextElement();
                        long ms = new Long(time);
                        Date d = new Date(ms);
                        date = mf.format(new Object[]{d}, new StringBuffer(128), (FieldPosition)null).toString();
                        mesg = (String)tok.nextElement();
                    }
                    catch (NoSuchElementException nse) {
                        logger.log(Level.FINER, "PSDT_CSPPN0003", nse);
                    }
                    String escapedUser = null;
                    String escapedDate = null;
                    String escapedMesg = null;
                    boolean canProceed = true;
                    try {
                        escapedUser = pc.escape(user);
                        escapedDate = pc.escape(date);
                        escapedMesg = pc.escape(mesg);
                        isFormatCorrect = true;
                    }
                    catch (ProviderContextException e) {
                        errList.add(new String("Data in incorrect format in line " + i));
                        canProceed = false;
                    }
                    catch (Exception e) {
                        errList.add(new String("Data in incorrect format in line " + i));
                        canProceed = false;
                    }
                    if (!canProceed) continue;
                    StringBuffer separator = this.getTemplate("separator.template", tagTable);
                    tagTable.put("rowcolor", bgColor);
                    StringBuffer msgPrefix = this.getTemplate("msgPrefix.template", tagTable);
                    tagTable.remove("rowcolor");
                    StringBuffer row = new StringBuffer().append(msgPrefix).append(escapedUser).append(separator).append(escapedDate).append(separator).append(escapedMesg).append(msgSuffix);
                    if (i < lines - 1) {
                        row.append(linebreak);
                    }
                    content.append(row);
                }
                if (!isFormatCorrect) {
                    logger.log(Level.FINEST, "PSDT_CSPPN0004");
                    throw new ProviderException("NotesProvider.getContent(): Error escaping data");
                }
                Object var40_49 = null;
                if (in == null) break block28;
                try {
                    in.close();
                    break block28;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                {
                    break block28;
                    catch (IOException ioe) {
                        logger.log(Level.FINEST, "PSDT_CSPPN0005", ioe);
                        this.Release(filelock, filename, lockFile);
                        StringBuffer stringBuffer = null;
                        Object var40_50 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                        }
                        this.Release(filelock, filename, lockFile);
                        return stringBuffer;
                    }
                }
                catch (Throwable throwable) {
                    Object var40_51 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    this.Release(filelock, filename, lockFile);
                    throw throwable;
                }
            }
            this.Release(filelock, filename, lockFile);
            tagTable.clear();
            if (nonEmptyLines > 0) {
                tagTable.put("note", content.toString());
                tagTable.put("count", Integer.toString(nonEmptyLines));
                content = this.getTemplate("content.template", tagTable);
            } else {
                content = this.getTemplate("noContent.template", new Hashtable());
            }
        }
        return content;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        StringBuffer content = new StringBuffer();
        this.editContainer = req.getParameter("provider");
        this.container = req.getParameter("containerName");
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle();
        }
        String newMessage = this.bundle.getString("newMessage");
        String lines = "";
        String message = "";
        if (req.getParameter("error") != null) {
            if (req.getParameter("lines") != null) {
                lines = req.getParameter("lines");
            }
            if (req.getParameter("message") != null) {
                message = req.getParameter("message");
            }
        } else {
            lines = this.getStringProperty("lines");
        }
        String fontFace = this.getStringProperty("fontFace1");
        Integer maxLines = Integers.get((int)Integer.parseInt(this.getStringProperty("maxLines")));
        String linesToDisplay = this.bundle.getString("linesToDisplay");
        MessageFormat mf = new MessageFormat(linesToDisplay);
        Locale locale = null;
        locale = this.getProviderContext().getLocale();
        mf.setLocale(locale);
        String formattedLinesToDisplay = mf.format(new Object[]{maxLines}, new StringBuffer(), (FieldPosition)null).toString();
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        tagTable.put("fontface", fontFace);
        tagTable.put("messagelabel", newMessage);
        tagTable.put("message", message);
        tagTable.put("lineslabel", formattedLinesToDisplay);
        tagTable.put("numlines", lines);
        return this.getTemplate("edit.template", tagTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        block29: {
            this.getProviderContext().contentChanged(this.getName());
            msg = req.getParameter("message");
            lines = req.getParameter("lines");
            maxLines = this.getStringProperty("maxLines");
            this.editContainer = req.getParameter("provider");
            this.container = req.getParameter("containerName");
            if (this.bundle == null) {
                this.bundle = this.getResourceBundle();
            }
            if (lines != null && !lines.trim().equals("")) {
                try {
                    if (Integer.parseInt(lines) > Integer.parseInt(maxLines)) {
                        err = this.bundle.getString("maxLinesExceeded");
                        nextURLString = new StringBuffer();
                        next = null;
                        if (this.container == null) return next;
                        if (this.editContainer == null) return next;
                        nextURLString.append(this.getProviderContext().getDesktopURL(req)).append("?action=edit&provider=").append(URLEncoder.encode(this.editContainer)).append("&targetprovider=").append(URLEncoder.encode(this.getName())).append("&containerName=").append(URLEncoder.encode(this.container)).append("&lines=").append(URLEncoder.encode(lines)).append("&message=").append(URLEncoder.encode(msg)).append("&error=").append(URLEncoder.encode(err + " : " + maxLines));
                        return new URL(nextURLString.toString());
                    }
                }
                catch (NumberFormatException e) {
                    NotesProvider.logger.log(Level.FINEST, "PSDT_CSPPN0006", e);
                    err = this.bundle.getString("linesNAN");
                    throw new InvalidEditFormDataException(err);
                }
                catch (MalformedURLException me) {
                    NotesProvider.logger.log(Level.FINEST, "PSDT_CSPPN0006", me);
                    throw new ProviderException("NotesProvider.processEdit() : " + me);
                }
                this.setStringProperty("lines", lines);
            }
            if (msg == null) return null;
            if (msg.trim().equals("")) {
                return null;
            }
            line = null;
            pw = null;
            v = new ArrayList<String>();
            filename = this.getStringProperty("location");
            this.motdFile = new File(filename);
            try {
                this.motdFile.createNewFile();
            }
            catch (IOException ioe) {
                NotesProvider.logger.log(Level.FINEST, "PSDT_CSPPN0006", ioe);
                return null;
            }
            lockFile = new File(filename + ".lock");
            filelock = this.getLock(filename, lockFile);
            if (filelock == null) return null;
            in = null;
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.motdFile), "UTF-8"));
            }
            catch (UnsupportedEncodingException uec) {
                NotesProvider.logger.log(Level.FINEST, "PSDT_CSPPN0006", uec);
                this.Release(filelock, filename, lockFile);
                throw new ProviderException("error creating input stream", uec);
            }
            catch (FileNotFoundException fnfe) {
                NotesProvider.logger.log(Level.FINEST, "PSDT_CSPPN0006", fnfe);
                this.Release(filelock, filename, lockFile);
                throw new ProviderException("error creating input stream", fnfe);
            }
            try {
                try {
                    while ((line = in.readLine()) != null) {
                        v.add(line);
                    }
                    var16_26 = null;
                    if (in == null) break block29;
                }
                catch (IOException ioe) {
                    NotesProvider.logger.log(Level.FINEST, "PSDT_CSPPN0006", ioe);
                    this.Release(filelock, filename, lockFile);
                    var14_32 = null;
                    var16_27 = null;
                    if (in == null) return var14_32;
                    try {
                        in.close();
                        return var14_32;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return var14_32;
                }
            }
            catch (Throwable var15_34) {
                var16_28 = null;
                if (in == null) throw var15_34;
                ** try [egrp 5[TRYBLOCK] [9 : 691->699)] { 
lbl87:
                // 1 sources

                in.close();
                throw var15_34;
lbl89:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
                throw var15_34;
            }
            try {}
            catch (IOException ioe) {}
            in.close();
        }
        try {
            try {
                pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.motdFile.toString()), "UTF-8")));
                date = new Date();
                time = Long.toString(date.getTime());
                user = new StringBuffer();
                context = this.getProviderContext();
                user.append(context.getStringAttribute("cn", context.getLocale()));
                pw.println(user.toString() + "|" + time + "|" + msg);
                i = v.iterator();
                while (i.hasNext()) {
                    line = (String)i.next();
                    pw.println(line);
                }
                var19_36 = null;
                if (pw != null) {
                    pw.flush();
                    pw.close();
                }
                this.Release(filelock, filename, lockFile);
                return null;
            }
            catch (UnsupportedEncodingException uec) {
                NotesProvider.logger.log(Level.FINEST, "PSDT_CSPPN0006", uec);
                throw new ProviderException("error creating output stream", uec);
            }
            catch (FileNotFoundException fnfe) {
                NotesProvider.logger.log(Level.FINEST, "PSDT_CSPPN0006", fnfe);
                throw new ProviderException("error creating output stream", fnfe);
            }
        }
        catch (Throwable var18_38) {
            var19_37 = null;
            if (pw != null) {
                pw.flush();
                pw.close();
            }
            this.Release(filelock, filename, lockFile);
            throw var18_38;
        }
    }

    private boolean checkForMyHandler(String fileName) {
        Logger logger = Logger.getLogger(this.fileLockingLogger);
        Handler[] handlers = logger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler myHandler = handlers[i];
            if (!myHandler.getFormatter().getHead(myHandler).equals(fileName)) continue;
            return true;
        }
        return false;
    }

    private boolean addMyHandler(final String fileName) throws IOException {
        if (this.checkForMyHandler(fileName)) {
            return false;
        }
        Logger logger = Logger.getLogger(this.fileLockingLogger);
        Handler myHandler = new Handler(){

            public void publish(LogRecord rec) {
            }

            public void close() {
            }

            public void flush() {
            }
        };
        myHandler.setFormatter(new Formatter(){

            public String getHead(Handler handler) {
                return fileName;
            }

            public String format(LogRecord record) {
                return null;
            }
        });
        logger.addHandler(myHandler);
        return true;
    }

    private void removeMyHandler(String fileName) {
        Logger logger = Logger.getLogger(this.fileLockingLogger);
        Handler[] handlers = logger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler myHandler = handlers[i];
            if (!myHandler.getFormatter().getHead(myHandler).equals(fileName)) continue;
            logger.removeHandler(myHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Release(FileLock filelock, String filename, File lockFile) {
        if (filelock != null) {
            try {
                filelock.release();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        lockFile.delete();
        Logger logger = Logger.getLogger(this.fileLockingLogger);
        synchronized (logger) {
            this.removeMyHandler(filename);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

