/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.jsp;

import com.sun.portal.desktop.context.ProviderContextThreadLocalizer;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.jsp.JSPProvider;
import com.sun.portal.providers.jsp.JspServletEnvironment;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

class JspRequestDispatcher
implements RequestDispatcher {
    private JspServletEnvironment jspEnv;
    private ProviderContext providerContext;
    private String path;
    private String baseuri;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$providers$jsp$JspRequestDispatcher == null ? (class$com$sun$portal$providers$jsp$JspRequestDispatcher = JspRequestDispatcher.class$("com.sun.portal.providers.jsp.JspRequestDispatcher")) : class$com$sun$portal$providers$jsp$JspRequestDispatcher));
    static /* synthetic */ Class class$com$sun$portal$providers$jsp$JspRequestDispatcher;

    public JspRequestDispatcher(String path, JspServletEnvironment jspEnv) {
        this.path = path;
        this.baseuri = path;
        this.jspEnv = jspEnv;
        this.providerContext = ProviderContextThreadLocalizer.get();
        int index = path.indexOf(63);
        if (index != -1) {
            this.baseuri = path.substring(0, index);
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this.path.length() == 0 || this.path == null) {
            return;
        }
        StringBuffer icontent = new StringBuffer();
        try {
            icontent = this.baseuri.endsWith(".jsp") ? this.getJspResource(request, response) : this.getStaticResource();
        }
        catch (ServletException se) {
            if (logger.isLoggable(Level.INFO)) {
                LogRecord record = new LogRecord(Level.INFO, "PSDT_CSPPJ0010");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{this.baseuri});
                record.setThrown(se);
                logger.log(record);
            }
            throw se;
        }
        if (icontent != null) {
            PrintWriter pw = response.getWriter();
            pw.print(icontent.toString());
            pw.flush();
        }
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.include(request, response);
    }

    private StringBuffer getJspResource(ServletRequest request, ServletResponse response) throws ServletException {
        Hashtable parameters = this.getRequestParameters(request);
        HttpServletRequest hrequest = (HttpServletRequest)request;
        HttpServletResponse hresponse = (HttpServletResponse)response;
        StringBuffer buffer = new StringBuffer();
        JSPProvider jp = (JSPProvider)hrequest.getAttribute("com.sun.portal.providers.jsp.JSPProvider");
        if (jp != null) {
            try {
                buffer = jp.includeJspPage(this.path, parameters, hrequest, hresponse);
            }
            catch (ProviderException pe) {
                logger.log(Level.FINE, "PSDT_CSPPJ0013", new Object[]{this.path, parameters});
                throw new ServletException("Problem processing JSP: " + this.path, (Throwable)pe);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "PSDT_CSPPJ0013", new Object[]{this.path, parameters});
                throw new ServletException("Problem processing JSP: " + this.path, (Throwable)e);
            }
        }
        return buffer;
    }

    private StringBuffer getStaticResource() throws ServletException {
        StringBuffer buffer = new StringBuffer();
        try {
            FileReader fr = new FileReader(this.jspEnv.getRealPath(this.path));
            char[] c = new char[4096];
            int read = 0;
            while ((read = fr.read(c)) != -1) {
                buffer.append(c, 0, read);
            }
            fr.close();
        }
        catch (FileNotFoundException fnf) {
            if (logger.isLoggable(Level.FINE)) {
                LogRecord record = new LogRecord(Level.FINE, "PSDT_CSPPJ0014");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{this.path});
                record.setThrown(fnf);
                logger.log(record);
            }
            throw new ServletException("File Not Found: " + this.path, (Throwable)fnf);
        }
        catch (IOException ioe) {
            if (logger.isLoggable(Level.FINE)) {
                LogRecord record = new LogRecord(Level.FINE, "PSDT_CSPPJ0014");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{this.path});
                record.setThrown(ioe);
                logger.log(record);
            }
            throw new ServletException("Problem processing file: " + this.path, (Throwable)ioe);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                LogRecord record = new LogRecord(Level.FINE, "PSDT_CSPPJ0014");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{this.path});
                record.setThrown(e);
                logger.log(record);
            }
            throw new ServletException("Problem processing file: " + this.path, (Throwable)e);
        }
        return buffer;
    }

    private Hashtable getRequestParameters(ServletRequest req) throws ServletException {
        Hashtable parameters = new Hashtable();
        int index = this.path.indexOf(63);
        String qstring = null;
        if (index != -1) {
            qstring = this.path.substring(index + 1);
            try {
                parameters = HttpUtils.parseQueryString((String)qstring);
            }
            catch (IllegalArgumentException e) {
                if (logger.isLoggable(Level.FINE)) {
                    LogRecord record = new LogRecord(Level.FINE, "PSDT_CSPPJ0015");
                    record.setLoggerName(logger.getName());
                    record.setParameters(new Object[]{this.path});
                    record.setThrown(e);
                    logger.log(record);
                }
                throw new ServletException("Problem parsing query string:" + qstring, (Throwable)e);
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    LogRecord record = new LogRecord(Level.FINE, "PSDT_CSPPJ0015");
                    record.setLoggerName(logger.getName());
                    record.setParameters(new Object[]{this.path});
                    record.setThrown(e);
                    logger.log(record);
                }
                throw new ServletException("Problem parsing query string:" + qstring, (Throwable)e);
            }
        }
        Enumeration pe = req.getParameterNames();
        while (pe.hasMoreElements()) {
            String pname = (String)pe.nextElement();
            parameters.put(pname, req.getParameterValues(pname));
        }
        return parameters;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

