/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.error;

import com.sun.portal.desktop.TypedException;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.UnknownEditTypeException;
import com.sun.portal.providers.util.ProviderProperties;
import com.sun.portal.util.ResourceLoader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ErrorProvider
implements ProviderProperties,
Provider {
    protected static Map templates = null;
    private String exceptionType = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$providers$error$ErrorProvider == null ? (class$com$sun$portal$providers$error$ErrorProvider = ErrorProvider.class$("com.sun.portal.providers.error.ErrorProvider")) : class$com$sun$portal$providers$error$ErrorProvider));
    static /* synthetic */ Class class$com$sun$portal$providers$error$ErrorProvider;

    public void init(String name, HttpServletRequest req) throws ProviderException {
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        Throwable e = (Throwable)req.getAttribute(this.getName() + ".exception");
        DesktopContext dc = (DesktopContext)req.getAttribute(this.getName() + ".desktopContext");
        DesktopAppContext dac = (DesktopAppContext)req.getAttribute(this.getName() + ".desktopAppContext");
        if (e instanceof TypedException) {
            String redirectURL = this.getRedirectURL(req, (TypedException)e);
            this.redirect(req, redirectURL);
        }
        StringBuffer ob = null;
        String app = this.getName();
        String provider = "error";
        if (dc != null) {
            String locale = dc.getLocaleString();
            String staticContent = dc.getStaticContentPath();
            Hashtable<String, CharSequence> tags = new Hashtable<String, CharSequence>();
            tags.put("localeString", locale);
            tags.put("staticContent", staticContent);
            String logoutUrl = dc.getLogoutURL();
            if (logoutUrl != null) {
                tags.put("logoutUrl", logoutUrl);
            }
            tags.put("banner", dc.getTemplate(app, provider, "banner.template", tags));
            tags.put("bulletColor", dc.getTemplate(app, provider, "bulletColor.js", tags));
            StringWriter swriter = new StringWriter(160);
            PrintWriter buf = new PrintWriter((Writer)swriter, true);
            if (e != null) {
                e.printStackTrace(buf);
                buf.flush();
            }
            tags.put("stackTrace", swriter.toString());
            ob = dc.getTemplate(app, provider, this.getTemplateName(e), tags);
        } else if (dac != null && dc == null) {
            if (logger.isLoggable(Level.INFO)) {
                LogRecord record = new LogRecord(Level.INFO, "PSDT_CSPPE0001");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{this.getTemplateName(e)});
                record.setThrown(e);
                logger.log(record);
            }
            String type = dac.getDefaultDesktopType();
            String locale = Locale.getDefault().toString();
            String clientPath = dac.getClientPath(dac.getDefaultClientType());
            Hashtable<String, CharSequence> tags = new Hashtable<String, CharSequence>();
            tags.put("banner", dac.getTemplate(type, locale, app, provider, clientPath, "banner_nocontext.template", tags, dac.getTemplateBaseDir(), null));
            tags.put("bulletColor", dac.getTemplate(type, locale, app, provider, clientPath, "bulletColor.js", tags, dac.getTemplateBaseDir(), null));
            StringWriter swriter = new StringWriter(160);
            PrintWriter buf = new PrintWriter((Writer)swriter, true);
            if (e != null) {
                e.printStackTrace(buf);
                buf.flush();
            }
            tags.put("stackTrace", swriter.toString());
            ob = dac.getTemplate(type, locale, app, provider, clientPath, this.getTemplateName(e), tags, dac.getTemplateBaseDir(), null);
        } else {
            try {
                if (logger.isLoggable(Level.SEVERE)) {
                    LogRecord record = new LogRecord(Level.SEVERE, "PSDT_CSPPE0002");
                    record.setLoggerName(logger.getName());
                    record.setParameters(new Object[]{this.getTemplateName(e)});
                    record.setThrown(e);
                    logger.log(record);
                }
                res.sendError(500);
            }
            catch (IOException i) {
                throw new ProviderException("ErrorProvider:getContent", i);
            }
            return null;
        }
        return ob;
    }

    protected void redirect(HttpServletRequest req, String redirectURL) {
        if (redirectURL != null && !redirectURL.trim().equals("")) {
            DesktopContext dc = (DesktopContext)req.getAttribute(this.getName() + ".desktopContext");
            DesktopAppContext appContext = (DesktopAppContext)req.getAttribute(this.getName() + ".desktopAppContext");
            HttpServletResponse res = (HttpServletResponse)req.getAttribute(this.getName() + ".response");
            Writer out = null;
            if (!req.getMethod().equalsIgnoreCase("head")) {
                String clientType = appContext.getClientType(req);
                String clientPath = appContext.getClientPath(clientType);
                StringBuffer redirect = null;
                if (clientType != null) {
                    String contentType = appContext.getContentType(clientType);
                    String charset = null;
                    if (dc != null) {
                        charset = dc.getCharset();
                    } else {
                        Locale locale = Locale.getDefault();
                        charset = appContext.getCharset(clientType, locale);
                    }
                    String type = appContext.getDefaultDesktopType();
                    if (dc != null) {
                        redirectURL = dc.encodeURL(redirectURL);
                        type = dc.getDesktopType();
                    }
                    Hashtable<String, String> tags = new Hashtable<String, String>();
                    tags.put("url", redirectURL);
                    redirect = appContext.getTemplate(type, Locale.getDefault().toString(), null, null, clientPath, "redirect.template", tags, appContext.getTemplateBaseDir());
                    logger.log(Level.FINEST, "PSDT_CSPPE0003", new Object[]{redirectURL, redirect});
                    try {
                        out = ErrorProvider.getWriter(res, contentType, charset);
                        if (redirect != null) {
                            out.write(redirect.toString());
                        } else {
                            logger.log(Level.INFO, "PSDT_CSPPE0004");
                        }
                    }
                    catch (IOException ioe) {
                        logger.log(Level.WARNING, "PSDT_CSPPE0005", ioe);
                    }
                }
            }
            res.setStatus(302);
            res.setHeader("Location", redirectURL);
        }
    }

    private static Writer getWriter(HttpServletResponse res, String contentType, String charset) throws IOException {
        if (contentType != null) {
            if (charset != null) {
                res.setContentType(contentType + "; charset=" + charset);
            } else {
                res.setContentType(contentType);
            }
        }
        OutputStreamWriter writer = null;
        writer = new OutputStreamWriter((OutputStream)res.getOutputStream(), charset);
        return writer;
    }

    protected String getRedirectURL(HttpServletRequest req, TypedException te) {
        String redirectURL = null;
        String propertiesFile = (String)req.getAttribute(this.getName() + ".propertiesFile");
        if (propertiesFile != null && !propertiesFile.trim().equals("")) {
            ResourceLoader resourceLoader = ResourceLoader.getInstance((Properties)System.getProperties());
            Properties properties = new Properties();
            try {
                properties.load(resourceLoader.getResourceAsStream(propertiesFile));
            }
            catch (Exception e) {
                // empty catch block
            }
            redirectURL = properties.getProperty(te.getType());
        }
        return redirectURL;
    }

    protected String getTemplateName(Throwable e) {
        String template = null;
        String exceptionType = null;
        if (e instanceof TypedException) {
            exceptionType = ((TypedException)e).getType();
            template = (String)templates.get(exceptionType);
        }
        if (template == null) {
            template = "error.template";
        }
        return template;
    }

    public StringBuffer getContent(Map m) throws ProviderException {
        return null;
    }

    public StringBuffer getEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        return null;
    }

    public StringBuffer getEdit(Map m) throws ProviderException {
        return null;
    }

    public int getEditType() throws UnknownEditTypeException {
        return 0;
    }

    public URL processEdit(Map m) throws ProviderException {
        return null;
    }

    public URL processEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        return null;
    }

    public boolean isEditable() throws ProviderException {
        return true;
    }

    public boolean isPresentable() {
        return true;
    }

    public boolean isPresentable(HttpServletRequest req) {
        return true;
    }

    public String getTitle() throws ProviderException {
        return null;
    }

    public String getName() {
        return "Error";
    }

    public String getDescription() throws ProviderException {
        return null;
    }

    public URL getHelp(HttpServletRequest req) throws ProviderException {
        return null;
    }

    public long getRefreshTime() throws ProviderException {
        return 0L;
    }

    public int getWidth() throws ProviderException {
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        templates = new HashMap();
        templates.put("nonEditableChannel", "noneditablechannel.template");
        templates.put("noPrivilege", "noprivilege.template");
        templates.put("unknownChannel", "unknownchannel.template");
        templates.put("session", "session.template");
    }
}

