/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.containers.template.tab;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.InvalidEditFormDataException;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.jsp.tab.ModifiableTab;
import com.sun.portal.providers.containers.jsp.tab.TabContainer;
import com.sun.portal.providers.containers.jsp.tab.UnmodifiableTab;
import com.sun.portal.providers.containers.jsp.tab.util.TabData;
import com.sun.portal.providers.containers.jsp.tab.util.TabException;
import com.sun.portal.providers.containers.template.TemplateContainerProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateTabContainerProvider
extends TemplateContainerProvider
implements TabContainer {
    private TabData tabdata = null;
    private ResourceBundle bundle = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$providers$containers$template$tab$TemplateTabContainerProvider == null ? (class$com$sun$portal$providers$containers$template$tab$TemplateTabContainerProvider = TemplateTabContainerProvider.class$("com.sun.portal.providers.containers.template.tab.TemplateTabContainerProvider")) : class$com$sun$portal$providers$containers$template$tab$TemplateTabContainerProvider));
    static /* synthetic */ Class class$com$sun$portal$providers$containers$template$tab$TemplateTabContainerProvider;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
        this.bundle = this.getResourceBundle();
        this.tabdata = new TabData(this.getContainerProviderContext(), this.getName(), this.bundle);
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String s = req.getParameter(this.getName() + ".setSelected");
        if (s != null && s.length() > 0) {
            this.setSelectedTabName(s);
        }
        StringBuffer tabTemplates = new StringBuffer();
        Hashtable tagTable = this.getStandardTags(req);
        String selected = this.getSelectedTabName();
        List tabs = this.getSelectedTabs();
        boolean righttoleft = this.getBooleanProperty("rtl");
        if (righttoleft) {
            tagTable.put("tabrtl", "true");
        } else {
            tagTable.put("tabrtl", "false");
        }
        for (int i = 0; i < tabs.size(); ++i) {
            UnmodifiableTab tab = (UnmodifiableTab)tabs.get(i);
            tagTable.put(this.getName() + ".tabName", tab.getDisplayname());
            URL url = this.getTabURL(tab, req);
            tagTable.put(this.getName() + ".tabURL", url.toString());
            String tmpl = null;
            tmpl = selected.equals(tab.getName()) ? "selectedTab.template" : "tab.template";
            StringBuffer tabTemplate = this.getTemplate(tmpl, tagTable);
            if (!righttoleft) {
                tabTemplates.append(tabTemplate);
                continue;
            }
            tabTemplates.insert(0, tabTemplate.toString());
        }
        tagTable.put("tabs", tabTemplates);
        StringBuffer tabcontent = righttoleft ? this.getTemplate("tabs_r.template", tagTable) : this.getTemplate("tabs.template", tagTable);
        req.setAttribute("selectedTabName", (Object)this.getSelectedTab().getDisplayname());
        tagTable.put("tabContainerName", this.getName());
        tagTable.put("frontContainerName", this.getSelectedTabName());
        StringBuffer selectedChannelContent = this.getContainerProviderContext().getContent(req, res, this.getName(), selected);
        tabcontent = tabcontent.append(selectedChannelContent.toString());
        tagTable.put("content", tabcontent.toString());
        tagTable.put("help_link", this.getHelpLink("frontPage", req));
        StringBuffer content = this.getTemplate("display.template", tagTable);
        return content;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String editPage = req.getParameter("page");
        String inputTabName = req.getParameter("inputTabName");
        String inputDescName = req.getParameter("inputDescName");
        if (inputTabName == null) {
            inputTabName = "";
        }
        if (inputDescName == null) {
            inputDescName = "";
        }
        Hashtable tagTable = this.getStandardTags(req);
        tagTable.put(this.getName() + ".tabList", this.getTabList());
        tagTable.put(this.getName() + ".tabTopics", this.getTabTopics());
        tagTable.put("frontContainerName", this.getSelectedTabName());
        tagTable.put("tabContainerName", this.getName());
        tagTable.put("help_link", this.getHelp(req).toString());
        tagTable.put("TemplateTabContainer", this.getName());
        if (editPage != null && editPage.equals("make")) {
            tagTable.put(this.getName() + ".editPage", this.getTemplate("makeNewTab.template").toString());
        } else {
            tagTable.put(this.getName() + ".editPage", this.getTemplate("removeRenameTab.template").toString());
        }
        tagTable.put("inputTabName", inputTabName);
        tagTable.put("inputDescName", inputDescName);
        StringBuffer content = this.getTemplate("editForm.template", tagTable);
        return content;
    }

    private String getTabList() throws ProviderException {
        List tabs = this.getSelectedTabs();
        String selected = this.getSelectedTabName();
        String start = this.getStartTabName();
        StringBuffer content = new StringBuffer(1024);
        for (int i = 0; i < tabs.size(); ++i) {
            UnmodifiableTab tab = (UnmodifiableTab)tabs.get(i);
            boolean isStart = false;
            if (tab.getName().equals(start)) {
                isStart = true;
            }
            content.append(this.makeRemove(tab, isStart));
        }
        return content.toString();
    }

    private String getTabTopics() throws ProviderException {
        List availableTabs = this.getAvailableTabs();
        UnmodifiableTab makeTab = this.getMakeTab();
        StringBuffer content = new StringBuffer(1024);
        for (int i = 0; i < availableTabs.size(); ++i) {
            UnmodifiableTab tab = (UnmodifiableTab)availableTabs.get(i);
            if (!tab.isPredefined()) continue;
            content.append(this.makeTopic(tab));
        }
        content.append(this.makeTopic(makeTab, true));
        return content.toString();
    }

    private StringBuffer makeTopic(UnmodifiableTab t) {
        return this.makeTopic(t, false);
    }

    private StringBuffer makeTopic(UnmodifiableTab t, boolean checked) {
        StringBuffer content = new StringBuffer(128);
        content.append("<tr>\n").append("<td>\n").append("<input type=\"radio\" name=\"").append(this.getName() + ".tabTopic\" ").append("value=\"" + t.getName() + "\"");
        if (checked) {
            content.append(" checked");
        }
        content.append(">\n").append("</td>\n").append("<td>\n").append("<font size=\"-1\" face=\"[tag:fontFace1]\">\n").append("<b>").append(t.getDisplayname()).append("</b>\n");
        if (t.getDesc() != null) {
            content.append("<br>\n").append("<font size=\"-1\" face=\"[tag:fontFace1]\">\n").append(t.getDesc()).append("</font>\n");
        }
        content.append("</font>\n").append("</td>\n").append("</tr>\n");
        return content;
    }

    private StringBuffer makeRemove(UnmodifiableTab t, boolean isStart) {
        StringBuffer content = new StringBuffer(128);
        content.append("<TR>\n").append("<TD>\n").append("<CENTER>\n").append("<INPUT TYPE=\"RADIO\" VALUE=\"").append(t.getName()).append("\" NAME=\"").append(this.getName() + ".setStart\"").append(" onClick=\"detectChecked(this.value)\"");
        if (isStart) {
            content.append(" checked");
        }
        content.append("></CENTER></TD>").append("<TD>\n").append("<FONT FACE=\"[tag:fontFace1]\" SIZE=\"-1\">\n").append(t.getDisplayname()).append("</font>");
        if (!t.isRemovable()) {
            content.append("<font color =\"#0000ff\">*</font>");
        }
        content.append("</td>").append("<TD NOWRAP><FONT FACE=\"sans-serif\" SIZE=\"-1\">\n");
        if (t.isRenamable()) {
            content.append("<a href=\"#\" ONCLICK=\"javascript:renameTab('").append(this.getName() + "_rename_").append(t.getName()).append("')\"><font face=\"sans-serif\">").append(this.bundle.getString("rename")).append("</font></a>").append("<INPUT TYPE=\"HIDDEN\" VALUE=\"").append(t.getDisplayname()).append("\" NAME=\"").append(this.getName() + "_rename_").append(t.getName()).append("\">");
        }
        if (t.isRemovable()) {
            content.append("<a href=\"#\" ONCLICK=\"javascript:deleteTab('").append(this.getName() + "_remove_").append(t.getName()).append("')\"><font face=\"sans-serif\">").append(this.bundle.getString("delete")).append("</font></a>").append("<INPUT TYPE=\"HIDDEN\" VALUE=\"0\" ").append("NAME=\"").append(this.getName() + "_remove_").append(t.getName()).append("\">");
        }
        content.append("</td>\n");
        content.append("</tr>\n");
        return content;
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        URL url = null;
        try {
            url = this.tabdata.removeRenameTab(req);
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.processEdit():couldn't remove/rename tab", te);
        }
        catch (InvalidEditFormDataException e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "", e);
            }
            String error = this.getProviderContext().encodeURLParameter(e.getMessage());
            StringBuffer args = new StringBuffer(64);
            args.append("?action=edit&provider=").append(this.getName()).append("&error=").append(error);
            try {
                url = new URL(this.getProviderContext().getDesktopURL(req) + args.toString());
            }
            catch (MalformedURLException me) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "PSDT_CSPPCTTB0002", url);
                }
                return null;
            }
        }
        String makeparam = req.getParameter(this.getName() + ".make");
        if (makeparam != null && makeparam.equals("make")) {
            HashMap results = new HashMap();
            try {
                boolean make;
                this.tabdata.makeNewTab(req, results);
                if ((Boolean)results.get("make") != null && (make = ((Boolean)results.get("make")).booleanValue())) {
                    ModifiableTab tab = (ModifiableTab)results.get("tab");
                    url = this.getContentURL(tab, req);
                }
            }
            catch (InvalidEditFormDataException e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "PSDT_CSPPCTTB0001", e);
                }
                String error = this.getProviderContext().encodeURLParameter(e.getMessage());
                StringBuffer args = new StringBuffer(64);
                args.append("?action=edit&provider=").append(this.getName()).append("&error=").append(error).append("&page=make");
                String inputName = (String)results.get("inputTabName");
                if (inputName != null) {
                    args.append("&inputTabName=").append(this.getProviderContext().encodeURLParameter(inputName));
                }
                if ((inputName = (String)results.get("inputDescName")) != null) {
                    args.append("&inputDescName=").append(this.getProviderContext().encodeURLParameter(inputName));
                }
                try {
                    url = new URL(this.getProviderContext().getDesktopURL(req) + args.toString());
                }
                catch (MalformedURLException me) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "PSDT_CSPPCTTB0002", url);
                    }
                    return null;
                }
            }
        }
        return url;
    }

    public URL getTabURL(UnmodifiableTab tab, HttpServletRequest req) throws ProviderException {
        URL url = null;
        try {
            url = this.tabdata.getTabURL(tab, req);
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.getTabURL():couldn't get the desktop URL", te);
        }
        return url;
    }

    public URL getContentURL(ModifiableTab tab, HttpServletRequest req) throws ProviderException {
        URL url = null;
        String charset = this.getProviderContext().getCharset();
        try {
            StringBuffer urlbuffer = new StringBuffer(this.getContainerProviderContext().getDesktopURL(req));
            urlbuffer.append("?action=edit&provider=");
            urlbuffer.append(tab.getName());
            urlbuffer.append("&");
            urlbuffer.append(tab.getName());
            urlbuffer.append(".containerEdit=content");
            urlbuffer.append("&selected=");
            urlbuffer.append(this.getProviderContext().encodeURLParameter(tab.getDisplayname()));
            url = new URL(urlbuffer.toString());
        }
        catch (MalformedURLException me) {
            throw new ProviderException("TemplateTabContainerProvider.getContentURL():couldn't create the url", me);
        }
        return url;
    }

    public void removeTab(String name) throws ProviderException {
        try {
            this.tabdata.removeTab(name);
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.removeTab():couldn't remove tab from the selected tab", te);
        }
    }

    public int getMaxTabs() throws ProviderException {
        try {
            return this.tabdata.getMaxTabs();
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.getMaxTabs():couldn't get max tabs", te);
        }
    }

    public List getSelectedTabs() throws ProviderException {
        List tabs = new ArrayList();
        try {
            tabs = this.tabdata.getSelectedTabs();
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.getSelectedTabs():couldn't get selectedtabs", te);
        }
        return tabs;
    }

    public List getAvailableTabs() throws ProviderException {
        List tabs = new ArrayList();
        try {
            tabs = this.tabdata.getAvailableTabs();
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.getAvailableTabs():couldn't get available tabs", te);
        }
        return tabs;
    }

    public UnmodifiableTab getStartTab() throws ProviderException {
        UnmodifiableTab t = null;
        try {
            t = this.tabdata.getStartTab();
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.getStartTab():couldn't get start tab", te);
        }
        return t;
    }

    public String getStartTabName() throws ProviderException {
        try {
            return this.tabdata.getStartTabName();
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.getStartTabName():couldn't get start tab name ", te);
        }
    }

    public UnmodifiableTab getMakeTab() throws ProviderException {
        UnmodifiableTab t = null;
        try {
            t = this.tabdata.getMakeTab();
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.getMakeTab():couldn't get make tab", te);
        }
        return t;
    }

    public String getMakeTabName() throws ProviderException {
        try {
            return this.tabdata.getMakeTabName();
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.getMakeTabName():couldn't get make tab name ", te);
        }
    }

    public String getMakeTabProviderName() throws ProviderException {
        try {
            return this.tabdata.getMakeTabProviderName();
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.getMakeTabProviderName():couldn't get make tab provider name ", te);
        }
    }

    public String getSelectedTabName() throws ProviderException {
        String name = null;
        try {
            name = this.tabdata.getSelectedTabName();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getSelectedTabName():couldn't get the selected tab name", te);
        }
        return name;
    }

    public UnmodifiableTab getSelectedTab() throws ProviderException {
        UnmodifiableTab t = null;
        try {
            t = this.tabdata.getSelectedTab();
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.getSelectedTab():couldn't get selected tab", te);
        }
        return t;
    }

    public UnmodifiableTab getTab(String name) throws ProviderException {
        UnmodifiableTab t = null;
        try {
            t = this.tabdata.getTab(name);
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.getTab():couldn't get the tab:name=" + name, te);
        }
        return t;
    }

    public void setTab(ModifiableTab t) throws ProviderException {
        this.setTab(t, false);
    }

    public void setTab(ModifiableTab t, boolean selected) throws ProviderException {
        try {
            this.tabdata.setTab(t, selected);
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.setTab():couldn't set the tab", te);
        }
    }

    public void setStartTabName() throws ProviderException {
        this.setStartTabName(this.getSelectedTabName());
    }

    public void setStartTabName(UnmodifiableTab t) throws ProviderException {
        this.setStartTabName(t.getName());
    }

    public void setStartTabName(String name) throws ProviderException {
        try {
            this.tabdata.setStartTabName(name);
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.setStartTabName():attempt to set start to non-existent tab", te);
        }
    }

    public void setSelectedTab(ModifiableTab t) throws ProviderException {
        this.setSelectedTabName(t.getName());
    }

    public void setSelectedTabName(String tabName) throws ProviderException {
        try {
            this.tabdata.setSelectedTabName(tabName);
        }
        catch (TabException te) {
            throw new ProviderException("TemplateTabContainerProvider.setStartTabName():attempt to set selected to non-existent tab", te);
        }
    }

    public int getWindowState(String channelName) throws ProviderException {
        return 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

