/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.containers.jsp.tab;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.InvalidEditFormDataException;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.JSPContainerProviderAdapter;
import com.sun.portal.providers.containers.UnsupportedWindowStateException;
import com.sun.portal.providers.containers.jsp.tab.ModifiableTab;
import com.sun.portal.providers.containers.jsp.tab.TabContainer;
import com.sun.portal.providers.containers.jsp.tab.UnmodifiableTab;
import com.sun.portal.providers.containers.jsp.tab.util.TabData;
import com.sun.portal.providers.containers.jsp.tab.util.TabException;
import com.sun.portal.providers.context.ProviderContextException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSPTabContainerProvider
extends JSPContainerProviderAdapter
implements TabContainer {
    private TabData tabdata = null;
    private ResourceBundle bundle = null;
    private Map tabPropsMap = null;
    private String channel = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$providers$containers$jsp$tab$JSPTabContainerProvider == null ? (class$com$sun$portal$providers$containers$jsp$tab$JSPTabContainerProvider = JSPTabContainerProvider.class$("com.sun.portal.providers.containers.jsp.tab.JSPTabContainerProvider")) : class$com$sun$portal$providers$containers$jsp$tab$JSPTabContainerProvider));
    private static int[] supportedStates = new int[2];
    static /* synthetic */ Class class$com$sun$portal$providers$containers$jsp$tab$JSPTabContainerProvider;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
        this.channel = this.getName();
        this.bundle = this.getResourceBundle();
        this.tabdata = new TabData(this.getContainerProviderContext(), this.channel, this.bundle);
        this.tabPropsMap = this.getMapProperty("TabProperties");
    }

    public List getSelectedChannels() throws ProviderException {
        return super.getSelectedChannels();
    }

    public List getAvailableChannels() throws ProviderException {
        return super.getAvailableChannels();
    }

    public void setSelectedChannels(List sel) throws ProviderException {
        super.setSelectedChannels(sel);
    }

    public void setAvailableChannels(List avail) throws ProviderException {
        super.setAvailableChannels(avail);
    }

    public int getMaxTabs() throws ProviderException {
        try {
            return this.tabdata.getMaxTabs();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getMaxTabs():couldn't get maxTabs", te);
        }
    }

    public List getSelectedTabs() throws ProviderException {
        List tabs = new ArrayList();
        try {
            tabs = this.tabdata.getSelectedTabs();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getSelectedTabs():couldn't get selectedtabs", te);
        }
        return tabs;
    }

    public List getAvailableTabs() throws ProviderException {
        List tabs = new ArrayList();
        try {
            tabs = this.tabdata.getAvailableTabs();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getAvailableTabs():couldn't get available tabs", te);
        }
        return tabs;
    }

    public UnmodifiableTab getStartTab() throws ProviderException {
        UnmodifiableTab t = null;
        try {
            t = this.tabdata.getStartTab();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getStartTab():couldn't get start tab", te);
        }
        return t;
    }

    public String getStartTabName() throws ProviderException {
        try {
            return this.tabdata.getStartTabName();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getStartTabName():couldn't get start tab name ", te);
        }
    }

    public UnmodifiableTab getMakeTab() throws ProviderException {
        UnmodifiableTab t = null;
        try {
            t = this.tabdata.getMakeTab();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getMakeTab():couldn't get make tab", te);
        }
        return t;
    }

    public String getMakeTabName() throws ProviderException {
        try {
            return this.tabdata.getMakeTabName();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getMakeTabName():couldn't get make tab name ", te);
        }
    }

    public String getMakeTabProviderName() throws ProviderException {
        try {
            return this.tabdata.getMakeTabProviderName();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getMakeTabProvider Name():couldn't get make tab provider name ", te);
        }
    }

    public String getSelectedTabName() throws ProviderException {
        String name = null;
        try {
            name = this.tabdata.getSelectedTabName();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getSelectedTabName():couldn't get the selected tab name", te);
        }
        return name;
    }

    public UnmodifiableTab getSelectedTab() throws ProviderException {
        UnmodifiableTab t = null;
        try {
            t = this.tabdata.getSelectedTab();
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getSelectedTab():couldn't get selected tab", te);
        }
        return t;
    }

    public UnmodifiableTab getTab(String name) throws ProviderException {
        UnmodifiableTab t = null;
        try {
            t = this.tabdata.getTab(name);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.getTab():couldn't get the tab:name=" + name, te);
        }
        return t;
    }

    public void setTab(ModifiableTab t) throws ProviderException {
        this.setTab(t, false);
    }

    public void setTab(ModifiableTab t, boolean selected) throws ProviderException {
        try {
            this.tabdata.setTab(t, selected);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.setTab():couldn't set the tab", te);
        }
    }

    public void setStartTabName() throws ProviderException {
        this.setStartTabName(this.getSelectedTabName());
    }

    public void setStartTabName(UnmodifiableTab t) throws ProviderException {
        this.setStartTabName(t.getName());
    }

    public void setStartTabName(String name) throws ProviderException {
        try {
            this.tabdata.setStartTabName(name);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.setStartTabName():attempt to set start to non-existent tab", te);
        }
    }

    public void setSelectedTab(ModifiableTab t) throws ProviderException {
        this.setSelectedTabName(t.getName());
    }

    public void setSelectedTabName(String tabName) throws ProviderException {
        try {
            this.tabdata.setSelectedTabName(tabName);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.setSelectedTabName():attempt to set selected to non-existent tab", te);
        }
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String selected = req.getParameter(this.getName() + ".setSelected");
        if (selected != null && selected.length() > 0) {
            this.setSelectedTabName(selected);
        }
        return super.getContent(req, res);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        URL url = null;
        String makeparam = req.getParameter(this.getName() + ".make");
        if (makeparam != null && makeparam.equals("make")) {
            HashMap results = new HashMap();
            try {
                this.tabdata.makeNewTab(req, results);
                if ((Boolean)results.get("make") == null) return url;
                boolean make = (Boolean)results.get("make");
                if (!make) return url;
                ModifiableTab tab = (ModifiableTab)results.get("tab");
                return this.getContentURL(tab, req);
            }
            catch (InvalidEditFormDataException e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "PSDT_CSPPCJTB0001", e);
                }
                String error = this.getProviderContext().encodeURLParameter(e.getMessage());
                StringBuffer args = new StringBuffer(64);
                args.append("?action=edit&provider=").append(this.getName()).append("&error=").append(error).append("&page=make");
                String inputName = (String)results.get("inputTabName");
                if (inputName != null) {
                    args.append("&inputTabName=").append(this.getProviderContext().encodeURLParameter(inputName));
                }
                if ((inputName = (String)results.get("inputDescName")) != null) {
                    args.append("&inputDescName=").append(this.getProviderContext().encodeURLParameter(inputName));
                }
                try {
                    return new URL(this.getProviderContext().getDesktopURL(req) + args.toString());
                }
                catch (MalformedURLException me) {
                    if (!logger.isLoggable(Level.SEVERE)) return null;
                    logger.log(Level.SEVERE, "PSDT_CSPPCJTB0002", url);
                    return null;
                }
            }
        }
        try {
            return this.tabdata.removeRenameTab(req);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.processEdit():couldn't remove/rename tab", te);
        }
        catch (InvalidEditFormDataException e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "PSDT_CSPPCJTB0001", e);
            }
            String error = this.getProviderContext().encodeURLParameter(e.getMessage());
            StringBuffer args = new StringBuffer(64);
            args.append("?action=edit&provider=").append(this.getName()).append("&error=").append(error);
            try {
                return new URL(this.getProviderContext().getDesktopURL(req) + args.toString());
            }
            catch (MalformedURLException me) {
                if (!logger.isLoggable(Level.SEVERE)) return null;
                logger.log(Level.SEVERE, "PSDT_CSPPCJTB0002", url);
                return null;
            }
        }
    }

    public URL getTabURL(UnmodifiableTab tab, HttpServletRequest req) throws ProviderException {
        URL url = null;
        try {
            url = this.tabdata.getTabURL(tab, req);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.processEdit():couldn't get the desktop URL", te);
        }
        return url;
    }

    public void removeTab(String name) throws ProviderException {
        try {
            this.tabdata.removeTab(name);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.removeTab():couldn't remove tab from the selected tab", te);
        }
    }

    public void addTab(String name, String title) throws ProviderException {
        try {
            this.tabdata.addTab(name, title);
        }
        catch (TabException te) {
            throw new ProviderException("TabContainerProvider.addTab():couldn't add tab to the selected tab", te);
        }
    }

    public URL getContentURL(ModifiableTab tab, HttpServletRequest req) throws ProviderException {
        boolean newInstallation;
        int version;
        URL url = null;
        String charset = this.getProviderContext().getCharset();
        try {
            String makeTabChannel = this.getStringProperty("makeTabChannel");
            version = this.getProviderContext().getProviderVersion(makeTabChannel);
            File file = this.getProviderContext().getTemplatePath(makeTabChannel, "contentLayoutBarCombined.jsp");
            newInstallation = file != null;
        }
        catch (ProviderContextException pce) {
            throw new ProviderException(pce.getMessage());
        }
        boolean isDisplayNew = newInstallation && version > 2;
        if (!isDisplayNew) {
            String contentChannel = this.getStringProperty("contentChannel");
            try {
                StringBuffer urlbuffer = new StringBuffer(this.getContainerProviderContext().getDesktopURL(req));
                urlbuffer.append("?action=edit&provider=");
                urlbuffer.append(contentChannel);
                urlbuffer.append("&container=");
                urlbuffer.append(tab.getName());
                urlbuffer.append("&selected=");
                urlbuffer.append(this.getProviderContext().encodeURLParameter(tab.getDisplayname()));
                url = new URL(urlbuffer.toString());
            }
            catch (MalformedURLException me) {
                throw new ProviderException("TabContainerProvider.getContentURL():couldn't create the url", me);
            }
        }
        if (isDisplayNew) {
            String editContainerName = this.getStringProperty("editContainerName");
            String containerName = tab.getName();
            try {
                StringBuffer urlbuffer = new StringBuffer(this.getContainerProviderContext().getDesktopURL(req));
                urlbuffer.append("?action=edit&provider=");
                urlbuffer.append(editContainerName);
                urlbuffer.append("&targetprovider=");
                urlbuffer.append(containerName);
                urlbuffer.append("&containerName=");
                urlbuffer.append(containerName);
                urlbuffer.append("&selected=");
                urlbuffer.append(this.getProviderContext().encodeURLParameter(tab.getDisplayname()));
                urlbuffer.append("&editMode=content");
                url = new URL(urlbuffer.toString());
            }
            catch (MalformedURLException me) {
                throw new ProviderException("TabContainerProvider.getContentURL():couldn't create the url", me);
            }
        }
        return url;
    }

    public int getWindowState(String channelName) throws ProviderException {
        return 2;
    }

    public void setWindowState(String channelName, int windowState) throws UnsupportedWindowStateException {
        if (windowState != 2) {
            throw new UnsupportedWindowStateException("JSPTabContainerProvider.setWindowState(): windowState passed in is not supported");
        }
    }

    public int[] getSupportedWindowStates() throws ProviderException {
        return supportedStates;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        JSPTabContainerProvider.supportedStates[0] = 2;
    }
}

