/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.containers.dynamic;

import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.ContainerProviderAdapter;
import com.sun.portal.providers.containers.UnsupportedWindowStateException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DynamicAggregationContainerProvider
extends ContainerProviderAdapter {
    private static int[] supportedWindowStates = new int[]{2};
    private static Pattern channelPattern = Pattern.compile("(?i)<\\s*channel\\s*name=([\"'])(\\S+?)(\\1)\\s*>");

    public StringBuffer getContent(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        String aggregator = this.getAggregator();
        if (aggregator == null) {
            return new StringBuffer("");
        }
        String aggregatorContent = this.getContainerProviderContext().getContent(request, response, this.getName(), aggregator).toString();
        Matcher m = channelPattern.matcher(aggregatorContent);
        ArrayList<String> channels = new ArrayList<String>();
        while (m.find()) {
            String channel = m.group(2);
            if (!this.canAggregate(channel) || channels.contains(channel)) continue;
            channels.add(channel);
        }
        Map channelContentMap = this.getContainerProviderContext().getContent(request, response, this.getName(), channels, this.getIntegerProperty("timeout"));
        StringBuffer sb = new StringBuffer(7359);
        int start = 0;
        int end = 0;
        m.reset();
        while (m.find()) {
            end = m.start();
            sb.append(aggregatorContent.substring(start, end));
            StringBuffer cb = (StringBuffer)channelContentMap.get(m.group(2));
            if (cb != null) {
                sb.append(cb);
            }
            start = m.end();
        }
        sb.append(aggregatorContent.substring(start));
        return sb;
    }

    public StringBuffer getEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        String aggregator = this.getAggregator();
        if (aggregator != null) {
            return this.getContainerProviderContext().getProvider(request, this.getName(), aggregator).getEdit(request, response);
        }
        return null;
    }

    public URL processEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        String aggregator = this.getAggregator();
        if (aggregator != null) {
            return this.getContainerProviderContext().getProvider(request, this.getName(), aggregator).processEdit(request, response);
        }
        return null;
    }

    public int getWindowState(String channelName) throws ProviderException {
        return 2;
    }

    public void setWindowState(String channelName, int windowState) throws UnsupportedWindowStateException {
        throw new UnsupportedWindowStateException("DynamicAggregationContainerProvider.setWindowState() unsupported");
    }

    public int[] getSupportedWindowStates() throws ProviderException {
        return supportedWindowStates;
    }

    public String getAggregator() throws ProviderException {
        List selectedChannels = this.getSelectedChannels();
        if (selectedChannels == null || selectedChannels.size() == 0) {
            return null;
        }
        return (String)selectedChannels.get(0);
    }

    public boolean canAggregate(String channel) throws ProviderException {
        return this.getAvailableChannels().contains(channel);
    }
}

