/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.containers;

import com.sun.portal.desktop.DesktopRequestThreadLocalizer;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.ContainerProvider;
import com.sun.portal.providers.containers.UnsupportedWindowStateException;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ContainerProviderAdapter
extends ProfileProviderAdapter
implements ContainerProvider {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$providers$containers$ContainerProviderAdapter == null ? (class$com$sun$portal$providers$containers$ContainerProviderAdapter = ContainerProviderAdapter.class$("com.sun.portal.providers.containers.ContainerProviderAdapter")) : class$com$sun$portal$providers$containers$ContainerProviderAdapter));
    static /* synthetic */ Class class$com$sun$portal$providers$containers$ContainerProviderAdapter;

    public ContainerProviderContext getContainerProviderContext() throws ProviderException {
        ProviderContext pc = this.getProviderContext();
        if (!(pc instanceof ContainerProviderContext)) {
            throw new ProviderException("ContainerProviderAdapter.getContainerProviderContext(): not a container provider context");
        }
        return (ContainerProviderContext)pc;
    }

    public List getSelectedChannels() throws ProviderException {
        try {
            return this.getContainerProviderContext().getSelectedChannels(this.getName());
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ContainerProviderAdapter.getSelectedChannels(): ", pce);
        }
    }

    public List getAvailableChannels() throws ProviderException {
        try {
            return this.getContainerProviderContext().getAvailableChannels(this.getName());
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ContainerProviderAdapter.getAvailableChannels(): ", pce);
        }
    }

    public List getAvailableAndUserDefinedChannels() throws ProviderException {
        try {
            List availableChannels = this.getAvailableChannels();
            Map userDefinedChannels = this.getProviderContext().getCollectionProperty(this.getName(), "userDefinedChannels");
            availableChannels.removeAll(userDefinedChannels.values());
            Iterator itr = userDefinedChannels.keySet().iterator();
            while (itr.hasNext()) {
                availableChannels.add((String)itr.next());
            }
            return availableChannels;
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ContainerProviderAdapter.getAvailableAndUserDefinedChannels()", pce);
        }
    }

    public void setSelectedChannels(List sel) throws ProviderException {
        try {
            this.getContainerProviderContext().setSelectedChannels(this.getName(), sel);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ContainerProviderAdapter.setSelectedChannels(): ", pce);
        }
    }

    public void setAvailableChannels(List avail) throws ProviderException {
        try {
            this.getContainerProviderContext().setAvailableChannels(this.getName(), avail);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ContainerProviderAdapter.getAvailableChannels(): ", pce);
        }
    }

    public long getRefreshTime() throws ProviderException {
        String refreshTime = this.getStringProperty("refreshTime");
        long refreshTimelong = 0L;
        if (refreshTime != null && refreshTime.length() != 0) {
            return Long.parseLong(refreshTime);
        }
        List selected = this.getSelectedChannels();
        int size = selected.size();
        for (int i = 0; i < size; ++i) {
            block9: {
                String channel = (String)selected.get(i);
                Provider p = this.getContainerProviderContext().getProvider(DesktopRequestThreadLocalizer.getRequest(), this.getName(), channel);
                if (p != null) {
                    try {
                        long rt = p.getRefreshTime();
                        if (i == 0) {
                            refreshTimelong = rt;
                            break block9;
                        }
                        refreshTimelong = Math.min(refreshTimelong, rt);
                    }
                    catch (ProviderException pe) {
                        if (logger.isLoggable(Level.SEVERE)) {
                            LogRecord rec = new LogRecord(Level.SEVERE, "PSDT_CSPPC0001");
                            rec.setLoggerName(logger.getName());
                            Object[] param = new String[]{channel};
                            rec.setParameters(param);
                            rec.setThrown(pe);
                            logger.log(rec);
                        }
                        break block9;
                    }
                }
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "PSDT_CSPPC0002", channel);
                }
            }
            if (refreshTimelong == 0L) break;
        }
        Object[] param = new String[]{new Long(refreshTimelong).toString(), this.getName()};
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSDT_CSPPC0003", param);
        }
        return refreshTimelong;
    }

    public int getWindowState(String channelName) throws ProviderException {
        return -1;
    }

    public void setWindowState(String channelName, int windowState) throws UnsupportedWindowStateException {
        throw new UnsupportedWindowStateException("Setting a window state is not supported in the default impl of containerprovider");
    }

    public int[] getSupportedWindowStates() throws ProviderException {
        int[] winstates = new int[]{-1};
        return winstates;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

