/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.bookmark;

import com.sun.portal.desktop.encode.Encoder;
import com.sun.portal.desktop.util.I18n;
import com.sun.portal.desktop.util.Integers;
import com.sun.portal.desktop.util.Target;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.AsciiFormInputExpectedException;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.util.ProviderProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BookmarkProvider
extends ProfileProviderAdapter
implements ProviderProperties {
    private ResourceBundle bundle = null;
    private String editContainer = null;
    private String container = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$providers$bookmark$BookmarkProvider == null ? (class$com$sun$portal$providers$bookmark$BookmarkProvider = BookmarkProvider.class$("com.sun.portal.providers.bookmark.BookmarkProvider")) : class$com$sun$portal$providers$bookmark$BookmarkProvider));
    private static final String contentTemplate = "display.template";
    private static final String urlWrapTemplate = "urlWrapper.template";
    private static final String EDIT_URL_WRAPPER_TEMPLATE = "editUrlWrapper.template";
    private static final String EDIT_WINDOW_OPTION_TEMPLATE = "editWindowOption.template";
    static /* synthetic */ Class class$com$sun$portal$providers$bookmark$BookmarkProvider;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
    }

    private List setTargets(List targets) throws ProviderException {
        block2: {
            try {
                List clientAndLocaleFilters = this.getProviderContext().getClientAndLocalePropertiesFilters();
                this.getProviderContext().setCollectionProperty(this.getName(), "targets", targets, clientAndLocaleFilters);
            }
            catch (ProviderContextException pce) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                LogRecord rec = new LogRecord(Level.WARNING, "PSDT_CSPPB0001");
                rec.setLoggerName(logger.getName());
                Object[] param = new String[]{"properties filter list"};
                rec.setParameters(param);
                rec.setThrown(pce);
                logger.log(rec);
            }
        }
        return targets;
    }

    private List getTargets() throws ProviderException {
        ArrayList targets;
        block3: {
            targets = null;
            try {
                List clientAndLocaleFilters = this.getProviderContext().getClientAndLocalePropertiesFilters();
                targets = new ArrayList(this.getProviderContext().getCollectionProperty(this.getName(), "targets", clientAndLocaleFilters).values());
            }
            catch (ProviderContextException pce) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                LogRecord rec = new LogRecord(Level.WARNING, "PSDT_CSPPB0001");
                rec.setLoggerName(logger.getName());
                Object[] param = new String[]{"properties filter list"};
                rec.setParameters(param);
                rec.setThrown(pce);
                logger.log(rec);
            }
        }
        if (targets == null) {
            targets = this.getListProperty("targets");
        }
        return targets;
    }

    public boolean isPresentable(HttpServletRequest request) {
        boolean isPresentable;
        block3: {
            isPresentable = false;
            ProviderContext pc = this.getProviderContext();
            try {
                if (this.getTemplatePath(contentTemplate) != null && this.getTemplatePath(urlWrapTemplate) != null) {
                    isPresentable = true;
                }
            }
            catch (ProviderException pe) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, "PSDT_CSPPB0002", pe);
            }
        }
        return isPresentable;
    }

    private List getLinks() {
        ArrayList links;
        block2: {
            links = null;
            try {
                links = new ArrayList(this.getProviderContext().getCollectionProperty(this.getName(), "targets").values());
            }
            catch (ProviderContextException pce) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                LogRecord rec = new LogRecord(Level.WARNING, "PSDT_CSPPB0001");
                rec.setLoggerName(logger.getName());
                Object[] param = new String[]{"properties filter list"};
                rec.setParameters(param);
                rec.setThrown(pce);
                logger.log(rec);
            }
        }
        return links;
    }

    private void setLinks(List links) throws ProviderException {
        block2: {
            try {
                this.getProviderContext().setCollectionProperty(this.getName(), "targets", links);
            }
            catch (ProviderContextException pce) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                LogRecord rec = new LogRecord(Level.WARNING, "PSDT_CSPPB0001");
                rec.setLoggerName(logger.getName());
                Object[] param = new String[]{"properties filter list"};
                rec.setParameters(param);
                rec.setThrown(pce);
                logger.log(rec);
            }
        }
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        List targets;
        List clientAndLocaleFilters;
        StringBuffer ob;
        StringBuffer content;
        Hashtable<String, CharSequence> tagTable;
        block6: {
            tagTable = new Hashtable<String, CharSequence>();
            content = new StringBuffer();
            ob = new StringBuffer();
            clientAndLocaleFilters = null;
            targets = null;
            try {
                targets = this.getProviderContext().getProviderVersion(this.getName()) >= 2 ? this.getLinks() : this.getTargets();
            }
            catch (ProviderContextException pce) {
                if (!logger.isLoggable(Level.SEVERE)) break block6;
                logger.log(Level.SEVERE, "PSDT_CSPPB0003", pce);
            }
        }
        for (int x = 0; x < targets.size(); ++x) {
            String link;
            String name;
            Target target;
            block7: {
                String targ = (String)targets.get(x);
                target = new Target(targ);
                name = target.getName();
                link = target.getValue();
                try {
                    name = this.getProviderContext().escape(name);
                    link = this.getProviderContext().escape(link);
                    clientAndLocaleFilters = this.getProviderContext().getClientAndLocalePropertiesFilters();
                }
                catch (ProviderContextException pce) {
                    if (!logger.isLoggable(Level.SEVERE)) break block7;
                    logger.log(Level.SEVERE, "PSDT_CSPPB0003", pce);
                }
            }
            StringBuffer windowName = new StringBuffer();
            StringTokenizer tokens = new StringTokenizer(target.getName(), " (),=+#[]@<>$%./!");
            while (tokens.hasMoreTokens()) {
                windowName.append(tokens.nextToken());
                if (!tokens.hasMoreElements()) continue;
                windowName.append("_");
            }
            tagTable.put("fontFace1", this.getStringProperty("fontFace1", clientAndLocaleFilters));
            tagTable.put("channelName", Encoder.FORMNAME_ENCODER.encode(this.getName()));
            tagTable.put("windowName", windowName);
            tagTable.put("link", link);
            tagTable.put("name", name);
            content.append(this.getTemplate(urlWrapTemplate, tagTable));
            tagTable.clear();
        }
        String windowPref = this.getStringProperty("windowPref", clientAndLocaleFilters);
        tagTable.put("windowOption", windowPref);
        tagTable.put("bookmarks", content.toString());
        tagTable.put("channelName", Encoder.FORMNAME_ENCODER.encode(this.getName()));
        tagTable.put("fontFace1", this.getStringProperty("fontFace1", clientAndLocaleFilters));
        ob = this.getTemplate(contentTemplate, tagTable);
        return ob;
    }

    public boolean isEditable() throws ProviderException {
        boolean isEditable = false;
        if (this.getTemplatePath("edit.template") != null && this.getBooleanProperty("isEditable")) {
            isEditable = true;
        }
        return isEditable;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        List targets;
        List clientAndLocaleFilters;
        Hashtable<String, String> windowOptions;
        StringBuffer resourceList;
        StringBuffer content;
        block16: {
            block15: {
                content = new StringBuffer();
                resourceList = new StringBuffer("");
                windowOptions = new Hashtable<String, String>();
                this.editContainer = req.getParameter("provider");
                this.container = req.getParameter("containerName");
                clientAndLocaleFilters = null;
                targets = null;
                try {
                    targets = this.getProviderContext().getProviderVersion(this.getName()) >= 2 ? this.getLinks() : this.getTargets();
                }
                catch (ProviderContextException pce) {
                    if (!logger.isLoggable(Level.SEVERE)) break block15;
                    logger.log(Level.SEVERE, "PSDT_CSPPB0003", pce);
                }
            }
            try {
                clientAndLocaleFilters = this.getProviderContext().getClientAndLocalePropertiesFilters();
            }
            catch (ProviderContextException pce) {
                if (!logger.isLoggable(Level.WARNING)) break block16;
                LogRecord rec = new LogRecord(Level.WARNING, "PSDT_CSPPB0001");
                rec.setLoggerName(logger.getName());
                Object[] param = new String[]{"properties filter list"};
                rec.setParameters(param);
                rec.setThrown(pce);
                logger.log(rec);
            }
        }
        for (int i = 0; i < targets.size(); ++i) {
            String targ = (String)targets.get(i);
            Target target = new Target(targ);
            Hashtable<String, String> existingBM = new Hashtable<String, String>();
            existingBM.put("targetName", Encoder.HTML_ENCODER.encode(target.getName()));
            existingBM.put("targetValue", Encoder.HTML_ENCODER.encode(target.getValue()));
            existingBM.put("fontFace1", this.getStringProperty("fontFace1", clientAndLocaleFilters));
            existingBM.put("index", String.valueOf(i));
            resourceList.append(this.getTemplate(EDIT_URL_WRAPPER_TEMPLATE, existingBM));
        }
        Hashtable<String, CharSequence> tagTable = new Hashtable<String, CharSequence>();
        String all_new_checked = new String("");
        String one_new_checked = new String("");
        String same_checked = new String("");
        String wp = this.getStringProperty("windowPref", clientAndLocaleFilters);
        if (wp.equals("all_new")) {
            all_new_checked = "CHECKED";
        }
        if (wp.equals("one_new")) {
            one_new_checked = "CHECKED";
        }
        if (wp.equals("same")) {
            same_checked = "CHECKED";
        }
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle();
        }
        windowOptions.put("all_new_checked", all_new_checked);
        windowOptions.put("one_new_checked", one_new_checked);
        windowOptions.put("same_checked", same_checked);
        windowOptions.put("ownWindow", this.bundle.getString("ownWindow"));
        windowOptions.put("singleWindow", this.bundle.getString("singleWindow"));
        windowOptions.put("mainWindow", this.bundle.getString("mainWindow"));
        String resourceCountString = Integer.toString(targets.size());
        String err = this.getProviderContext().decodeURLParameter(req.getParameter("error"));
        if (err != null) {
            tagTable.put("errMessage", err);
            tagTable.put("inlineError", this.getTemplate("inlineError.template"));
        } else {
            tagTable.put("errMessage", "");
            tagTable.put("inlineError", "");
        }
        String resourceName = req.getParameter("resourceName");
        if (resourceName != null) {
            tagTable.put("resourceName", resourceName);
        } else {
            tagTable.put("resourceName", "");
        }
        String resourceURL = req.getParameter("resourceURL");
        if (resourceURL != null) {
            tagTable.put("resourceURL", resourceURL);
        } else {
            tagTable.put("resourceURL", "");
        }
        tagTable.put("resourceCount", resourceCountString);
        tagTable.put("resourceList", resourceList.toString());
        tagTable.put("windowOptions", this.getTemplate(EDIT_WINDOW_OPTION_TEMPLATE, windowOptions));
        tagTable.put("fontFace1", this.getStringProperty("fontFace1", clientAndLocaleFilters));
        content = this.getTemplate("edit.template", tagTable);
        return content;
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        URL next;
        block41: {
            List clientAndLocaleFilters;
            block40: {
                clientAndLocaleFilters = null;
                this.editContainer = req.getParameter("provider");
                this.container = req.getParameter("containerName");
                this.getProviderContext().contentChanged(this.getName());
                String error = null;
                Vector<String> targets = new Vector<String>();
                StringBuffer nextURLString = new StringBuffer();
                if (this.editContainer != null && this.container != null) {
                    nextURLString.append(this.getProviderContext().getDesktopURL(req)).append("?action=edit&provider=").append(this.getProviderContext().encodeURLParameter(this.editContainer)).append("&targetprovider=").append(this.getProviderContext().encodeURLParameter(this.getName())).append("&containerName=").append(this.getProviderContext().encodeURLParameter(this.container));
                } else {
                    nextURLString = null;
                }
                String rc = req.getParameter("resourceCount");
                int resourceCount = Integer.parseInt(rc);
                if (this.bundle == null) {
                    this.bundle = this.getResourceBundle();
                }
                next = null;
                for (int i = 0; i < resourceCount; ++i) {
                    Integer removeFlag;
                    String checkBoxValue = req.getParameter("remove" + i);
                    Integer n = removeFlag = checkBoxValue == null ? Integers.get((int)0) : Integer.valueOf(checkBoxValue);
                    if (removeFlag == 1) continue;
                    String nameString = "name" + i;
                    String urlString = "url" + i;
                    String name = req.getParameter(nameString);
                    String url = req.getParameter(urlString);
                    boolean errorFlag = false;
                    if ((name == null || name.trim().equals("")) && (url == null || url.trim().equals(""))) {
                        if (nextURLString != null) {
                            nextURLString.append("&error=").append(this.getProviderContext().encodeURLParameter(this.bundle.getString("removeError")));
                            errorFlag = true;
                        }
                    } else if (name == null || name.trim().equals("")) {
                        if (nextURLString != null) {
                            nextURLString.append("&error=").append(this.getProviderContext().encodeURLParameter(this.bundle.getString("emptyName") + " : " + url));
                            errorFlag = true;
                        }
                    } else if ((url == null || url.trim().equals("")) && nextURLString != null) {
                        nextURLString.append("&error=").append(this.getProviderContext().encodeURLParameter(this.bundle.getString("emptyURL") + " : " + name));
                        errorFlag = true;
                    }
                    if (errorFlag) {
                        try {
                            if (nextURLString != null) {
                                next = new URL(nextURLString.toString());
                            }
                        }
                        catch (MalformedURLException e) {
                            throw new ProviderException("BookmarkProvider.processEdit()", e);
                        }
                        return next;
                    }
                    if (!I18n.isAscii((String)url)) {
                        String err = this.bundle.getString("nonAsciiURL");
                        throw new AsciiFormInputExpectedException(err);
                    }
                    Target target = new Target(name, url);
                    if (target.getValue().indexOf("://") == -1 && !target.getValue().startsWith("/")) {
                        target.setValue("http://" + target.getValue());
                    }
                    targets.add(target.toString());
                }
                String newName = req.getParameter("resourceName");
                String newURL = req.getParameter("resourceURL");
                String addMore = req.getParameter("add_more");
                if (addMore != null && !addMore.trim().equals("")) {
                    if (newName != null && newURL != null && !newName.trim().equals("") && !newURL.trim().equals("")) {
                        if (!I18n.isAscii((String)newURL)) {
                            String err = this.bundle.getString("nonAsciiURL");
                            throw new AsciiFormInputExpectedException(err);
                        }
                        Target target = new Target(newName, newURL);
                        if (target.getValue().indexOf("://") == -1 && !target.getValue().startsWith("/")) {
                            target.setValue("http://" + target.getValue());
                        }
                        targets.add(target.toString());
                    } else if ((newName == null || newName.trim().equals("")) && (newURL == null || newURL.trim().equals(""))) {
                        if (addMore != null && !addMore.trim().equals("")) {
                            error = this.bundle.getString("emptyNameURL");
                        }
                    } else {
                        error = newName == null || newName.trim().equals("") ? this.bundle.getString("emptyName") : this.bundle.getString("emptyURL");
                    }
                }
                if (error != null && nextURLString != null && newName != null && newURL != null) {
                    String urltmp = this.getProviderContext().encodeURLParameter(newURL);
                    String nametmp = this.getProviderContext().encodeURLParameter(newName);
                    if (urltmp == null) {
                        urltmp = "";
                    }
                    if (nametmp == null) {
                        nametmp = "";
                    }
                    nextURLString.append("&resourceName=").append(nametmp).append("&resourceURL=").append(urltmp).append("&error=").append(this.getProviderContext().encodeURLParameter(error));
                }
                if (error == null && (addMore == null || addMore.trim().equals(""))) {
                    next = null;
                } else {
                    try {
                        if (nextURLString != null) {
                            next = new URL(nextURLString.toString());
                        }
                    }
                    catch (MalformedURLException e) {
                        throw new ProviderException("BookmarkProvider.processEdit()", e);
                    }
                }
                try {
                    if (this.getProviderContext().getProviderVersion(this.getName()) >= 2) {
                        this.setLinks(targets);
                    } else {
                        this.setTargets(targets);
                    }
                }
                catch (ProviderContextException pce) {
                    if (!logger.isLoggable(Level.SEVERE)) break block40;
                    logger.log(Level.SEVERE, "PSDT_CSPPB0003", pce);
                }
            }
            String windowPref = req.getParameter("windowPref");
            try {
                clientAndLocaleFilters = this.getProviderContext().getClientAndLocalePropertiesFilters();
                if (windowPref != null && !windowPref.equals(this.getStringProperty("windowPref", clientAndLocaleFilters))) {
                    this.getProviderContext().setStringProperty(this.getName(), "windowPref", windowPref, clientAndLocaleFilters);
                }
            }
            catch (ProviderContextException pce) {
                if (!logger.isLoggable(Level.WARNING)) break block41;
                LogRecord rec = new LogRecord(Level.WARNING, "PSDT_CSPPB0001");
                rec.setLoggerName(logger.getName());
                Object[] param = new String[]{"windowPref"};
                rec.setParameters(param);
                rec.setThrown(pce);
                logger.log(rec);
            }
        }
        return next;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

