/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers;

import com.sun.portal.desktop.DesktopRequest;
import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.desktop.context.ProviderContextThreadLocalizer;
import com.sun.portal.desktop.util.Integers;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderEditTypes;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.ProviderWidths;
import com.sun.portal.providers.UnknownEditTypeException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ProviderAdapter
implements Provider,
ProviderWidths,
ProviderEditTypes {
    private String name = null;
    private ProviderContext context = null;
    private static Map widthMap = null;
    private static Map editTypeMap = null;
    private static String HELP_URL = "helpURL";
    private Boolean presentableFromPA = null;
    private static final String ADAPTER_CLASS = "com.sun.portal.providers.ProviderAdapter";
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$providers$ProviderAdapter == null ? (class$com$sun$portal$providers$ProviderAdapter = ProviderAdapter.class$("com.sun.portal.providers.ProviderAdapter")) : class$com$sun$portal$providers$ProviderAdapter));
    static /* synthetic */ Class class$com$sun$portal$providers$ProviderAdapter;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        this.name = n;
        this.context = ProviderAdapter.getProviderContext(req);
    }

    public StringBuffer getContent(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        if (logger.isLoggable(Level.WARNING)) {
            Object[] param = new String[]{"getContent(Map)", this.getName(), "getContent(HttpServletRequest, HttpServletResponse)"};
            logger.log(Level.WARNING, "PSDT_CSPP0001", param);
        }
        Map parameterMap = ProviderAdapter.getParameterMap((ServletRequest)request);
        return this.getContent(parameterMap);
    }

    private static Map getParameterMap(ServletRequest req) {
        Map<String, String[]> parameterMap = null;
        if (req instanceof DesktopRequest) {
            parameterMap = ((DesktopRequest)req).getParameterMap();
        } else {
            parameterMap = new HashMap();
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String[] val = req.getParameterValues(key);
                parameterMap.put(key, val);
            }
        }
        return parameterMap;
    }

    public StringBuffer getContent(Map m) throws ProviderException {
        return null;
    }

    public StringBuffer getEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        if (logger.isLoggable(Level.WARNING)) {
            Object[] params = new String[]{"getEdit(Map)", this.getName(), "getContent(HttpServletRequest, HttpServletResponse)", "Map"};
            logger.log(Level.WARNING, "PSDT_CSPP0001", params);
        }
        Map parameterMap = ProviderAdapter.getParameterMap((ServletRequest)request);
        return this.getEdit(parameterMap);
    }

    public StringBuffer getEdit(Map m) throws ProviderException {
        return null;
    }

    public int getEditType() throws UnknownEditTypeException {
        String val = null;
        try {
            ProviderContext pc = this.getProviderContext();
            List clientAndLocaleFilters = pc.getClientAndLocalePropertiesFilters();
            val = pc.getStringProperty(this.getName(), "editType", clientAndLocaleFilters);
        }
        catch (ProviderContextException pce) {
            throw new UnknownEditTypeException("ProviderAdapter.getEditType(): ", pce);
        }
        Integer type = (Integer)editTypeMap.get(val);
        if (type == null) {
            throw new UnknownEditTypeException("ProviderAdapter.getEditType(): unknown edit type=" + val);
        }
        return type;
    }

    public URL processEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        if (logger.isLoggable(Level.INFO)) {
            Object[] param = new String[]{"processEdit (Map)", this.getName(), "processEdit(HttpServletRequest, HttpServletRequest)"};
            logger.log(Level.INFO, "PSDT_CSPP0001", param);
        }
        Map parameterMap = ProviderAdapter.getParameterMap((ServletRequest)request);
        return this.processEdit(parameterMap);
    }

    public URL processEdit(Map m) throws ProviderException {
        return null;
    }

    public boolean isEditable() throws ProviderException {
        try {
            ProviderContext pc = this.getProviderContext();
            List clientPropertyFilterList = pc.getClientPropertiesFilters();
            return this.getProviderContext().getBooleanProperty(this.getName(), "isEditable", clientPropertyFilterList);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ProviderAdapter.isEditable(): ", pce);
        }
    }

    public boolean isPresentable() {
        if (logger.isLoggable(Level.WARNING)) {
            Object[] param = new String[]{"isPresentable ()", this.getName(), "isPresentable(HttpServletRequest)"};
            logger.log(Level.WARNING, "PSDT_CSPP0001", param);
        }
        return this.isPresentable(RequestThreadLocalizer.getRequest());
    }

    private boolean isPresentableFromPA() {
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String dcName;
            String methodName = methods[i].getName();
            if (!methodName.startsWith("isPresentable") || methods[i].getParameterTypes().length != 0 || (dcName = methods[i].getDeclaringClass().getName()).equals(ADAPTER_CLASS)) continue;
            if (logger.isLoggable(Level.WARNING)) {
                Object[] params = new String[]{"isPresentable()", this.getName(), "isPresentable(HttpServletRequest)"};
                logger.log(Level.WARNING, "PSDT_CSPP0001", params);
            }
            return false;
        }
        return true;
    }

    public boolean isPresentable(HttpServletRequest req) {
        String defaultContentType;
        boolean htmlContent;
        boolean genericHTML;
        block7: {
            if (this.presentableFromPA == null) {
                this.presentableFromPA = this.isPresentableFromPA() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (!this.presentableFromPA.booleanValue()) {
                return this.isPresentable();
            }
            genericHTML = true;
            htmlContent = true;
            defaultContentType = "text/html";
            try {
                String property = this.getClientTypeProperty("genericHTML");
                if (property != null) {
                    genericHTML = property.equals("true");
                }
            }
            catch (ProviderException pe) {
                if (logger.isLoggable(Level.WARNING)) {
                    LogRecord rec = new LogRecord(Level.WARNING, "PSDT_CSPP0002");
                    rec.setLoggerName(logger.getName());
                    Object[] param = new String[]{"generic XML"};
                    rec.setParameters(param);
                    rec.setThrown(pe);
                    logger.log(rec);
                }
                if (this.getProviderContext().getClientType() == null) break block7;
                genericHTML = this.getProviderContext().getClientType().equals("genericHTML");
            }
        }
        String val = this.getProviderContext().getContentType();
        if (val != null) {
            htmlContent = val.equals(defaultContentType);
        }
        return genericHTML && htmlContent;
    }

    public String getTitle() throws ProviderException {
        try {
            return this.getProviderContext().getStringProperty(this.getName(), "title", true);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ProviderAdapter.getTitle(): ", pce);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() throws ProviderException {
        try {
            return this.getProviderContext().getStringProperty(this.getName(), "description", true);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ProviderAdapter.getDescription(): ", pce);
        }
    }

    public int getWidth() throws ProviderException {
        String val = null;
        try {
            val = this.getProviderContext().getStringProperty(this.getName(), "width");
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ProviderAdapter.getWidth(): ", pce);
        }
        Integer width = (Integer)widthMap.get(val);
        if (width == null) {
            throw new ProviderException("ProviderAdapter.getWidth(): unknown width type=" + val);
        }
        return width;
    }

    public URL getHelp(HttpServletRequest req, String key) throws ProviderException {
        ProviderContext pc = this.getProviderContext();
        String hu = null;
        String locale = null;
        String docroot = null;
        try {
            List clientPropertyFilterList = pc.getClientAndLocalePropertiesFilters();
            if (!pc.existsStringProperty(this.getName(), key, clientPropertyFilterList) && !key.equals(HELP_URL)) {
                key = HELP_URL;
            }
            if ((hu = pc.getStringProperty(this.getName(), key, clientPropertyFilterList)) != null && hu.length() == 0) {
                return null;
            }
            locale = pc.getLocaleString();
            docroot = pc.getStringProperty(this.getName(), "docroot");
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("providerAdapter.getHelp(): ", pce);
        }
        URL helpURL = null;
        if (hu.indexOf("://") != -1) {
            try {
                helpURL = new URL(hu);
            }
            catch (MalformedURLException mfue) {
                String path = pc.getStaticContentPath() + docroot + locale + "/" + hu;
                try {
                    helpURL = this.getAbsURL(path, req);
                }
                catch (MalformedURLException mue) {
                    throw new ProviderException("providerAdapter.getHelp(): ", mue);
                }
            }
        } else {
            StringBuffer sb = new StringBuffer(pc.getStaticContentPath());
            sb.append(docroot);
            if (!docroot.endsWith("/")) {
                sb.append("/");
            }
            sb.append(hu);
            String path = sb.toString();
            try {
                helpURL = this.getAbsURL(path, req);
            }
            catch (MalformedURLException mue) {
                throw new ProviderException("providerAdapter.getHelp(): ", mue);
            }
        }
        return helpURL;
    }

    public URL getHelp(HttpServletRequest req) throws ProviderException {
        return this.getHelp(req, HELP_URL);
    }

    private URL getAbsURL(String path, HttpServletRequest req) throws MalformedURLException {
        URL absURL = null;
        StringBuffer b = new StringBuffer(128);
        b.append(this.getProviderContext().getRequestServer(req)).append(path);
        absURL = new URL(b.toString());
        return absURL;
    }

    public long getRefreshTime() throws ProviderException {
        String refreshTime = null;
        long time = 0L;
        try {
            refreshTime = this.getProviderContext().getStringProperty(this.getName(), "refreshTime");
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ProviderAdapter.getRefreshTime(): ", pce);
        }
        if (refreshTime != null && refreshTime.length() != 0) {
            try {
                time = Long.parseLong(refreshTime);
            }
            catch (NumberFormatException nfe) {
                if (logger.isLoggable(Level.WARNING)) {
                    LogRecord rec = new LogRecord(Level.WARNING, "PSDT_CSPP0001");
                    rec.setLoggerName(logger.getName());
                    rec.setThrown(nfe);
                    Object[] param = new String[]{"refresh time"};
                    rec.setParameters(param);
                    logger.log(rec);
                }
                time = 0L;
            }
        } else {
            time = 0L;
        }
        return time;
    }

    String getClientTypeProperty(String propertyName) throws ProviderException {
        if (propertyName != null) {
            return this.getProviderContext().getClientTypeProperty(propertyName);
        }
        throw new ProviderException("ProviderAdapter.getClientProperty(): unable to read client property, propertyName is null");
    }

    public ProviderContext getProviderContext() {
        return this.context;
    }

    public ResourceBundle getResourceBundle(String base) throws ProviderException {
        Locale locale = null;
        locale = this.getProviderContext().getLocale();
        return ResourceBundle.getBundle(base, locale, this.getClass().getClassLoader());
    }

    public ResourceBundle getResourceBundle() throws ProviderException {
        Locale locale = null;
        String resource = null;
        locale = this.getProviderContext().getLocale();
        try {
            resource = this.getProviderContext().getProviderName(this.getName());
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ProviderAdapter.getResourceBundle(): cannot get provider name", pce);
        }
        return ResourceBundle.getBundle(resource, locale, this.getClass().getClassLoader());
    }

    private static ProviderContext getProviderContext(HttpServletRequest req) throws ProviderException {
        ProviderContext pc = ProviderContextThreadLocalizer.get();
        if (pc == null) {
            throw new ProviderException("ProviderAdapter.getProviderContext(): could not get provider context");
        }
        return pc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        widthMap = new HashMap();
        widthMap.put("thin", Integers.get((int)1));
        widthMap.put("THIN", Integers.get((int)1));
        widthMap.put("Thin", Integers.get((int)1));
        widthMap.put("thick", Integers.get((int)0));
        widthMap.put("THICK", Integers.get((int)0));
        widthMap.put("Thick", Integers.get((int)0));
        widthMap.put("full_top", Integers.get((int)2));
        widthMap.put("FULL_TOP", Integers.get((int)2));
        widthMap.put("Full_Top", Integers.get((int)2));
        widthMap.put("full_bottom", Integers.get((int)3));
        widthMap.put("FULL_BOTTOM", Integers.get((int)3));
        widthMap.put("Full_Bottom", Integers.get((int)3));
        editTypeMap = new HashMap();
        editTypeMap.put("edit_subset", Integers.get((int)3));
        editTypeMap.put("EDIT_SUBSET", Integers.get((int)3));
        editTypeMap.put("Edit_Subset", Integers.get((int)3));
        editTypeMap.put("edit_complete", Integers.get((int)4));
        editTypeMap.put("EDIT_COMPLETE", Integers.get((int)4));
        editTypeMap.put("Edit_Complete", Integers.get((int)4));
    }
}

