/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.portlet;

import com.sun.faces.portlet.FacesPortletState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LifecycleImpl
extends Lifecycle {
    private static final Log log = LogFactory.getLog((Class)(class$com$sun$faces$portlet$LifecycleImpl == null ? (class$com$sun$faces$portlet$LifecycleImpl = LifecycleImpl.class$("com.sun.faces.portlet.LifecycleImpl")) : class$com$sun$faces$portlet$LifecycleImpl));
    public static final String INIT_PARAMETER = "com.sun.faces.portlet.INIT";
    public static final String INIT_VIEW_PARAMETER = "com.sun.faces.portlet.INIT_VIEW";
    public static final String INIT_EDIT_PARAMETER = "com.sun.faces.portlet.INIT_EDIT";
    public static final String INIT_HELP_PARAMETER = "com.sun.faces.portlet.INIT_HELP";
    private static final String PREVIOUS_WINDOW_STATE = "com.sun.faces.portlet.PREVIOUS_WINDOW_STATE";
    private static final String WINDOW_STATE_ATTR_VIEW = "com.sun.faces.portlet.WINDOW_STATE_VIEW";
    private static final String WINDOW_STATE_ATTR_EDIT = "com.sun.faces.portlet.WINDOW_STATE_EDIT";
    private static final String WINDOW_STATE_ATTR_HELP = "com.sun.faces.portlet.WINDOW_STATE_HELP";
    public static final String ERROR_FLAG = "com.sun.faces.portlet.ERROR_FLAG";
    private List listeners = new ArrayList();
    private Phase[] phases = new Phase[]{null, new RestoreViewPhase(), new ApplyRequestValuesPhase(), new ProcessValidationsPhase(), new UpdateModelValuesPhase(), new InvokeApplicationPhase()};
    private Phase response = new RenderResponsePhase();
    static /* synthetic */ Class class$com$sun$faces$portlet$LifecycleImpl;

    public LifecycleImpl() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created Lifecycle " + (Object)((Object)this)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhaseListener(PhaseListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("addPhaseListener(" + listener.getPhaseId().toString() + "," + listener));
        }
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    public void execute(FacesContext context) throws FacesException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("execute(" + context + ")"));
        }
        this.restore(context, true);
        this.setErrorFlag(context, Boolean.FALSE);
        for (int i = 1; i < this.phases.length; ++i) {
            if (context.getRenderResponse() || context.getResponseComplete()) {
                this.setErrorFlag(context, Boolean.TRUE);
                break;
            }
            this.phase((PhaseId)PhaseId.VALUES.get(i), this.phases[i], context);
        }
        this.save(context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhaseListener[] getPhaseListeners() {
        List list = this.listeners;
        synchronized (list) {
            PhaseListener[] results = new PhaseListener[this.listeners.size()];
            return this.listeners.toArray(results);
        }
    }

    public void render(FacesContext context) throws FacesException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("render(" + context + ")"));
        }
        this.restore(context, false);
        this.setErrorFlag(context, Boolean.FALSE);
        if (!context.getResponseComplete()) {
            this.phase(PhaseId.RENDER_RESPONSE, this.response, context);
        }
        this.save(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhaseListener(PhaseListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("removePhaseListener(" + listener.getPhaseId().toString() + "," + listener));
        }
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    private void phase(PhaseId phaseId, Phase phase, FacesContext context) throws FacesException {
        block13: {
            int i;
            PhaseEvent event;
            PhaseListener[] listeners;
            block11: {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("phase(" + phaseId.toString() + "," + context + ")"));
                }
                listeners = this.getPhaseListeners();
                try {
                    if (listeners.length > 0) {
                        event = new PhaseEvent(context, phaseId, (Lifecycle)this);
                        for (i = 0; i < listeners.length; ++i) {
                            if (!phaseId.equals(listeners[i].getPhaseId()) && !PhaseId.ANY_PHASE.equals(listeners[i].getPhaseId())) continue;
                            listeners[i].beforePhase(event);
                        }
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block11;
                    log.debug((Object)("beforePhase(" + phaseId.toString() + "," + context + ") threw exception"), (Throwable)e);
                }
            }
            try {
                block12: {
                    try {
                        phase.execute(context);
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block12;
                        log.debug((Object)("executePhase(" + phaseId.toString() + "," + context + ") threw exception"), (Throwable)e);
                    }
                }
                if (listeners.length > 0) {
                    event = new PhaseEvent(context, phaseId, (Lifecycle)this);
                    for (i = listeners.length - 1; i >= 0; --i) {
                        if (!phaseId.equals(listeners[i].getPhaseId()) && !PhaseId.ANY_PHASE.equals(listeners[i].getPhaseId())) continue;
                        listeners[i].afterPhase(event);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block13;
                log.debug((Object)("afterPhase(" + phaseId.toString() + "," + context + ") threw exception"), (Throwable)e);
            }
        }
    }

    private void restore(FacesContext context, boolean action) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("restore(" + context + "," + action + ")"));
        }
        String windowStateIdentifier = this.getWindowStateIdentifier((String)context.getExternalContext().getRequestMap().get(INIT_PARAMETER));
        PortletSession session = (PortletSession)context.getExternalContext().getSession(true);
        String previousWindowStateIndentifier = (String)session.getAttribute(PREVIOUS_WINDOW_STATE);
        FacesPortletState state = null;
        if (previousWindowStateIndentifier != null && previousWindowStateIndentifier.equals(windowStateIdentifier)) {
            state = (FacesPortletState)session.getAttribute(windowStateIdentifier);
        }
        if (state == null) {
            this.setViewId(context);
            return;
        }
        if (!action) {
            Iterator clientIds = state.getClientIds();
            while (clientIds.hasNext()) {
                String clientId = (String)clientIds.next();
                Iterator messages = state.getMessages(clientId);
                while (messages.hasNext()) {
                    context.addMessage(clientId, (FacesMessage)messages.next());
                }
            }
        }
        context.setViewRoot(state.getViewRoot());
        session.removeAttribute(windowStateIdentifier);
        if (log.isTraceEnabled()) {
            log.trace((Object)"End restore()");
        }
    }

    private void save(FacesContext context, boolean action) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("save(" + context + "," + action + ")"));
        }
        FacesPortletState state = new FacesPortletState();
        Iterator clientIds = context.getClientIdsWithMessages();
        while (clientIds.hasNext()) {
            String clientId = (String)clientIds.next();
            Iterator messages = context.getMessages(clientId);
            while (messages.hasNext()) {
                state.addMessage(clientId, (FacesMessage)messages.next());
            }
            if (!log.isErrorEnabled()) continue;
            log.error((Object)(clientId + state.getMessagesBuffer(clientId)));
        }
        state.setViewRoot(context.getViewRoot());
        String windowStateIdentifier = this.getWindowStateIdentifier((String)context.getExternalContext().getRequestMap().get(INIT_PARAMETER));
        PortletSession session = (PortletSession)context.getExternalContext().getSession(true);
        session.setAttribute(PREVIOUS_WINDOW_STATE, (Object)windowStateIdentifier);
        session.setAttribute(windowStateIdentifier, (Object)state);
    }

    private String getInitViewId(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        String initParameterIdentifier = (String)requestMap.get(INIT_PARAMETER);
        String viewId = (String)requestMap.get(initParameterIdentifier);
        return viewId;
    }

    private void setViewId(FacesContext context) {
        String viewId = this.getInitViewId(context);
        if (context.getViewRoot() == null) {
            context.setViewRoot(context.getApplication().getViewHandler().createView(context, viewId));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created new ViewRoot with View Id" + context.getViewRoot().getViewId()));
            }
        } else {
            context.getViewRoot().setViewId(viewId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("set viewId to " + viewId));
            }
        }
        context.getViewRoot().setRenderKitId("HTML_BASIC");
    }

    private String getWindowStateIdentifier(String initParameterIdentifier) {
        if (initParameterIdentifier.equals(INIT_VIEW_PARAMETER)) {
            return WINDOW_STATE_ATTR_VIEW;
        }
        if (initParameterIdentifier.equals(INIT_EDIT_PARAMETER)) {
            return WINDOW_STATE_ATTR_EDIT;
        }
        if (initParameterIdentifier.equals(INIT_HELP_PARAMETER)) {
            return WINDOW_STATE_ATTR_HELP;
        }
        return null;
    }

    private void setErrorFlag(FacesContext context, Boolean value) {
        PortletSession session = (PortletSession)context.getExternalContext().getSession(true);
        session.setAttribute(ERROR_FLAG, (Object)value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class RenderResponsePhase
    implements Phase {
        RenderResponsePhase() {
        }

        public void execute(FacesContext context) throws FacesException {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Begin RenderResponsePhase");
            }
            try {
                context.getApplication().getViewHandler().renderView(context, context.getViewRoot());
            }
            catch (FacesException e) {
                log.error((Object)("" + (Object)((Object)e)), (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"End RenderResponsePhase");
            }
        }
    }

    final class InvokeApplicationPhase
    implements Phase {
        InvokeApplicationPhase() {
        }

        public void execute(FacesContext context) throws FacesException {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Begin InvokeApplicationPhase");
            }
            UIViewRoot viewRoot = context.getViewRoot();
            try {
                viewRoot.processApplication(context);
            }
            catch (FacesException e) {
                log.error((Object)("" + (Object)((Object)e)), (Throwable)e);
                throw e;
            }
            catch (RuntimeException e) {
                log.error((Object)("" + e), (Throwable)e);
                throw new FacesException((Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"End InvokeApplicationPhase");
            }
        }
    }

    final class UpdateModelValuesPhase
    implements Phase {
        UpdateModelValuesPhase() {
        }

        public void execute(FacesContext context) throws FacesException {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Begin UpdateModelValuesPhase");
            }
            UIViewRoot viewRoot = context.getViewRoot();
            try {
                viewRoot.processUpdates(context);
            }
            catch (FacesException e) {
                log.error((Object)("" + (Object)((Object)e)), (Throwable)e);
                throw e;
            }
            catch (RuntimeException e) {
                log.error((Object)("" + e), (Throwable)e);
                throw new FacesException((Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"End UpdateModelValuesPhase");
            }
        }
    }

    final class ProcessValidationsPhase
    implements Phase {
        ProcessValidationsPhase() {
        }

        public void execute(FacesContext context) throws FacesException {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Begin ProcessValidationsPhase");
            }
            UIViewRoot viewRoot = context.getViewRoot();
            try {
                viewRoot.processValidators(context);
            }
            catch (FacesException e) {
                log.error((Object)("" + (Object)((Object)e)), (Throwable)e);
                throw e;
            }
            catch (RuntimeException e) {
                log.error((Object)("" + e), (Throwable)e);
                throw new FacesException((Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"End ProcessValidationsPhase");
            }
        }
    }

    final class ApplyRequestValuesPhase
    implements Phase {
        ApplyRequestValuesPhase() {
        }

        public void execute(FacesContext context) throws FacesException {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Begin ApplyRequestValuesPhase");
            }
            UIViewRoot viewRoot = context.getViewRoot();
            try {
                viewRoot.processDecodes(context);
            }
            catch (FacesException e) {
                log.error((Object)("" + (Object)((Object)e)), (Throwable)e);
                throw e;
            }
            catch (RuntimeException e) {
                log.error((Object)("" + e), (Throwable)e);
                throw new FacesException((Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"End ApplyRequestValuesPhase");
            }
        }
    }

    final class RestoreViewPhase
    implements Phase {
        RestoreViewPhase() {
        }

        public void execute(FacesContext context) throws FacesException {
            String viewId;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Begin RestoreViewPhase");
            }
            if ((viewId = context.getViewRoot().getViewId()) == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"No view identifier found");
                }
                throw new FacesException("No view identifier in this request");
            }
            ViewHandler vh = context.getApplication().getViewHandler();
            UIViewRoot viewRoot = vh.restoreView(context, viewId);
            if (viewRoot == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Creating new view '" + viewId + "'"));
                }
                viewRoot = vh.createView(context, viewId);
                context.renderResponse();
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Restoring old view '" + viewId + "'"));
            }
            context.setViewRoot(viewRoot);
            this.doPerComponentActions(context, (UIComponent)viewRoot);
            if (log.isDebugEnabled()) {
                log.debug((Object)"End RestoreViewPhase");
            }
        }

        private void doPerComponentActions(FacesContext context, UIComponent component) {
            Iterator kids = component.getFacetsAndChildren();
            while (kids.hasNext()) {
                this.doPerComponentActions(context, (UIComponent)kids.next());
            }
            ValueBinding vb = component.getValueBinding("binding");
            if (vb != null) {
                vb.setValue(context, (Object)component);
            }
        }
    }

    static interface Phase {
        public void execute(FacesContext var1) throws FacesException;
    }
}

