/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.netlet.econnection.GWRunnable;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.util.SRAEvent;
import com.sun.portal.util.TaskWrapper;
import java.util.HashMap;
import java.util.Map;

public class ThreadMonitorContext {
    private static final int STARTED = 1;
    public static final int WAITING_IN_QUEUE = 2;
    public static final int RUNNING = 3;
    public static final int WAITING_FOR_RESP = 4;
    public static final ThreadLocal threadLocal = new ThreadLocal();
    private final Map attributeStore = new HashMap();
    private Runnable task;
    private boolean isTaskKnown = false;
    private int state;
    private long taskStartTime = -1L;
    private Thread thisThread;
    private static final Map threadMonitorContexts = new HashMap();

    public void setTask(Runnable runnable) {
        this.task = runnable;
        if (runnable == null) {
            return;
        }
        if (runnable instanceof TaskWrapper) {
            TaskWrapper taskWrapper = (TaskWrapper)runnable;
            this.isTaskKnown = taskWrapper.getTask() instanceof GWRunnable;
        }
    }

    public Thread getThread() {
        return this.thisThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startThread() {
        ThreadMonitorContext context = new ThreadMonitorContext();
        threadLocal.set(context);
        Map map = threadMonitorContexts;
        synchronized (map) {
            threadMonitorContexts.put(Thread.currentThread().getName(), context);
        }
        context.state = 1;
        context.thisThread = Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endThread() {
        Map map = threadMonitorContexts;
        synchronized (map) {
            threadMonitorContexts.remove(Thread.currentThread().getName());
        }
        threadLocal.set(null);
    }

    public static void waitingInQueue() {
        ThreadMonitorContext context = (ThreadMonitorContext)threadLocal.get();
        if (context == null) {
            return;
        }
        context.state = 2;
    }

    public long getTaskStartTime() {
        return this.taskStartTime;
    }

    public static void newTask(Runnable task) {
        ThreadMonitorContext context = (ThreadMonitorContext)threadLocal.get();
        if (context == null) {
            return;
        }
        context.setTask(task);
        context.taskStartTime = System.currentTimeMillis();
        context.state = 3;
        MonitoringSubsystem.handleEvent(SRAEvent.START_TASK, context);
    }

    public static void taskEnds() {
        ThreadMonitorContext context = (ThreadMonitorContext)threadLocal.get();
        if (context == null || context.state == 2) {
            return;
        }
        context.state = 2;
        context.setTask(null);
        context.taskStartTime = -1L;
        MonitoringSubsystem.handleEvent(SRAEvent.END_TASK, context);
    }

    public Runnable getTask() {
        return this.task;
    }

    public boolean isTaskKnown() {
        return this.isTaskKnown;
    }

    public int getState() {
        return this.state;
    }

    public static Map getThreadMonitorContexts() {
        return new HashMap(threadMonitorContexts);
    }

    public static ThreadMonitorContext getContext() {
        ThreadMonitorContext context = (ThreadMonitorContext)threadLocal.get();
        return context;
    }

    public static void storeAttribute(Object key, Object value) {
        ThreadMonitorContext context = (ThreadMonitorContext)threadLocal.get();
        if (context == null) {
            return;
        }
        context.attributeStore.put(key, value);
    }

    public static Object retrieveAttribute(Object key) {
        ThreadMonitorContext context = (ThreadMonitorContext)threadLocal.get();
        if (context == null) {
            return null;
        }
        return context.attributeStore.get(key);
    }
}

