/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

public class TaskWrapper
implements Runnable {
    private Runnable task;
    private long inQueueTime;
    private long queueTime;
    private long taskCreationTime;

    public long getQueueTime() {
        return this.queueTime;
    }

    public long getTaskCreationTime() {
        return this.taskCreationTime;
    }

    public TaskWrapper(Runnable task) {
        this.task = task;
    }

    public static TaskWrapper wrap(Runnable task) {
        if (task instanceof TaskWrapper) {
            return (TaskWrapper)task;
        }
        return new TaskWrapper(task);
    }

    public void run() {
        this.queueTime = System.currentTimeMillis() - this.inQueueTime;
        this.task.run();
    }

    public Runnable getTask() {
        return this.task;
    }

    public void queued() {
        this.taskCreationTime = this.inQueueTime = System.currentTimeMillis();
    }

    public void deQueued() {
    }

    public static Runnable unwrap(Runnable task) {
        if (task instanceof TaskWrapper) {
            return ((TaskWrapper)task).getTask();
        }
        return task;
    }

    public Runnable unwrap() {
        return this.task;
    }
}

