/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.PlatformProfile;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.HostAvailabilityEvent;
import com.sun.portal.util.HostAvailabilityListener;
import com.sun.portal.util.HostChecker;
import com.sun.portal.util.SystemProperties;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServersList
extends HostAvailabilityListener {
    static Set _servers = new HashSet();
    public static Map _unavailable_servers = new HashMap();
    private static Iterator iterator;
    private static Logger logger;
    private static ServersList instance;
    static /* synthetic */ Class class$com$sun$portal$util$ServersList;

    public static ServersList getInstance() {
        return instance;
    }

    private static List getISServersList() {
        List<String> isServersList = new ArrayList();
        String igString = SystemProperties.get("gateway.ignoreServerList");
        if (igString != null && igString.equalsIgnoreCase("true")) {
            String protocol = null;
            String port = null;
            String host = null;
            protocol = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.server.protocol");
            host = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.server.host");
            port = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.server.port");
            String url = protocol + "://" + host + ":" + port;
            GWDebug.debug.message("ServersList::<init>: adding server " + url);
            isServersList.add(url);
        } else {
            isServersList = PlatformProfile.getStringList("server-list");
        }
        return isServersList;
    }

    private static List getIntersection(List all_identity_servers, List all_portal_servers) {
        List<String> all_servers = new ArrayList();
        Iterator is_iter = all_identity_servers.iterator();
        while (is_iter.hasNext()) {
            String currentIS = (String)is_iter.next();
            Iterator ps_iter = all_portal_servers.iterator();
            while (ps_iter.hasNext()) {
                String currentPS = ((String)ps_iter.next()).trim();
                if (!currentIS.startsWith(currentPS)) continue;
                all_servers.add(currentIS);
            }
        }
        if (all_servers.size() == 0) {
            all_servers = all_identity_servers;
        }
        return all_servers;
    }

    private ServersList() {
        this.addHostAvailabilityListener(this);
    }

    public static boolean contains(String server) {
        if (server == null || server.trim().length() == 0) {
            return false;
        }
        return _servers.contains(server.toLowerCase());
    }

    private static synchronized String getServer() {
        if (iterator.hasNext()) {
            return iterator.next().toString();
        }
        iterator = _servers.iterator();
        return iterator.next().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hostAvailabilityChanged(HostAvailabilityEvent hae) {
        if (hae.getHostType() == 1) {
            Map map = _unavailable_servers;
            synchronized (map) {
                if (hae.getHostStatus() == 1) {
                    _unavailable_servers.remove(hae.getHost());
                } else if (hae.getHostStatus() == 2) {
                    long time = System.currentTimeMillis();
                    _unavailable_servers.put(hae.getHost(), new Long(time));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean aLive(String server) {
        Map map = _unavailable_servers;
        synchronized (map) {
            if (!_unavailable_servers.isEmpty() && _unavailable_servers.get(server) != null) {
                return false;
            }
        }
        try {
            URL url = new URL(server);
            return HostChecker.isHostAvailable(url, 1);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "PSSR_CSPU068", e);
            return false;
        }
    }

    public String getServeraLive() {
        String server = null;
        boolean alive = false;
        int total = _servers.size();
        for (int count = 0; !alive && count < total; ++count) {
            server = ServersList.getServer();
            alive = ServersList.aLive(server);
        }
        return server;
    }

    public String getServeraLive(String server) {
        if (ServersList.aLive(server)) {
            return server;
        }
        return instance.getServeraLive();
    }

    public static Set getAllSessionServersSet() {
        return _servers;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$util$ServersList == null ? (class$com$sun$portal$util$ServersList = ServersList.class$("com.sun.portal.util.ServersList")) : class$com$sun$portal$util$ServersList));
        instance = new ServersList();
        List all_identity_servers = ServersList.getISServersList();
        List all_portal_servers = GatewayProfile.getStringList("PortalServerList");
        List all_servers = ServersList.getIntersection(all_identity_servers, all_portal_servers);
        Iterator it = all_servers.iterator();
        String pshostUrl = null;
        String protocol = null;
        String port = null;
        String host = null;
        while (it.hasNext()) {
            int indx2;
            int indx1;
            pshostUrl = it.next().toString().trim().toLowerCase();
            int tmpindx = pshostUrl.lastIndexOf(124);
            if (tmpindx > 0) {
                pshostUrl = pshostUrl.substring(0, tmpindx).trim();
            }
            if ((indx1 = pshostUrl.indexOf(":/")) == -1) {
                indx1 = pshostUrl.indexOf(58);
                if (indx1 == -1) {
                    pshostUrl = "http://" + pshostUrl + ":80";
                } else {
                    indx2 = pshostUrl.indexOf(47, indx1);
                    if (indx2 == -1) {
                        indx2 = pshostUrl.length();
                    }
                    host = pshostUrl.substring(0, indx1);
                    port = pshostUrl.substring(indx1 + 1, indx2);
                    int portVal = -1;
                    try {
                        portVal = Integer.parseInt(port);
                    }
                    catch (NumberFormatException nfex) {
                        portVal = -1;
                    }
                    if (portVal == -1) {
                        portVal = 80;
                    }
                    if (portVal == 80) {
                        protocol = "http://";
                    } else {
                        if (portVal != 443) continue;
                        protocol = "https://";
                    }
                    pshostUrl = protocol + host + ":" + portVal;
                }
            } else {
                indx2 = pshostUrl.indexOf(58, indx1 + 1);
                if (indx2 == -1) {
                    protocol = pshostUrl.substring(0, indx1);
                    if (protocol.equals("http")) {
                        port = ":80";
                    } else {
                        if (!protocol.equals("https")) continue;
                        port = ":443";
                    }
                    if (pshostUrl.endsWith("/")) {
                        pshostUrl = pshostUrl.substring(0, pshostUrl.length() - 1);
                    }
                    pshostUrl = pshostUrl + port;
                }
            }
            _servers.add(pshostUrl);
        }
        iterator = _servers.iterator();
    }
}

