/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.SystemProperties;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;

public class ServerCertApprovalCallback
implements SSLCertificateApprovalCallback {
    private String reqHost = null;
    private static ServerCertApprovalCallback theInstance = null;
    static boolean trustAllServerCerts = false;
    protected static List srapGateway_trustedSSLDomainList = new ArrayList();
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$util$ServerCertApprovalCallback == null ? (class$com$sun$portal$util$ServerCertApprovalCallback = ServerCertApprovalCallback.class$("com.sun.portal.util.ServerCertApprovalCallback")) : class$com$sun$portal$util$ServerCertApprovalCallback));
    static /* synthetic */ Class class$com$sun$portal$util$ServerCertApprovalCallback;

    private ServerCertApprovalCallback() {
    }

    public ServerCertApprovalCallback(String host) {
        if (host != null) {
            this.reqHost = host.toLowerCase();
        }
    }

    public static ServerCertApprovalCallback getInstance() {
        if (theInstance == null) {
            theInstance = new ServerCertApprovalCallback();
        }
        return theInstance;
    }

    public boolean approve(X509Certificate cert, SSLCertificateApprovalCallback.ValidityStatus status) {
        Object[] params0 = new Object[]{cert.getSubjectDN().getName()};
        logger.log(Level.INFO, "PSSR_CSPU092", params0);
        Enumeration errors = status.getReasons();
        String certHost = ServerCertApprovalCallback.getCertHost(cert.getSubjectDN().getName());
        if (this.reqHost == null) {
            int numReasons = 0;
            while (errors.hasMoreElements()) {
                SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
                int reason = item.getReason();
                Object[] params1 = new Object[]{reason + ""};
                logger.log(Level.SEVERE, "PSSR_CSPU093", params1);
                if (reason == -8172 || reason == -8171 || reason == -8156 || reason == -8179) {
                    if (trustAllServerCerts) continue;
                    ++numReasons;
                    continue;
                }
                if (reason == -12276) {
                    if (ServerCertApprovalCallback.isTrustedDomain(certHost)) continue;
                    ++numReasons;
                    continue;
                }
                ++numReasons;
            }
            return numReasons == 0;
        }
        boolean trust = true;
        while (errors.hasMoreElements()) {
            SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
            int reason = item.getReason();
            Object[] params2 = new Object[]{reason + ""};
            logger.log(Level.SEVERE, "PSSR_CSPU094", params2);
            if (reason == -8172 || reason == -8171 || reason == -8156 || reason == -8179) {
                if (trustAllServerCerts) continue;
                trust = false;
                continue;
            }
            if (reason != -12276) {
                trust = false;
                continue;
            }
            if (ServerCertApprovalCallback.isTrustedDomain(certHost) || certHost.equalsIgnoreCase(this.reqHost)) continue;
            trust = false;
        }
        return trust;
    }

    private static boolean isTrustedDomain(String host) {
        host = host.toLowerCase();
        if (srapGateway_trustedSSLDomainList == null || srapGateway_trustedSSLDomainList.size() < 1) {
            return false;
        }
        if (srapGateway_trustedSSLDomainList.contains(host)) {
            return true;
        }
        Iterator it = srapGateway_trustedSSLDomainList.iterator();
        while (it.hasNext()) {
            String next = it.next().toString().trim();
            int indx = next.indexOf("*");
            if (indx == -1 || !(indx == 0 ? host.endsWith(next.substring(1, next.length())) : host.startsWith(next.substring(0, indx)) && host.endsWith(next.substring(indx + 1, next.length())))) continue;
            return true;
        }
        return false;
    }

    private static String getCertHost(String subjectDN) {
        StringTokenizer st = new StringTokenizer(subjectDN, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim().toLowerCase();
            if (!token.startsWith("cn=")) continue;
            return token.substring(3);
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String tmp = SystemProperties.get("gateway.trust_all_server_certs");
        trustAllServerCerts = tmp != null && tmp.equals("true");
        Iterator it = GatewayProfile.getStringList("TrustedSSLDomainList").iterator();
        while (it.hasNext()) {
            srapGateway_trustedSSLDomainList.add(it.next().toString().toLowerCase());
        }
    }
}

