/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.util.SRAEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImplFactory;
import java.util.logging.Logger;
import org.mozilla.jss.ssl.SSLSocket;

public class SRAPSocket
extends Socket {
    private Socket sock = null;
    private BufferedInputStream in = null;
    private BufferedOutputStream out = null;
    private boolean isHTTPS;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$util$SRAPSocket == null ? (class$com$sun$portal$util$SRAPSocket = SRAPSocket.class$("com.sun.portal.util.SRAPSocket")) : class$com$sun$portal$util$SRAPSocket));
    private boolean _open = true;
    static /* synthetic */ Class class$com$sun$portal$util$SRAPSocket;

    public SRAPSocket(Socket sock) throws IOException {
        this.sock = sock;
        this.isHTTPS = sock instanceof SSLSocket;
        if (this.isHTTPS) {
            MonitoringSubsystem.handleEvent(SRAEvent.SSL_SOCKET_CREATED);
        } else {
            MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_CREATED);
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new BufferedInputStream(this.sock.getInputStream());
        }
        return this.in;
    }

    public void close() throws IOException {
        if (this._open) {
            if (this.isHTTPS) {
                MonitoringSubsystem.handleEvent(SRAEvent.SSL_SOCKET_DESTROYED);
            } else {
                MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_DESTROYED);
            }
        }
        this.sock.close();
    }

    public InetAddress getInetAddress() {
        return this.sock.getInetAddress();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.sock.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.sock.getLocalAddress();
    }

    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
        }
        return this.out;
    }

    public int getPort() {
        return this.sock.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.sock.getReceiveBufferSize();
    }

    public int getSendBufferSize() throws SocketException {
        return this.sock.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.sock.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.sock.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.sock.getTcpNoDelay();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.sock.setKeepAlive(on);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.sock.setReceiveBufferSize(size);
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.sock.setSendBufferSize(size);
    }

    public static void setSocketImplFactory(SocketImplFactory fac) throws UnsupportedOperationException {
        logger.info("PSSR_CSPU091");
        throw new UnsupportedOperationException("Not supported");
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.sock.setSoLinger(on, linger);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.sock.setSoTimeout(timeout);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.sock.setTcpNoDelay(on);
    }

    public void shutdownInput() throws IOException {
        this.in.skip(this.in.available());
        this.sock.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.out.flush();
        this.sock.shutdownOutput();
    }

    public String toString() {
        try {
            return this.sock.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isSSLSocket() {
        return this.isHTTPS;
    }

    public Socket getActualSocket() {
        return this.sock;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

