/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.util.ProxyAuthFailedException;
import com.sun.portal.util.ProxyAuthNeededException;
import com.sun.portal.util.ProxyUnreachableException;
import com.sun.portal.util.SystemProperties;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.BASE64Encoder;

public class PingServiceRequest {
    private String serviceHost = null;
    private int servicePort = -1;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyUser = null;
    private String proxyPassword = null;
    private boolean proxyAuthRequired = false;
    private static String retries = SystemProperties.get("gateway.sockretries", "2");
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$util$PingServiceRequest == null ? (class$com$sun$portal$util$PingServiceRequest = PingServiceRequest.class$("com.sun.portal.util.PingServiceRequest")) : class$com$sun$portal$util$PingServiceRequest));
    static /* synthetic */ Class class$com$sun$portal$util$PingServiceRequest;

    public PingServiceRequest(URL serviceURL) {
        this.serviceHost = serviceURL.getHost();
        this.servicePort = serviceURL.getPort();
    }

    public PingServiceRequest(URL serviceURL, String proxyHost, int proxyPort) {
        this.serviceHost = serviceURL.getHost();
        this.servicePort = serviceURL.getPort();
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public PingServiceRequest(URL serviceURL, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
        this.serviceHost = serviceURL.getHost();
        this.servicePort = serviceURL.getPort();
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
        this.proxyAuthRequired = true;
    }

    public PingServiceRequest(String serviceHost, int servicePort, String proxyHost, int proxyPort) {
        this.serviceHost = serviceHost;
        this.servicePort = servicePort;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public PingServiceRequest(String serviceHost, int servicePort, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
        this.serviceHost = serviceHost;
        this.servicePort = servicePort;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
        this.proxyAuthRequired = true;
    }

    public boolean isServiceAlive() throws ProxyAuthNeededException, ProxyAuthFailedException, ProxyUnreachableException {
        int retry = Integer.parseInt(retries);
        for (int i = 0; i < retry; ++i) {
            Object[] params0 = new Object[]{i + ""};
            logger.log(Level.INFO, "PSSR_CSPU087", params0);
            boolean state = this.checkService();
            if (state) {
                return true;
            }
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean checkService() throws ProxyAuthNeededException, ProxyAuthFailedException, ProxyUnreachableException {
        String message = new String("\n***************Check Proxy information ....**************\n");
        message = message + "Proxy Host : " + this.proxyHost + "\n";
        message = message + "Proxy Port : " + this.proxyPort + "\n";
        message = message + "Proxy User : " + this.proxyUser + "\n";
        String encodePassword = null;
        if (this.proxyPassword != null) {
            encodePassword = "isPresent";
        }
        message = message + "Proxy Password : " + encodePassword + "\n";
        message = message + "Service Host : " + this.serviceHost + "\n";
        message = message + "Service Port : " + this.servicePort + "\n";
        message = message + "*********************************************************\n";
        Object[] params1 = new Object[]{message.toString()};
        logger.log(Level.INFO, "PSSR_CSPU088", params1);
        if (this.proxyHost == null || this.proxyHost.equals("null") || this.proxyHost.trim().length() < 1) {
            return this.directConnection();
        }
        return this.proxyConnection();
    }

    private boolean directConnection() {
        try {
            Socket socket = new Socket(this.serviceHost, this.servicePort);
            socket.close();
            return true;
        }
        catch (Exception soe) {
            Object[] params2 = new Object[]{this.serviceHost, ":", this.servicePort + "", soe};
            logger.log(Level.SEVERE, "PSSR_CSPU089", params2);
            return false;
        }
    }

    private boolean proxyConnection() throws ProxyAuthNeededException, ProxyAuthFailedException, ProxyUnreachableException {
        StringBuffer header = new StringBuffer("CONNECT ").append(this.serviceHost).append(":").append(this.servicePort).append(" HTTP/1.0\r\n");
        if (this.proxyAuthRequired) {
            if (this.proxyUser == null || this.proxyPassword == null) {
                throw new ProxyAuthFailedException("Proxy Password or Proxy User is null");
            }
            BASE64Encoder encoder = new BASE64Encoder();
            String encodeAuthInfo = encoder.encode((this.proxyUser + ":" + this.proxyPassword).toString().getBytes());
            header.append("Proxy-Authorization: Basic ").append(encodeAuthInfo).append("\r\n\r\n");
        } else {
            header.append("\r\n");
        }
        try {
            Socket toProxy = new Socket(this.proxyHost, this.proxyPort);
            DataInputStream in_b = new DataInputStream(toProxy.getInputStream());
            DataOutputStream out_b = new DataOutputStream(toProxy.getOutputStream());
            out_b.write(header.toString().getBytes(), 0, header.length());
            BufferedReader br = new BufferedReader(new InputStreamReader(in_b));
            String line = "";
            while ((line = br.readLine()) != null && line.length() >= 3) {
                if (!line.startsWith("HTTP/1")) continue;
                int s = line.indexOf(" ");
                String num = line.substring(s + 1);
                if (num.startsWith("407")) {
                    throw new ProxyAuthNeededException("Proxy Authentication Required");
                }
                if (num.startsWith("401")) {
                    throw new ProxyAuthFailedException("Proxy Authentication Failed : Digest Authentication not supported");
                }
                if (!num.startsWith("500")) continue;
                return false;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            return false;
        }
        catch (IOException e) {
            throw new ProxyUnreachableException("Proxy is not reachable " + this.proxyHost + ":" + this.proxyPort);
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

