/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.iplanet.log.LogException;
import com.iplanet.log.LogManager;
import com.iplanet.log.LogRecord;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.SSOUtil;
import com.sun.portal.util.SystemProperties;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetletLogMgr {
    private static String logName = "srapNetlet";
    public static LogManager lm = null;
    public static boolean loggingEnabled = false;
    private static int logId = 0;
    public static Hashtable logIdMap = new Hashtable();
    private static String actualLogName = null;
    private static boolean logError = false;
    private static String platformLogName = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$util$NetletLogMgr == null ? (class$com$sun$portal$util$NetletLogMgr = NetletLogMgr.class$("com.sun.portal.util.NetletLogMgr")) : class$com$sun$portal$util$NetletLogMgr));
    static /* synthetic */ Class class$com$sun$portal$util$NetletLogMgr;

    public static String getUserId(String sessionID) {
        try {
            SSOToken ssoToken = SSOUtil.getSSOToken((String)sessionID);
            String userDN = ssoToken.getPrincipal().getName();
            return userDN.substring(userDN.indexOf("=") + 1, userDN.indexOf(","));
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSSR_CSPU078", ex);
            return "";
        }
    }

    public static synchronized int getLogId() {
        return ++logId;
    }

    public static void createDefault() {
        NetletLogMgr.createDefault(logName);
    }

    private static SSOToken createSession(String sessid) {
        SSOToken token = null;
        try {
            token = SSOUtil.getSSOTokenNoDecode((String)sessid);
        }
        catch (SSOException ex) {
            logger.severe("PSSR_CSPU079");
            ex.printStackTrace();
            token = null;
        }
        catch (Exception ex) {
            logger.severe("PSSR_CSPU080");
            ex.printStackTrace();
            token = null;
        }
        return token;
    }

    public static void createDefault(String name) {
        if (loggingEnabled) {
            lm = new LogManager(GWLogManager.appSession);
            if (name != null && name.length() > 0) {
                logName = name;
            }
            if (platformLogName != null) {
                logName = platformLogName;
            }
            try {
                lm.create(logName);
                actualLogName = logName;
            }
            catch (LogException e) {
                actualLogName = null;
                logger.severe("PSSR_CSPU081");
                Object[] params4 = new Object[]{e.toString()};
                logger.log(Level.SEVERE, "PSSR_CSPU082", params4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String type, String msg) {
        if (lm == null) {
            return;
        }
        if (logError) {
            return;
        }
        if (!loggingEnabled) {
            return;
        }
        try {
            LogRecord lr = new LogRecord("ACCESS", msg);
            lm.write(lr, logName);
        }
        catch (Exception e) {
            logError = true;
            logger.severe("PSSR_CSPU083");
            String reason = e.toString();
            Object[] params6 = new Object[]{reason};
            logger.log(Level.SEVERE, "PSSR_CSPU084", params6);
            String string = actualLogName;
            synchronized (string) {
                if (logError && !NetletLogMgr.isAppSessionValid(GWLogManager.appSession)) {
                    NetletLogMgr.createDefault(actualLogName);
                    logError = false;
                }
            }
        }
    }

    private static boolean isAppSessionValid(SSOToken token) {
        boolean isvalid = false;
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            isvalid = manager.isValidToken(token);
        }
        catch (SSOException sSOException) {
            // empty catch block
        }
        return isvalid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        platformLogName = SystemProperties.get("netlet.logname");
        if (platformLogName != null && (platformLogName = platformLogName.trim().replace('-', '_')).length() == 0) {
            platformLogName = null;
        }
        loggingEnabled = GatewayProfile.getBoolean("NetletLoggingEnabled", false);
    }
}

