/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.DomainWebProxyConfig;
import com.sun.portal.util.HostAvailabilityEventImpl;
import com.sun.portal.util.HostAvailabilityMediator;
import com.sun.portal.util.PingServiceRequest;
import com.sun.portal.util.ProxyAuthFailedException;
import com.sun.portal.util.ProxyAuthNeededException;
import com.sun.portal.util.ProxyUnreachableException;
import com.sun.portal.util.watch_unavailable;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.BASE64Decoder;

public class HostChecker {
    private static int _retry;
    private static final int PROXY_HTTP_PORT = 8080;
    private static Logger logger;
    static /* synthetic */ Class class$com$sun$portal$util$HostChecker;

    public static boolean isHostAvailable(URL host, int hostType) {
        try {
            String proxyHost;
            String proxy = DomainWebProxyConfig.getWebProxy(host.getProtocol(), host.getHost());
            String proxyAuth = null;
            if (proxy != null) {
                proxyHost = null;
                int portIndex = proxy.indexOf(58);
                proxyHost = portIndex == -1 ? proxy : proxy.substring(0, proxy.indexOf(58));
                proxyAuth = DomainWebProxyConfig.getProxyPassword(proxyHost);
            }
            proxyHost = null;
            int proxyPort = -1;
            String proxyUser = null;
            PingServiceRequest psr = null;
            String proxyPassword = null;
            if (proxy == null) {
                psr = new PingServiceRequest(host);
            } else {
                int portIndex = proxy.indexOf(58);
                if (portIndex == -1) {
                    proxyPort = 8080;
                    proxyHost = proxy;
                } else {
                    proxyHost = proxy.substring(0, proxy.indexOf(58));
                    proxyPort = Integer.parseInt(proxy.substring(proxy.indexOf(58) + 1));
                }
                BASE64Decoder decoder = new BASE64Decoder();
                if (proxyAuth != null) {
                    try {
                        proxyAuth = new String(decoder.decodeBuffer(proxyAuth));
                    }
                    catch (IOException ioe) {
                        logger.log(Level.SEVERE, "PSSR_CSPU071", ioe);
                    }
                }
                if (proxyAuth == null) {
                    psr = new PingServiceRequest(host, proxyHost, proxyPort);
                } else {
                    proxyUser = proxyAuth.substring(0, proxyAuth.indexOf(58)).trim();
                    proxyPassword = proxyAuth.substring(proxyAuth.indexOf(58) + 1).trim();
                    psr = new PingServiceRequest(host, proxyHost, proxyPort, proxyUser, proxyPassword);
                }
            }
            boolean isAlive = psr.isServiceAlive();
            if (!isAlive) {
                HostAvailabilityEventImpl event = new HostAvailabilityEventImpl();
                event.setHost(host.toString());
                event.setHostStatus(2);
                event.setHostType(hostType);
                HostAvailabilityMediator.getHostAvailabilityMediator();
                HostAvailabilityMediator.notifyListeners(event);
                watch_unavailable wus = new watch_unavailable(host.toString(), _retry, proxyHost, proxyPort, proxyUser, proxyPassword, hostType);
                wus.start();
            }
            return isAlive;
        }
        catch (NumberFormatException e) {
            logger.log(Level.SEVERE, "PSSR_CSPU072", e);
        }
        catch (ProxyUnreachableException e) {
            logger.log(Level.SEVERE, "PSSR_CSPU073", e);
        }
        catch (ProxyAuthNeededException e) {
            logger.log(Level.SEVERE, "PSSR_CSPU074", e);
        }
        catch (ProxyAuthFailedException e) {
            logger.log(Level.SEVERE, "PSSR_CSPU075", e);
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$util$HostChecker == null ? (class$com$sun$portal$util$HostChecker = HostChecker.class$("com.sun.portal.util.HostChecker")) : class$com$sun$portal$util$HostChecker));
        _retry = GatewayProfile.getInt("ServerRetryInterval", 5);
    }
}

