/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.server.GatewayContext;
import com.sun.portal.rproxy.server.GatewayContextFactory;
import com.sun.portal.util.IntranetInfo;
import com.sun.portal.util.StringHelper;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class GatewayListIntranetInfo
implements IntranetInfo {
    private static final char PIPE = '|';
    private static final char SPACE = ' ';
    private static final char DOT = '.';
    private static final String STAR_DOT_STRING = "*.";
    private static final String STAR_STRING = "*";
    private final HashMap proxyMap = new HashMap();
    private String defaultDomain;
    private String defaultSubDomainAndDomain;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$util$GatewayListIntranetInfo == null ? (class$com$sun$portal$util$GatewayListIntranetInfo = GatewayListIntranetInfo.class$("com.sun.portal.util.GatewayListIntranetInfo")) : class$com$sun$portal$util$GatewayListIntranetInfo));
    static /* synthetic */ Class class$com$sun$portal$util$GatewayListIntranetInfo;

    private void initDefaultDomainSubDomain() {
        GatewayContext gatewayContext = GatewayContextFactory.getGatewayContext();
        String defaultDomainSubDomain = gatewayContext.getDefaultDomainAndSubDomain();
        String[] splitEntry = StringHelper.split(defaultDomainSubDomain, '|');
        if (splitEntry.length == 0) {
            this.defaultDomain = "";
            this.defaultSubDomainAndDomain = "";
            logger.severe("PSSR_CSPU016");
        } else if (splitEntry.length == 1) {
            this.defaultSubDomainAndDomain = this.defaultDomain = '.' + splitEntry[0];
        } else {
            this.defaultDomain = '.' + splitEntry[0];
            this.defaultSubDomainAndDomain = '.' + splitEntry[1] + this.defaultDomain;
        }
    }

    private void populateProxyList(String entry) {
        String domainProxy;
        String[] splitEntry = StringHelper.split(entry, '|');
        if (splitEntry.length == 0) {
            return;
        }
        String[] domainEntry = StringHelper.split(splitEntry[0], ' ');
        String domainName = domainEntry.length > 0 ? domainEntry[0].toLowerCase() : null;
        String string = domainProxy = domainEntry.length > 1 ? domainEntry[1] : null;
        if (this.proxyMap.get(domainName) == null) {
            this.proxyMap.put(domainName, domainProxy);
        }
        for (int i = 1; i < splitEntry.length; ++i) {
            String subDomainName;
            String[] temp = StringHelper.split(splitEntry[i], ' ');
            if (temp.length == 0 || this.proxyMap.get(subDomainName = temp[0].toLowerCase()) != null) continue;
            String subDomainProxy = temp.length > 1 ? temp[1] : (subDomainName.equals(STAR_STRING) ? null : domainProxy);
            this.proxyMap.put(subDomainName + '.' + domainName, subDomainProxy);
        }
    }

    private String getFQDNEntry(String host) {
        String entry = this.getMapEntry(host);
        if (entry != null) {
            return entry;
        }
        int index = host.indexOf(46);
        String newHost = null;
        if (index == -1) {
            newHost = host + this.defaultSubDomainAndDomain;
        }
        return newHost == null ? null : this.getMapEntry(newHost);
    }

    private String getMapEntry(String host) {
        int index = 0;
        do {
            if (this.proxyMap.containsKey(host)) {
                return host;
            }
            index = host.indexOf(46);
            host = host.substring(index + 1);
            String starHost = STAR_DOT_STRING + host;
            if (!this.proxyMap.containsKey(starHost)) continue;
            return starHost;
        } while (index != -1);
        return null;
    }

    public String getWebProxy(String protocol, String host) {
        String entry = this.getFQDNEntry(host);
        return entry == null ? (String)this.proxyMap.get(STAR_STRING) : (String)this.proxyMap.get(entry);
    }

    public boolean containHost(String host) {
        String entry = this.getFQDNEntry(host);
        return entry != null;
    }

    public GatewayListIntranetInfo() {
        GatewayContext gatewayContext = GatewayContextFactory.getGatewayContext();
        List domainsAndSubDomainsList = gatewayContext.getDomainsAndSubDomainsList();
        for (int i = 0; i < domainsAndSubDomainsList.size(); ++i) {
            this.populateProxyList(domainsAndSubDomainsList.get(i).toString());
        }
        this.initDefaultDomainSubDomain();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

