/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.Password;
import com.sun.portal.cli.cert.SRADecoderException;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.cert.CertAdminPasswordCallback;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.SocketException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.util.PasswordCallback;

public class GWNSSInit {
    public static String nickname = "server-cert";
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$util$GWNSSInit == null ? (class$com$sun$portal$util$GWNSSInit = GWNSSInit.class$("com.sun.portal.util.GWNSSInit")) : class$com$sun$portal$util$GWNSSInit));
    public static final int[] cipherSuites128BitSSL2 = new int[]{65287, 65283, 65281};
    public static final int[] cipherSuites128BitSSL3 = new int[]{10, 4, 5, 65279};
    public static final int[] cipherSuites40BitSSL2 = new int[]{65284, 65282};
    public static final int[] cipherSuites40BitSSL3 = new int[]{3, 6};
    public static final int[] cipherSuitesOthersSSL2 = new int[]{65286};
    public static final int[] cipherSuitesOthersSSL3 = new int[]{9, 65278};
    public static final int[] cipherSuitesSSL3Null = new int[]{1};
    public static final int[] cipherSuites128BitTLS = new int[0];
    public static final int[] cipherSuitesOthersTLS = new int[]{98, 100};
    private static final int[] cipherSuitesNotSupported = new int[]{102};
    static /* synthetic */ Class class$com$sun$portal$util$GWNSSInit;

    public static void enableAllCiphers() throws SocketException {
        GWNSSInit.enableCipher(cipherSuites40BitSSL2);
        GWNSSInit.enableCipher(cipherSuites40BitSSL3);
        GWNSSInit.enableCipher(cipherSuitesOthersSSL2);
        GWNSSInit.enableCipher(cipherSuitesOthersSSL3);
        GWNSSInit.enableCipher(cipherSuites128BitSSL2);
        GWNSSInit.enableCipher(cipherSuites128BitSSL3);
        GWNSSInit.enableCipher(cipherSuitesOthersTLS);
        GWNSSInit.enableCipher(cipherSuites128BitTLS);
        GWNSSInit.enableCipher(cipherSuitesSSL3Null);
    }

    public static void disableAllCiphers() throws SocketException {
        GWNSSInit.disableCipher(cipherSuites40BitSSL2);
        GWNSSInit.disableCipher(cipherSuites40BitSSL3);
        GWNSSInit.disableCipher(cipherSuitesOthersSSL2);
        GWNSSInit.disableCipher(cipherSuitesOthersSSL3);
        GWNSSInit.disableCipher(cipherSuites128BitSSL2);
        GWNSSInit.disableCipher(cipherSuites128BitSSL3);
        GWNSSInit.disableCipher(cipherSuitesOthersTLS);
        GWNSSInit.disableCipher(cipherSuites128BitTLS);
        GWNSSInit.disableCipher(cipherSuitesSSL3Null);
    }

    public static void enableCipher(int[] cipherSuites) throws SocketException {
        GWNSSInit.setCipherState(cipherSuites, true);
    }

    public static void disableCipher(int[] cipherSuites) throws SocketException {
        GWNSSInit.setCipherState(cipherSuites, false);
    }

    private static void setCipherState(int[] cipherSuites, boolean state) throws SocketException {
        for (int j = 0; j < cipherSuites.length; ++j) {
            SSLSocket.setCipherPreferenceDefault((int)cipherSuites[j], (boolean)state);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean initialize() throws SocketException {
        String jssPassword;
        String certdbDir = System.getProperty("gateway.keybase", System.getProperty("SRAP_CONFIG_DIR", "/etc/opt/SUNWportal"));
        Object[] params0 = new Object[]{certdbDir};
        logger.log(Level.INFO, "PSSR_CSPU055", params0);
        try {
            JSSUtil.setDefaultDecoder((String)certdbDir);
        }
        catch (SRADecoderException ex) {
            Object[] params1 = new Object[]{ex.getMessage()};
            logger.log(Level.SEVERE, "PSSR_CSPU056", params1);
        }
        String nicknamefile = System.getProperty("gateway.nickname", System.getProperty("SRAP_CONFIG_DIR", "/etc/opt/SUNWportal") + File.separatorChar + "cert" + File.separatorChar + ".nickname");
        Object[] params2 = new Object[]{nicknamefile};
        logger.log(Level.INFO, "PSSR_CSPU057", params2);
        if (nicknamefile != null) {
            try {
                FileInputStream fis = new FileInputStream(nicknamefile);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                nickname = br.readLine();
            }
            catch (Exception ex) {
                Object[] params3 = new Object[]{nicknamefile};
                logger.log(Level.SEVERE, "PSSR_CSPU058", params3);
            }
        } else {
            logger.severe("PSSR_CSPU059");
        }
        String pwfile = System.getProperty("gateway.pass", System.getProperty("SRAP_CONFIG_DIR", "/etc/opt/SUNWportal") + File.separatorChar + "cert" + File.separatorChar + ".jsspass");
        Object[] params5 = new Object[]{pwfile};
        logger.log(Level.INFO, "PSSR_CSPU060", params5);
        if (pwfile == null) {
            logger.severe("PSSR_CSPU063");
            return false;
        }
        try {
            FileInputStream fis = new FileInputStream(pwfile);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            jssPassword = br.readLine();
            Password pass = JSSUtil.decryptPassword((String)jssPassword);
            jssPassword = pass.getPassword();
            if (pass.isEncrypted()) {
                logger.info("PSSR_CSPU061");
            }
        }
        catch (Exception ex) {
            Object[] params7 = new Object[]{pwfile};
            logger.log(Level.SEVERE, "PSSR_CSPU062", params7);
            return false;
        }
        try {
            CryptoManager.InitializationValues vals = new CryptoManager.InitializationValues(certdbDir);
            CryptoManager.initialize((CryptoManager.InitializationValues)vals);
            CryptoManager.getInstance().setPasswordCallback((PasswordCallback)new CertAdminPasswordCallback(jssPassword));
            GWNSSInit.checkCertificateValidity();
            logger.info("PSSR_CSPU064");
        }
        catch (KeyDatabaseException kdbe) {
            logger.log(Level.SEVERE, "PSSR_CSPU065", kdbe);
            return false;
        }
        catch (CertDatabaseException cdbe) {
            logger.log(Level.SEVERE, "PSSR_CSPU066", cdbe);
            return false;
        }
        catch (AlreadyInitializedException aie) {
            logger.warning("GWNSSInit: CryptoManager already initialized." + (Object)((Object)aie));
            return true;
        }
        catch (Exception e) {
            Object[] params12 = new Object[]{e.getMessage()};
            logger.log(Level.SEVERE, "PSSR_CSPU067", params12);
            return false;
        }
        GWNSSInit.disableCipher(cipherSuitesNotSupported);
        GWNSSInit.enableAllCiphers();
        return true;
    }

    private static void checkCertificateValidity() throws ObjectNotFoundException, TokenException, CryptoManager.NotInitializedException, CertificateEncodingException, CertificateException {
        X509Certificate cert = CryptoManager.getInstance().findCertByNickname(nickname);
        ByteArrayInputStream bais = new ByteArrayInputStream(cert.getEncoded());
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        java.security.cert.X509Certificate jcert = (java.security.cert.X509Certificate)cf.generateCertificate(bais);
        try {
            jcert.checkValidity();
        }
        catch (CertificateExpiredException ex) {
            Object[] params = new Object[]{nickname};
            logger.log(Level.INFO, "PSSR_CSPU102", params);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "PSSR_CSPU103", ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

