/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.iplanet.log.LogException;
import com.iplanet.log.LogManager;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.ApplicationLogin;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.LogCreateThread;
import com.sun.portal.util.RemoteWriteLogThread;
import com.sun.portal.util.SSOUtil;
import com.sun.portal.util.SystemProperties;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GWLogManager {
    private static String logName = "srapGateway";
    public static LogManager lm = null;
    public static boolean loggingEnabled = false;
    public static SSOToken appSession = null;
    private static int logId = 0;
    public static Hashtable logIdMap = new Hashtable();
    static String actualLogName = null;
    static boolean logError = false;
    private static String platformLogName = null;
    private static LogCreateThread createThread = null;
    private static RemoteWriteLogThread remoteLogThread = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$util$GWLogManager == null ? (class$com$sun$portal$util$GWLogManager = GWLogManager.class$("com.sun.portal.util.GWLogManager")) : class$com$sun$portal$util$GWLogManager));
    static boolean logCreateInvoked;
    static /* synthetic */ Class class$com$sun$portal$util$GWLogManager;

    public static synchronized void createNewAppSession() {
        GWLogManager.createNewAppSession(false);
    }

    public static synchronized void createNewAppSession(boolean internal) {
        logger.info("PSSR_CSPU026");
        try {
            String sessid = ApplicationLogin.login("srapGateway");
            appSession = GWLogManager.createSession(sessid);
            Object[] params1 = new Object[]{appSession};
            logger.log(Level.INFO, "PSSR_CSPU027", params1);
            if (!logCreateInvoked && loggingEnabled && !internal) {
                logger.info("PSSR_CSPU028");
                GWLogManager.recreateLog();
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSSR_CSPU029", ex);
        }
    }

    public static String getUserId(String sessionID) {
        block5: {
            if (sessionID == null) {
                return "";
            }
            try {
                SSOToken ssoToken = SSOUtil.getSSOTokenThrowExceptionToClient((String)sessionID);
                String userDN = ssoToken.getPrincipal().getName();
                return userDN.substring(userDN.indexOf("=") + 1, userDN.indexOf(","));
            }
            catch (SSOException ssoexp) {
                if (ssoexp.toString().indexOf("Session state is invalid") != -1 && GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("GWLogManager: Unable to get user ID, did you not login!!");
                }
            }
            catch (Exception ex) {
                if (!GWDebug.debug.errorEnabled()) break block5;
                GWDebug.debug.error("GWLogManager: Unable to get user ID -> " + ex);
            }
        }
        return "";
    }

    public static synchronized int getLogId() {
        return ++logId;
    }

    public static void createDefault() {
        GWLogManager.createDefault(logName);
    }

    private static SSOToken createSession(String sessid) {
        SSOToken token = null;
        try {
            token = SSOUtil.getSSOTokenNoDecode((String)sessid);
        }
        catch (SSOException ex) {
            logger.log(Level.SEVERE, "PSSR_CSPU030", ex);
            token = null;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSSR_CSPU031", ex);
            token = null;
        }
        return token;
    }

    public static void initialise() {
        loggingEnabled = GatewayProfile.getBoolean("LoggingEnabled", false);
    }

    public static void createDefault(String name) {
        if (appSession == null) {
            GWLogManager.createNewAppSession(true);
        }
        if (loggingEnabled) {
            lm = new LogManager(appSession);
            if (name != null && name.length() > 0) {
                logName = name;
            }
            if (platformLogName != null) {
                logName = platformLogName;
            }
            try {
                System.out.println("Creating " + logName);
                lm.create(logName);
                actualLogName = logName;
            }
            catch (LogException e) {
                actualLogName = null;
                logger.severe("PSSR_CSPU032");
                Object[] params7 = new Object[]{e.toString()};
                logger.log(Level.SEVERE, "PSSR_CSPU033", params7);
            }
        }
    }

    public static void write(String type, String msg) {
        if (lm == null) {
            return;
        }
        if (logError) {
            return;
        }
        if (!loggingEnabled) {
            return;
        }
        Object[] params8 = new Object[]{appSession};
        logger.log(Level.INFO, "PSSR_CSPU034", params8);
        if (!GWLogManager.isAppSessionValid(appSession)) {
            Object[] params9 = new Object[]{appSession};
            logger.log(Level.SEVERE, "PSSR_CSPU035", params9);
            logger.severe("PSSR_CSPU036");
            GWLogManager.recreateLog();
            return;
        }
        try {
            remoteLogThread.addEntryForLogging("ACCESS", msg);
        }
        catch (Exception e) {
            logError = true;
            Object[] params = new Object[]{e};
            logger.log(Level.SEVERE, "PSSR_CSPU037", e);
            String reason = e.toString();
            Object[] params12 = new Object[]{reason};
            logger.log(Level.SEVERE, "PSSR_CSPU038", params12);
            GWLogManager.recreateLog();
        }
    }

    private static synchronized void recreateLog() {
        if (logCreateInvoked) {
            logger.info("PSSR_CSPU039");
            return;
        }
        logError = true;
        logger.info("PSSR_CSPU040");
        if (!GWLogManager.isAppSessionValid(appSession)) {
            appSession = null;
            GWLogManager.createNewAppSession(true);
        }
        logCreateInvoked = true;
        logger.info("PSSR_CSPU041");
        createThread.createLogsInThread(actualLogName);
    }

    static boolean isAppSessionValid(SSOToken token) {
        boolean isvalid = false;
        if (token == null) {
            return false;
        }
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken tok = token;
            isvalid = manager.isValidToken(tok);
        }
        catch (SSOException ssoex) {
            isvalid = false;
            logger.log(Level.SEVERE, "PSSR_CSPU042", ssoex);
        }
        catch (Exception ex) {
            isvalid = false;
            logger.log(Level.SEVERE, "PSSR_CSPU043", ex);
        }
        return isvalid;
    }

    public static synchronized void createAppSessionIfInvalid() {
        try {
            boolean survivedRefresh = false;
            try {
                SSOTokenManager manager = SSOTokenManager.getInstance();
                manager.refreshSession(appSession);
                survivedRefresh = true;
            }
            catch (Exception e) {
                logger.warning("PSSR_CSPU0431");
            }
            if (!survivedRefresh || !GWLogManager.isAppSessionValid(appSession)) {
                System.out.println("\n\n\nAppsession was invalid creating a new appSession...\n\n\n");
                logger.info("PSSR_CSPU044");
                GWLogManager.createNewAppSession();
                System.out.println("\n\n\nAppsession created sucessfully...\n\n\n");
                System.out.flush();
                logger.info("PSSR_CSPU045");
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSSR_CSPU046", ex);
        }
    }

    public static LogManager getLogManager() {
        return lm;
    }

    public static String getLogName() {
        return logName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        platformLogName = SystemProperties.get("gateway.logname");
        if (platformLogName != null && (platformLogName = platformLogName.trim().replace('-', '_')).length() == 0) {
            platformLogName = null;
        }
        GWLogManager.createNewAppSession(true);
        createThread = new LogCreateThread();
        Thread thr = new Thread(createThread);
        thr.start();
        remoteLogThread = new RemoteWriteLogThread();
        new Thread(remoteLogThread).start();
        logCreateInvoked = false;
    }
}

