/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.PlatformProfile;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.HostAvailabilityEvent;
import com.sun.portal.util.HostAvailabilityListener;
import com.sun.portal.util.ServersList;
import com.sun.portal.util.SystemProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationLoginHostChooser
extends HostAvailabilityListener {
    private URL currentHostInUse = null;
    private boolean isInitialised = false;
    private static final String bootupISUrl;
    private static Logger logger;
    private static ApplicationLoginHostChooser instance;
    static /* synthetic */ Class class$com$sun$portal$util$ApplicationLoginHostChooser;

    private ApplicationLoginHostChooser() {
        this.addHostAvailabilityListener(this);
    }

    private synchronized void setCurrentHostInUse(URL url) {
        this.currentHostInUse = url;
    }

    public static synchronized URL getAlivePlatFormServerURL() {
        String url = null;
        String igString = SystemProperties.get("gateway.ignoreServerList");
        if (igString != null && igString.equalsIgnoreCase("true")) {
            GWDebug.debug.message("ApplicationLoginHostChooser::getAlivePlatFormServerURL: ignoring ServerList, using " + bootupISUrl);
            url = bootupISUrl;
        } else {
            url = PlatformProfile.isInitialised() ? ServersList.getInstance().getServeraLive() : bootupISUrl;
        }
        URL retUrl = null;
        if (url != null) {
            try {
                retUrl = new URL(url);
                instance.setCurrentHostInUse(retUrl);
            }
            catch (MalformedURLException mfEx) {
                retUrl = null;
            }
        }
        return retUrl;
    }

    public void hostAvailabilityChanged(HostAvailabilityEvent hae) {
        boolean needRecreate = false;
        Object[] params = new Object[]{new Integer(hae.getHostStatus()), hae.getHost()};
        logger.log(Level.INFO, "PSSR_CSPU021", params);
        if (!this.isInitialised || this.currentHostInUse == null) {
            needRecreate = true;
        }
        if (hae.getHostType() == 1 && hae.getHostStatus() == 2) {
            try {
                URL tmpURL = new URL(hae.getHost());
                if (tmpURL.getHost().equalsIgnoreCase(this.currentHostInUse.getHost()) && tmpURL.getPort() == this.currentHostInUse.getPort()) {
                    needRecreate = true;
                }
            }
            catch (Exception ex) {
                needRecreate = true;
            }
        }
        Object[] params1 = new Object[]{hae.getHost(), new Boolean(needRecreate)};
        logger.log(Level.INFO, "PSSR_CSPU022", params1);
        if (needRecreate) {
            this.recreateLoginSession();
        }
    }

    private void recreateLoginSession() {
        GWLogManager.createNewAppSession();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$util$ApplicationLoginHostChooser == null ? (class$com$sun$portal$util$ApplicationLoginHostChooser = ApplicationLoginHostChooser.class$("com.sun.portal.util.ApplicationLoginHostChooser")) : class$com$sun$portal$util$ApplicationLoginHostChooser));
        String url = null;
        String protocol = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.server.protocol");
        String host = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.server.host");
        String port = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.server.port");
        try {
            URL _url = new URL(protocol, host, Integer.parseInt(port), "/");
            url = _url.toString();
        }
        catch (MalformedURLException mfEx) {
            logger.log(Level.SEVERE, "PSSR_CSPU017", mfEx);
            Object[] params = new Object[]{protocol, host, port};
            logger.log(Level.SEVERE, "PSSR_CSPU018", params);
        }
        catch (NumberFormatException nfEx) {
            logger.log(Level.SEVERE, "PSSR_CSPU019", nfEx);
            Object[] params = new Object[]{protocol, host, port};
            logger.log(Level.SEVERE, "PSSR_CSPU020", params);
        }
        bootupISUrl = url;
        instance = new ApplicationLoginHostChooser();
    }
}

