/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.identity.authentication.AuthContext;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.SRADecoderException;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.util.ApplicationLoginHostChooser;
import com.sun.portal.util.SystemProperties;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;

public class ApplicationLogin {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$util$ApplicationLogin == null ? (class$com$sun$portal$util$ApplicationLogin = ApplicationLogin.class$("com.sun.portal.util.ApplicationLogin")) : class$com$sun$portal$util$ApplicationLogin));
    static /* synthetic */ Class class$com$sun$portal$util$ApplicationLogin;

    static String login(String appName) {
        AuthContext authContext = null;
        try {
            String defOrg = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.defaultOrg");
            URL platformUrl = ApplicationLoginHostChooser.getAlivePlatFormServerURL();
            Object[] params0 = new Object[]{platformUrl};
            logger.log(Level.INFO, "PSSR_CSPU000", params0);
            Object[] params1 = new Object[]{defOrg};
            logger.log(Level.INFO, "PSSR_CSPU001", params1);
            if (platformUrl == null) {
                logger.info("PSSR_CSPU002");
                authContext = new AuthContext(defOrg);
            } else {
                logger.info("PSSR_CSPU003");
                authContext = new AuthContext(defOrg, platformUrl);
            }
            AuthContext.IndexType index = AuthContext.IndexType.SERVICE;
            authContext.login(index, "srapGatewayAccessService".toLowerCase());
            Callback[] callback = null;
            while (authContext.hasMoreRequirements()) {
                callback = authContext.getRequirements();
                Object[] params4 = new Object[]{callback};
                logger.log(Level.INFO, "PSSR_CSPU004", params4);
                if (callback == null) continue;
                ApplicationLogin.processCallBack(callback);
                logger.info("PSSR_CSPU005");
                authContext.submitRequirements(callback);
                Object[] params = new Object[]{new Boolean(authContext.hasMoreRequirements())};
                logger.log(Level.INFO, "PSSR_CSPU006", params);
            }
        }
        catch (LoginException ex) {
            logger.log(Level.SEVERE, "PSSR_CSPU007", ex);
            return null;
        }
        Object[] params8 = new Object[]{authContext};
        logger.log(Level.INFO, "PSSR_CSPU008", params8);
        try {
            if (authContext.getStatus() == AuthContext.Status.SUCCESS) {
                String appSess = authContext.getSSOToken().getTokenID().toString();
                Object[] params9 = new Object[]{appSess};
                logger.log(Level.INFO, "PSSR_CSPU009", params9);
                return appSess;
            }
            Object[] params = new Object[]{authContext.getStatus()};
            logger.log(Level.INFO, "PSSR_CSPU010", params);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSSR_CSPU011", ex);
        }
        return null;
    }

    private static void processCallBack(Callback[] callback) {
        for (int count = 0; count < callback.length; ++count) {
            if (callback[count] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback[count];
                String userName = SystemProperties.get("gateway.logging.user.id", "amService-srapGateway");
                nc.setName(userName);
                continue;
            }
            if (!(callback[count] instanceof PasswordCallback)) continue;
            PasswordCallback pc = (PasswordCallback)callback[count];
            String password = SystemProperties.get("gateway.logging.password", "TEST");
            try {
                password = JSSUtil.decryptPassword((String)password).getPassword();
            }
            catch (SRADecoderException syEx) {
                // empty catch block
            }
            char[] chars = new char[password.length()];
            password.getChars(0, chars.length, chars, 0);
            pc.setPassword(chars);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

