/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.server;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.util.GWNSSInit;
import com.sun.portal.util.SRAEvent;
import com.sun.portal.util.SRAPServerSocket;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;

public class ServerSocketFactory {
    private static final String HTTPPROXY_PORT = "HTTPProxyPort";
    private static final int HTTPPROXY_DEFAULT_PORT = 10443;
    private static boolean allow40bitBrowser;
    private static boolean enableSSLV2;
    private static boolean enableSSLV3;
    private static boolean disableNullCiphers;
    private static boolean individualCipherSelectionMode;
    private static List enabledSSL2CipherList;
    private static List enabledSSL3CipherList;
    private static List enabledTLSCipherList;
    private static Logger logger;
    static /* synthetic */ Class class$com$sun$portal$rproxy$server$ServerSocketFactory;

    private ServerSocketFactory() {
    }

    public static ServerSocket createNormalServerSocket(int port) {
        try {
            String address = SystemProperties.get("gateway.bindipaddress");
            ServerSocket serverSocket = null;
            serverSocket = address == null ? new ServerSocket(port) : new ServerSocket(port, 50, InetAddress.getByName(address));
            MonitoringSubsystem.handleEvent(SRAEvent.SERVER_SOCKET_CREATED);
            return serverSocket;
        }
        catch (IOException ex) {
            Object[] params0 = new Object[]{port + "", ex};
            logger.log(Level.SEVERE, "PSSRRPROXY_CSPRS001", params0);
            return null;
        }
    }

    public static ServerSocket createSSLSocketServer(int port) throws SocketException {
        boolean doingPDC;
        SSLServerSocket.configServerSessionIDCache((int)15000, (int)86400, (int)86400, null);
        ServerSocketFactory.certificationAdministration();
        SSLServerSocket sock = null;
        int qlen = GatewayProfile.getInt("EProxyConnectionQueue", 50);
        String _address = SystemProperties.get("gateway.bindipaddress");
        try {
            if (_address == null) {
                _address = "127.0.0.1";
            }
            sock = new SSLServerSocket(port, qlen, InetAddress.getByName(_address));
            logger.info("ServerSocketFactory:createSSLSocketServer  nickname = " + GWNSSInit.nickname);
            sock.setServerCertNickname(GWNSSInit.nickname);
            MonitoringSubsystem.handleEvent(SRAEvent.SERVER_SOCKET_CREATED);
        }
        catch (UnknownHostException ue) {
            logger.log(Level.SEVERE, "PSSRRPROXY_CSPRS005");
            sock = null;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "PSSRRPROXY_CSPRS006");
            sock = null;
        }
        String rphost = SystemProperties.get("gateway.host", null);
        List certSet = ServerSocketFactory.toLowerCase(GatewayProfile.getStringList("CertificateEnabledList"));
        boolean bl = doingPDC = certSet.contains(rphost.toLowerCase()) && ServiceIdentifier.isGateway();
        if (doingPDC) {
            logger.info("PSSRRPROXY_CSPRS007");
            try {
                sock.requestClientAuth(true);
            }
            catch (SocketException se) {
                logger.severe("PSSRRPROXY_CSPRS008");
            }
        }
        return sock;
    }

    private static void certificationAdministration() throws SocketException {
        if (individualCipherSelectionMode) {
            GWNSSInit.disableAllCiphers();
            ServerSocketFactory.enableCipherList(enabledSSL2CipherList);
            ServerSocketFactory.enableCipherList(enabledSSL3CipherList);
            ServerSocketFactory.enableCipherList(enabledTLSCipherList);
        } else {
            if (!enableSSLV2) {
                GWNSSInit.disableCipher(GWNSSInit.cipherSuites128BitSSL2);
            }
            if (!enableSSLV3) {
                GWNSSInit.disableCipher(GWNSSInit.cipherSuites128BitSSL3);
            }
            if (disableNullCiphers || !allow40bitBrowser) {
                GWNSSInit.disableCipher(GWNSSInit.cipherSuitesSSL3Null);
            }
            if (!allow40bitBrowser) {
                GWNSSInit.disableCipher(GWNSSInit.cipherSuites40BitSSL2);
                GWNSSInit.disableCipher(GWNSSInit.cipherSuites40BitSSL3);
                GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersSSL2);
                GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersSSL3);
                GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersTLS);
            } else {
                if (!enableSSLV2) {
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuites40BitSSL2);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersSSL2);
                }
                if (!enableSSLV3) {
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuites40BitSSL3);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersSSL3);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesSSL3Null);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersTLS);
                }
            }
        }
    }

    private static void enableCipherList(List list) throws SocketException {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ServerSocketFactory.enableCipher((String)list.get(i));
        }
    }

    private static void enableCipher(String cipher) throws SocketException {
        if (!enableSSLV2 && cipher.toLowerCase().indexOf("ssl2") != -1) {
            return;
        }
        if (!enableSSLV3 && cipher.toLowerCase().indexOf("ssl3") != -1) {
            return;
        }
        if (!enableSSLV3 && cipher.toLowerCase().indexOf("ssl_rsa_fips") != -1) {
            return;
        }
        if (disableNullCiphers && cipher.toLowerCase().indexOf("null") != -1) {
            return;
        }
        cipher = cipher.trim();
        if (!allow40bitBrowser && (cipher.equalsIgnoreCase("SSL2_RC2_128_CBC_EXPORT40_WITH_MD5") || cipher.equalsIgnoreCase("SSL2_RC4_128_EXPORT40_WITH_MD5") || cipher.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC4_40_MD5") || cipher.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC2_CBC_40_MD5") || cipher.equalsIgnoreCase("SSL2_DES_64_CBC_WITH_MD5") || cipher.equalsIgnoreCase("SSL3_RSA_WITH_DES_CBC_SHA") || cipher.equalsIgnoreCase("SSL3_RSA_WITH_NULL_MD5") || cipher.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA") || cipher.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_RC4_56_SHA") || cipher.equalsIgnoreCase("SSL_RSA_FIPS_WITH_DES_CBC_SHA"))) {
            return;
        }
        if (cipher.equalsIgnoreCase("SSL2_RC2_128_CBC_WITH_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)65283, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL2_DES_192_EDE3_CBC_WITH_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)65287, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL2_RC4_128_WITH_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)65281, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_WITH_3DES_EDE_CBC_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)10, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_WITH_RC4_128_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)4, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_WITH_RC4_128_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)5, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)65279, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL2_RC2_128_CBC_EXPORT40_WITH_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)65284, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL2_RC4_128_EXPORT40_WITH_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)65282, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC4_40_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)3, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC2_CBC_40_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)6, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL2_DES_64_CBC_WITH_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)65286, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_WITH_DES_CBC_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)9, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_WITH_NULL_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)1, (boolean)true);
        } else if (cipher.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)98, (boolean)true);
        } else if (cipher.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_RC4_56_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)100, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL_RSA_FIPS_WITH_DES_CBC_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)65278, (boolean)true);
        }
    }

    private static List toLowerCase(List list) {
        int size = list.size();
        ArrayList<String> ret = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            String host = (String)list.get(i);
            ret.add(host.toLowerCase());
        }
        return ret;
    }

    public static ServerSocket createSRAPServerSocket(int port) {
        int qlen = GatewayProfile.getInt("EProxyConnectionQueue", 50);
        String _address = SystemProperties.get("gateway.bindipaddress");
        if (_address == null) {
            _address = "127.0.0.1";
        }
        try {
            SRAPServerSocket socket = new SRAPServerSocket(port, qlen, InetAddress.getByName(_address));
            MonitoringSubsystem.handleEvent(SRAEvent.SERVER_SOCKET_CREATED);
            return socket;
        }
        catch (IOException e) {
            Object[] params8 = new Object[]{port + "", e};
            logger.log(Level.SEVERE, "PSSRRPROXY_CSPRS009", params8);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        enableSSLV2 = true;
        enableSSLV3 = true;
        disableNullCiphers = false;
        enabledSSL2CipherList = null;
        enabledSSL3CipherList = null;
        enabledTLSCipherList = null;
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$rproxy$server$ServerSocketFactory == null ? (class$com$sun$portal$rproxy$server$ServerSocketFactory = ServerSocketFactory.class$("com.sun.portal.rproxy.server.ServerSocketFactory")) : class$com$sun$portal$rproxy$server$ServerSocketFactory));
        String tmpstr = GatewayProfile.getString("Allow40BitConnections", "true");
        allow40bitBrowser = tmpstr.equals("true");
        tmpstr = GatewayProfile.getString("EnableSSLv2", "true");
        enableSSLV2 = tmpstr.equals("true");
        tmpstr = GatewayProfile.getString("EnableSSLv3", "true");
        enableSSLV3 = tmpstr.equals("true");
        tmpstr = GatewayProfile.getString("DisableNull", "false");
        disableNullCiphers = tmpstr.equals("true");
        tmpstr = GatewayProfile.getString("EnableIndividualCipherSelectionMode", "false");
        individualCipherSelectionMode = tmpstr.equals("true");
        if (individualCipherSelectionMode) {
            enabledSSL2CipherList = GatewayProfile.getStringList("EnabledSSL2CipherList");
            enabledSSL3CipherList = GatewayProfile.getStringList("EnabledSSL3CipherList");
            enabledTLSCipherList = GatewayProfile.getStringList("EnabledTLSCipherList");
        }
    }
}

