/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.util.http;

import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.uri.PageSpec;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.rproxy.monitoring.util.RProxyEvent;
import com.sun.portal.rproxy.rewriter.util.http.ChunkedContent;
import com.sun.portal.rproxy.rewriter.util.http.ContentInfo;
import com.sun.portal.rproxy.rewriter.util.http.MIMEAndEncodingParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class HTTPData {
    private static final String CONTENT_LENGTH_PATTERN = "Content-length";
    private final Response response;
    private final PageSpec pageSpec;
    private final ContentInfo contentInfo;
    private byte[] contentBytes;
    private String rawEncodedString;
    private String rawEncodedStringLowerCase;
    private String pageContent;

    public HTTPData(PageSpec aPageSpec, Response aResponse) throws IOException {
        this.response = aResponse;
        this.pageSpec = aPageSpec;
        this.contentInfo = new ContentInfo();
        MIMEAndEncodingParser.parse(this);
    }

    public String getContentType() {
        return this.response.getContentType();
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public boolean isStreamRead() {
        return this.contentBytes != null;
    }

    public byte[] getContentBytes() throws IOException {
        if (this.contentBytes == null) {
            this.contentBytes = HTTPData.readFullContent(this.response);
            MonitoringSubsystem.handleEvent(RProxyEvent.RESP_READ, new Long(this.contentBytes.length));
        }
        return this.contentBytes;
    }

    public String getRawEncodedString() throws IOException {
        if (this.rawEncodedString == null && this.getContentBytes() != null) {
            this.rawEncodedString = new String(this.getContentBytes());
        }
        return this.rawEncodedString;
    }

    public String getRawEncodedStringLowerCase() throws IOException {
        if (this.rawEncodedStringLowerCase == null) {
            this.rawEncodedStringLowerCase = this.getRawEncodedString().toLowerCase();
        }
        return this.rawEncodedStringLowerCase;
    }

    public PageSpec getPageSpec() {
        return this.pageSpec;
    }

    public String getPageContent() throws IOException {
        String lEncoding = this.contentInfo.getEncoding();
        if (lEncoding == null || lEncoding == Constants.SYSTEM_ENCODING) {
            this.contentInfo.setEncoding(Constants.SYSTEM_ENCODING);
            return this.getRawEncodedString();
        }
        if (this.pageContent == null && this.getContentBytes() != null) {
            this.pageContent = new String(this.getContentBytes(), this.contentInfo.getEncoding());
        }
        return this.pageContent;
    }

    private static byte[] readFullContent(Response resp) throws IOException {
        int numbytes;
        int idx;
        HTTPResponse lHTTPResponse;
        String te;
        String lContentLength = resp.getResponseHeader(CONTENT_LENGTH_PATTERN);
        BufferedInputStream buffIn = resp.getContentStream();
        if (resp instanceof HTTPResponse && (te = (lHTTPResponse = (HTTPResponse)resp).getResponseHeader("Transfer-Encoding")) != null && te.substring((idx = te.indexOf(58)) + 1).trim().equalsIgnoreCase("chunked")) {
            byte[] contentBuf = ChunkedContent.readChunkedContent(buffIn);
            lHTTPResponse.removeHeader("Transfer-Encoding");
            return contentBuf;
        }
        if (buffIn == null) {
            return null;
        }
        if (lContentLength != null) {
            int length = Integer.parseInt(lContentLength.substring(lContentLength.indexOf(58) + 1).trim());
            byte[] byteContent = new byte[length];
            int read = 0;
            for (int totalRead = 0; totalRead < length && (read = buffIn.read(byteContent, totalRead, length - totalRead)) != -1; totalRead += read) {
            }
            return byteContent;
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        byte[] content = new byte[2048];
        while ((numbytes = buffIn.read(content)) != -1) {
            bOut.write(content, 0, numbytes);
        }
        return bOut.toByteArray();
    }
}

