/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.monitoring;

import com.sun.portal.monitoring.Subsystem;
import com.sun.portal.monitoring.statistics.CountStatisticImpl;
import com.sun.portal.monitoring.statistics.RangeStatisticImpl;
import com.sun.portal.monitoring.statistics.RollingAvgTimeStatisticImpl;
import com.sun.portal.monitoring.statistics.StatisticImpl;
import com.sun.portal.monitoring.statistics.StatisticWrapper;
import com.sun.portal.monitoring.utilities.ActivityTime;
import com.sun.portal.rproxy.configservlet.client.UserProfileGatewayCache;
import com.sun.portal.rproxy.monitoring.RProxyStatisticBase;
import com.sun.portal.rproxy.monitoring.util.RProxyEvent;
import com.sun.portal.util.SRAEvent;

public class UserProfileCacheStatistic
extends RProxyStatisticBase {
    public static final String CACHE_UTILIZATION = "CacheUtilization";
    public static final String CACHE_HIT_RATE = "CacheHitRate";
    public static final String CACHE_RESPONSE_TIME = "ResponseTime";
    private static RangeStatisticImpl cacheUtilization = new RangeStatisticImpl(){

        public long getLowWaterMark() {
            return 0L;
        }

        public long getHighWaterMark() {
            return UserProfileGatewayCache.getMaxCacheSize();
        }

        public long getCurrent() {
            return UserProfileGatewayCache.getNumCacheEntries();
        }
    };
    private static HitRate hitrate = new HitRate();
    private static RollingAvgTimeStatisticImpl respTime = new RollingAvgTimeStatisticImpl();
    private static ActivityTime activityTime = new ActivityTime();

    public UserProfileCacheStatistic(Subsystem subsystem) {
        super(subsystem);
    }

    protected String getMbeanType() {
        return "UserProfile";
    }

    protected String[] getMBeanNames() {
        return new String[]{CACHE_UTILIZATION, CACHE_HIT_RATE, CACHE_RESPONSE_TIME};
    }

    protected StatisticImpl[] getStatistics() {
        return new StatisticImpl[]{cacheUtilization, hitrate, respTime};
    }

    protected StatisticWrapper getStatistic(String name) {
        if (CACHE_UTILIZATION.equals(name)) {
            return this.getRangeStatistic(name);
        }
        if (CACHE_HIT_RATE.equals(name)) {
            return this.getCountStatistic(name);
        }
        if (CACHE_RESPONSE_TIME.equals(name)) {
            return this.getRAStatistic(name);
        }
        throw new RuntimeException("No statistic : " + name);
    }

    public void markFetchStart() {
        activityTime.mark();
    }

    public void markFetchEnd() {
        respTime.setTime(activityTime.measure());
    }

    public void handleEvent(SRAEvent event, Object obj) {
        if (event == RProxyEvent.GET_USER_PROFILE_START) {
            this.markFetchStart();
        } else if (event == RProxyEvent.GET_USER_PROFILE_END) {
            this.markFetchEnd();
        }
    }

    public SRAEvent[] getInterestedEvents() {
        return new SRAEvent[]{RProxyEvent.GET_USER_PROFILE_START, RProxyEvent.GET_USER_PROFILE_END};
    }

    private static class HitRate
    extends CountStatisticImpl {
        private HitRate() {
        }

        public long getCount() {
            return UserProfileGatewayCache.getCacheHitRate();
        }
    }
}

