/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.monitoring;

import com.sun.portal.monitoring.Subsystem;
import com.sun.portal.monitoring.statistics.CountStatisticImpl;
import com.sun.portal.monitoring.statistics.StatisticImpl;
import com.sun.portal.monitoring.statistics.StatisticWrapper;
import com.sun.portal.rproxy.monitoring.RProxyStatisticBase;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.SRAEvent;

public class ThreadPoolStatistic
extends RProxyStatisticBase {
    public static final String TASKS_IN_QUEUE = "TasksInQueue";
    public static final String THREAD_POOL_SIZE = "Size";
    public static final String ACTIVE_TASKS = "ActiveTasks";
    private static CountStatisticSupport tasksInQueue = new CountStatisticSupport("TasksInQueue");
    private static CountStatisticSupport threadPoolSize = new CountStatisticSupport("Size");
    private static CountStatisticSupport activeTasks = new CountStatisticSupport("ActiveTasks");

    protected StatisticWrapper getStatistic(String name) {
        return this.getCountStatistic(name);
    }

    public ThreadPoolStatistic(Subsystem subsystem) {
        super(subsystem);
    }

    protected String getMbeanType() {
        return "ThreadPool";
    }

    protected String[] getMBeanNames() {
        return new String[]{TASKS_IN_QUEUE, ACTIVE_TASKS, THREAD_POOL_SIZE};
    }

    protected StatisticImpl[] getStatistics() {
        return new StatisticImpl[]{tasksInQueue, activeTasks, threadPoolSize};
    }

    public void handleEvent(SRAEvent event, Object obj) {
    }

    public SRAEvent[] getInterestedEvents() {
        return new SRAEvent[]{SRAEvent.DUMMY_EVENT};
    }

    private static class CountStatisticSupport
    extends CountStatisticImpl {
        String type;

        public CountStatisticSupport(String type) {
            this.type = type;
        }

        public long getCount() {
            if (ThreadPoolStatistic.TASKS_IN_QUEUE == this.type) {
                return GWThreadPool.getRequestsInQue();
            }
            if (ThreadPoolStatistic.ACTIVE_TASKS == this.type) {
                return GWThreadPool.getActiveThreads();
            }
            if (ThreadPoolStatistic.THREAD_POOL_SIZE == this.type) {
                return GWThreadPool.getSize();
            }
            throw new IllegalArgumentException("Not supported attribute : " + this.type);
        }
    }
}

