/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.monitoring;

import com.sun.portal.monitoring.Subsystem;
import com.sun.portal.monitoring.statistics.OpenStatistic;
import com.sun.portal.monitoring.statistics.StatisticWrapper;
import com.sun.portal.rproxy.monitoring.statistics.ThreadActivityStatisticImpl;
import com.sun.portal.rproxy.monitoring.statistics.ThreadActivityStatisticWrapper;
import com.sun.portal.rproxy.monitoring.util.RProxyEvent;
import com.sun.portal.util.SRAEvent;
import com.sun.portal.util.SRAEventListener;
import com.sun.portal.util.ThreadMonitorContext;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ThreadActivityStatistic
implements SRAEventListener {
    Subsystem subsystem;
    private static Object OPEN_STAT_KEY = new Object();

    public ThreadActivityStatistic(Subsystem subSystem) {
        this.subsystem = subSystem;
    }

    public void taskStarts(ThreadMonitorContext threadContext) {
        OpenStatistic openStat = (OpenStatistic)ThreadMonitorContext.retrieveAttribute(OPEN_STAT_KEY);
        if (openStat == null) {
            ThreadActivityStatisticWrapper tasw = new ThreadActivityStatisticWrapper();
            tasw.setCompositeTypeName(this.getClass().getName() + threadContext.getThread().getName());
            ThreadActivityStatisticImpl tasi = new ThreadActivityStatisticImpl(threadContext);
            tasi.setObjectName(this.getObjectName(threadContext.getThread().getName()));
            tasw.setStatisticImpl(tasi);
            openStat = new OpenStatistic((StatisticWrapper)tasw);
            ThreadMonitorContext.storeAttribute(OPEN_STAT_KEY, openStat);
        }
        this.registerMBean(openStat);
    }

    private ObjectName getObjectName(String threadName) {
        try {
            return new ObjectName(this.subsystem.getNamingDomain() + ":type=ThreadActivity,ThreadName=" + threadName);
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    private void registerMBean(OpenStatistic openStat) {
        ThreadActivityStatisticImpl tasi = (ThreadActivityStatisticImpl)openStat.getStatisticWrapper().getStatisticImpl();
        tasi.setDestination(null);
        try {
            this.subsystem.registerMBean((Object)openStat, tasi.getObjectName().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void taskEnds(ThreadMonitorContext threadMonitorContext) {
        OpenStatistic openStat = (OpenStatistic)ThreadMonitorContext.retrieveAttribute(OPEN_STAT_KEY);
        if (openStat != null) {
            try {
                ThreadActivityStatisticImpl tasi = (ThreadActivityStatisticImpl)openStat.getStatisticWrapper().getStatisticImpl();
                this.subsystem.unregisterMBean(tasi.getObjectName().toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public SRAEvent[] getInterestedEvents() {
        return new SRAEvent[]{SRAEvent.END_TASK, SRAEvent.START_TASK, RProxyEvent.IDENTIFY_DESTINATION};
    }

    public void handleEvent(SRAEvent event, Object obj) {
        if (event == SRAEvent.START_TASK) {
            this.taskStarts((ThreadMonitorContext)obj);
            return;
        }
        if (event == SRAEvent.END_TASK) {
            this.taskEnds((ThreadMonitorContext)obj);
            return;
        }
        if (event == RProxyEvent.IDENTIFY_DESTINATION) {
            OpenStatistic openStat = (OpenStatistic)ThreadMonitorContext.retrieveAttribute(OPEN_STAT_KEY);
            if (openStat == null) {
                return;
            }
            ThreadActivityStatisticImpl tasi = (ThreadActivityStatisticImpl)openStat.getStatisticWrapper().getStatisticImpl();
            tasi.setDestination((String)obj);
            return;
        }
    }
}

