/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.monitoring;

import com.sun.portal.monitoring.Subsystem;
import com.sun.portal.monitoring.statistics.StatisticImpl;
import com.sun.portal.monitoring.statistics.StatisticWrapper;
import com.sun.portal.rproxy.monitoring.RProxyStatisticBase;
import com.sun.portal.rproxy.monitoring.statistics.CountStatisticSupport;
import com.sun.portal.util.SRAEvent;

public class SocketsStatistic
extends RProxyStatisticBase {
    public static final String ACTIVE_SERVER_SOCKETS = "ActiveServerSockets";
    public static final String ACTIVE_PLAIN_SOCKETS = "ActivePlainSockets";
    public static final String ACTIVE_SECURE_SOCKETS = "ActiveSecureSockets";
    private static CountStatisticSupport activeServerSockets = new CountStatisticSupport();
    private static CountStatisticSupport activePlainSockets = new CountStatisticSupport();
    private static CountStatisticSupport activeSecureSockets = new CountStatisticSupport();

    public SocketsStatistic(Subsystem subsystem) {
        super(subsystem);
    }

    protected String getMbeanType() {
        return "";
    }

    protected String[] getMBeanNames() {
        return new String[]{ACTIVE_SERVER_SOCKETS, ACTIVE_PLAIN_SOCKETS, ACTIVE_SECURE_SOCKETS};
    }

    protected StatisticImpl[] getStatistics() {
        return new StatisticImpl[]{activeServerSockets, activePlainSockets, activeSecureSockets};
    }

    protected StatisticWrapper getStatistic(String name) {
        return this.getCountStatistic(name);
    }

    public void handleEvent(SRAEvent event, Object obj) {
        if (event == SRAEvent.PLAIN_SOCKET_CREATED) {
            activePlainSockets.increment();
            return;
        }
        if (event == SRAEvent.PLAIN_SOCKET_DESTROYED) {
            activePlainSockets.decrement();
            return;
        }
        if (event == SRAEvent.SSL_SOCKET_CREATED) {
            activeSecureSockets.increment();
            return;
        }
        if (event == SRAEvent.SSL_SOCKET_DESTROYED) {
            activeSecureSockets.decrement();
            return;
        }
        if (event == SRAEvent.SERVER_SOCKET_CREATED) {
            activeServerSockets.increment();
            return;
        }
        if (event == SRAEvent.SERVER_SOCKET_DESTROYED) {
            activeServerSockets.decrement();
        }
    }

    public SRAEvent[] getInterestedEvents() {
        return new SRAEvent[]{SRAEvent.PLAIN_SOCKET_CREATED, SRAEvent.PLAIN_SOCKET_DESTROYED, SRAEvent.SERVER_SOCKET_CREATED, SRAEvent.SERVER_SOCKET_DESTROYED, SRAEvent.SSL_SOCKET_CREATED, SRAEvent.SSL_SOCKET_DESTROYED};
    }
}

