/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.monitoring;

import com.sun.portal.monitoring.MonitoringException;
import com.sun.portal.monitoring.Subsystem;
import com.sun.portal.monitoring.statistics.CountStatisticWrapper;
import com.sun.portal.monitoring.statistics.OpenStatistic;
import com.sun.portal.monitoring.statistics.RangeStatisticWrapper;
import com.sun.portal.monitoring.statistics.RollingAvgTimeStatisticWrapper;
import com.sun.portal.monitoring.statistics.StatisticImpl;
import com.sun.portal.monitoring.statistics.StatisticWrapper;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.util.SRAEventListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public abstract class RProxyStatisticBase
implements SRAEventListener {
    protected Subsystem subsystem;
    protected Map objNameVsStatistic = new HashMap();
    static ThreadLocal threadLocal = new ThreadLocal();

    protected RollingAvgTimeStatisticWrapper getRAStatistic(String attributeName) {
        RollingAvgTimeStatisticWrapper ratsw = new RollingAvgTimeStatisticWrapper();
        ratsw.setCompositeTypeName(this.getClass().getName() + attributeName);
        ratsw.setResourceBundleBaseName(this.getMbeanType() + "Statistic");
        return ratsw;
    }

    protected RProxyStatisticBase(Subsystem subsystem) {
        this.subsystem = subsystem;
    }

    protected ObjectName getObjectName(String attributeName) throws MalformedObjectNameException {
        return new ObjectName(this.subsystem.getNamingDomain() + ":type=" + this.getMbeanType() + attributeName);
    }

    protected abstract String getMbeanType();

    protected CountStatisticWrapper getCountStatistic(String attributeName) {
        CountStatisticWrapper csw = new CountStatisticWrapper();
        csw.setCompositeTypeName(this.getClass().getName() + attributeName);
        csw.setResourceBundleBaseName(this.getMbeanType());
        return csw;
    }

    protected RangeStatisticWrapper getRangeStatistic(String attributeName) {
        RangeStatisticWrapper rsw = new RangeStatisticWrapper();
        rsw.setCompositeTypeName(this.getClass().getName() + attributeName);
        rsw.setResourceBundleBaseName(this.getMbeanType());
        return rsw;
    }

    protected void createMBean(String name, StatisticImpl statistic) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MonitoringException, MalformedObjectNameException {
        StatisticWrapper statisticWrapper = this.getStatistic(name);
        statisticWrapper.setStatisticImpl(statistic);
        statistic.reset();
        ObjectName objName = this.getObjectName(name);
        this.subsystem.registerMBean((Object)new OpenStatistic(statisticWrapper), objName.toString());
        this.subsystem.setImmortalMBeanObjectNames(Arrays.asList(objName));
    }

    protected abstract String[] getMBeanNames();

    protected abstract StatisticImpl[] getStatistics();

    protected abstract StatisticWrapper getStatistic(String var1);

    public RProxyStatisticBase initMBeans() throws MonitoringException, MalformedObjectNameException, NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        String[] mbeanNames = this.getMBeanNames();
        StatisticImpl[] statistics = this.getStatistics();
        for (int i = 0; i < mbeanNames.length; ++i) {
            this.createMBean(mbeanNames[i], statistics[i]);
        }
        return this;
    }

    public static boolean isMonitoringDisabled() {
        return MonitoringSubsystem.isMonitoringDisabled();
    }

    public static class RProxyResponseInfo {
        public static final int IS_NOTIFICATION_TYPE = 1;
        public long responseFetchStartTime = -1L;
        public long responseFetchEndTime = -1L;
        public long taskCreationTime = -1L;
        public int requestType = 0;
    }
}

