/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.monitoring;

import com.sun.portal.monitoring.Subsystem;
import com.sun.portal.monitoring.statistics.RollingAvgTimeStatisticImpl;
import com.sun.portal.monitoring.statistics.StatisticImpl;
import com.sun.portal.monitoring.statistics.StatisticWrapper;
import com.sun.portal.rproxy.monitoring.ISNotificationsStatistic;
import com.sun.portal.rproxy.monitoring.RProxyStatisticBase;
import com.sun.portal.rproxy.monitoring.util.RProxyEvent;
import com.sun.portal.util.SRAEvent;
import com.sun.portal.util.TaskWrapper;
import com.sun.portal.util.ThreadMonitorContext;

public class RProxyResponseTimeStatistic
extends RProxyStatisticBase {
    public static final String RESP_TIME = "ResponseTime";
    public static final String PREPROCESS_TIME = "PreProcessTime";
    public static final String POST_PROCESS_TIME = "PostProcessTime";
    public static final String QUEUE_WAIT_TIME = "queueWaitTime";
    private RollingAvgTimeStatisticImpl responseTime = new RollingAvgTimeStatisticImpl();
    private RollingAvgTimeStatisticImpl preProcessTime = new RollingAvgTimeStatisticImpl();
    private RollingAvgTimeStatisticImpl postProcessTime = new RollingAvgTimeStatisticImpl();
    private RollingAvgTimeStatisticImpl queueTime = new RollingAvgTimeStatisticImpl();

    public RProxyResponseTimeStatistic(Subsystem subsystem) {
        super(subsystem);
    }

    public void updatePreprocessTime() {
        Runnable task = ThreadMonitorContext.getContext().getTask();
        if (task instanceof TaskWrapper) {
            TaskWrapper taskWrapper = (TaskWrapper)task;
            long currTime = System.currentTimeMillis();
            RProxyStatisticBase.RProxyResponseInfo info = new RProxyStatisticBase.RProxyResponseInfo();
            info.taskCreationTime = taskWrapper.getTaskCreationTime();
            info.responseFetchStartTime = currTime;
            threadLocal.set(info);
            this.preProcessTime.setTime(currTime - info.taskCreationTime - taskWrapper.getQueueTime());
            this.queueTime.setTime(taskWrapper.getQueueTime());
        }
    }

    public void updatePostprocessTime() {
        RProxyStatisticBase.RProxyResponseInfo info = (RProxyStatisticBase.RProxyResponseInfo)threadLocal.get();
        if (info != null) {
            long currTime = System.currentTimeMillis();
            this.postProcessTime.setTime(System.currentTimeMillis() - info.responseFetchEndTime);
            if (info.requestType == 1) {
                ISNotificationsStatistic.getNotificationTime().setTime(currTime - info.taskCreationTime);
            } else {
                this.responseTime.setTime(currTime - info.taskCreationTime);
            }
        }
    }

    protected String getMbeanType() {
        return "RProxy";
    }

    protected String[] getMBeanNames() {
        return new String[]{RESP_TIME, PREPROCESS_TIME, POST_PROCESS_TIME, QUEUE_WAIT_TIME};
    }

    protected StatisticImpl[] getStatistics() {
        return new StatisticImpl[]{this.responseTime, this.preProcessTime, this.postProcessTime, this.queueTime};
    }

    protected StatisticWrapper getStatistic(String name) {
        return this.getRAStatistic(name);
    }

    public void responseRecevied() {
        RProxyStatisticBase.RProxyResponseInfo info = (RProxyStatisticBase.RProxyResponseInfo)threadLocal.get();
        if (info != null) {
            info.responseFetchEndTime = System.currentTimeMillis();
        }
    }

    public void handleEvent(SRAEvent event, Object obj) {
        if (event == RProxyEvent.TASK_ENDS) {
            this.updatePostprocessTime();
        } else if (event == RProxyEvent.REQUEST_SENT) {
            this.updatePreprocessTime();
        } else if (event == RProxyEvent.RESPONSE_RECVD) {
            this.responseRecevied();
        }
    }

    public SRAEvent[] getInterestedEvents() {
        return new SRAEvent[]{RProxyEvent.TASK_ENDS, RProxyEvent.REQUEST_SENT, RProxyEvent.RESPONSE_RECVD};
    }
}

