/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.monitoring;

import com.sun.portal.monitoring.Subsystem;
import com.sun.portal.monitoring.statistics.StatisticImpl;
import com.sun.portal.monitoring.statistics.StatisticWrapper;
import com.sun.portal.rproxy.monitoring.RProxyStatisticBase;
import com.sun.portal.rproxy.monitoring.statistics.CountStatisticSupport;
import com.sun.portal.rproxy.monitoring.util.RProxyEvent;
import com.sun.portal.util.SRAEvent;

public class RProxyRequestsStatistic
extends RProxyStatisticBase {
    public static final String LOGIN_REDIRECTS = "LoginRedirects";
    public static final String PDC_AUTH_REQ = "PDCAuthenticationRequests";
    public static final String SERVER_ERR = "ServerErrors";
    public static final String TOTAL_REQ = "TotalRequests";
    public static final String TOTAL_RESP = "TotalResponses";
    public static final String TOTAL_EXTERNAL_URL_REQS = "TotalExternalURLRequests";
    private static CountStatisticSupport loginRedirect = new CountStatisticSupport();
    private static CountStatisticSupport pdcAuthReq = new CountStatisticSupport();
    private static CountStatisticSupport serverError = new CountStatisticSupport();
    private static CountStatisticSupport totalReq = new CountStatisticSupport();
    private static CountStatisticSupport totalResp = new CountStatisticSupport();
    private static CountStatisticSupport totalExternalUrlReq = new CountStatisticSupport();

    public RProxyRequestsStatistic(Subsystem subsystem) {
        super(subsystem);
    }

    protected String getMbeanType() {
        return "RProxy";
    }

    protected String[] getMBeanNames() {
        return new String[]{LOGIN_REDIRECTS, PDC_AUTH_REQ, SERVER_ERR, TOTAL_REQ, TOTAL_EXTERNAL_URL_REQS, TOTAL_RESP};
    }

    protected StatisticImpl[] getStatistics() {
        return new StatisticImpl[]{loginRedirect, pdcAuthReq, serverError, totalReq, totalExternalUrlReq, totalResp};
    }

    protected StatisticWrapper getStatistic(String name) {
        return this.getCountStatistic(name);
    }

    public void handleEvent(SRAEvent event, Object obj) {
        if (event == RProxyEvent.EXTERNAL_URL_REQ) {
            totalExternalUrlReq.increment();
            return;
        }
        if (event == RProxyEvent.SERVER_ERROR) {
            serverError.increment();
            return;
        }
        if (event == RProxyEvent.PDC_AUTH_REQ) {
            pdcAuthReq.increment();
            return;
        }
        if (event == RProxyEvent.LOGIN_REDIRECT) {
            loginRedirect.increment();
            return;
        }
        if (event == RProxyEvent.NEW_REQ) {
            totalReq.increment();
            return;
        }
        if (event == RProxyEvent.RESPONSE_SENT) {
            totalResp.increment();
        }
    }

    public SRAEvent[] getInterestedEvents() {
        return new SRAEvent[]{RProxyEvent.EXTERNAL_URL_REQ, RProxyEvent.SERVER_ERROR, RProxyEvent.PDC_AUTH_REQ, RProxyEvent.LOGIN_REDIRECT, RProxyEvent.NEW_REQ, RProxyEvent.RESPONSE_SENT};
    }
}

