/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.monitoring;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.monitoring.ConnectorContext;
import com.sun.portal.monitoring.MonitoringContext;
import com.sun.portal.monitoring.MonitoringException;
import com.sun.portal.monitoring.Subsystem;
import com.sun.portal.monitoring.SubsystemImpl;
import com.sun.portal.netlet.monitoring.NetletConnectionsStatistic;
import com.sun.portal.rproxy.monitoring.ISLoggingStatistics;
import com.sun.portal.rproxy.monitoring.ISNotificationsStatistic;
import com.sun.portal.rproxy.monitoring.InternalServerStatistic;
import com.sun.portal.rproxy.monitoring.RProxyRequestsStatistic;
import com.sun.portal.rproxy.monitoring.RProxyResponseTimeStatistic;
import com.sun.portal.rproxy.monitoring.SSOOperationStatistic;
import com.sun.portal.rproxy.monitoring.ThreadActivityStatistic;
import com.sun.portal.rproxy.monitoring.ThreadPoolStatistic;
import com.sun.portal.rproxy.monitoring.UserProfileCacheStatistic;
import com.sun.portal.util.SRAEvent;
import com.sun.portal.util.SRAEventListener;
import com.sun.portal.util.ServiceIdentifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitoringSubsystem {
    private static Subsystem subsystem;
    private static boolean monitoringDisabled;
    private static List eventListeners;
    private static Logger logger;
    static /* synthetic */ Class class$com$sun$portal$rproxy$monitoring$MonitoringSubsystem;
    static /* synthetic */ Class class$com$sun$portal$monitoring$MonitoringContext;
    static /* synthetic */ Class class$com$sun$portal$monitoring$ConnectorContext;

    public static Subsystem getInstance() {
        if (subsystem == null) {
            try {
                subsystem = new SubsystemImpl(MonitoringSubsystem.getMonitoringProperties()){

                    public void start() throws MonitoringException {
                        monitoringDisabled = false;
                        super.start();
                        MonitoringSubsystem.initialize();
                    }

                    public void stop(Boolean unregisterMBeans) throws MonitoringException {
                        monitoringDisabled = true;
                        super.stop(unregisterMBeans);
                        MonitoringSubsystem.shutdown();
                    }
                };
            }
            catch (MonitoringException e) {
                logger.log(Level.SEVERE, "PSMN_CSPM0001", e);
            }
            try {
                subsystem.start();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSMN_CSPM0001", e);
            }
        }
        return subsystem;
    }

    private static Properties getMonitoringProperties() throws MonitoringException {
        String monConfigDir = System.getProperty("SRAP_CONFIG_DIR") + File.separator + System.getProperty("conf.suffix") + File.separator + System.getProperty("com.sun.portal.sra.component.type");
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(monConfigDir + File.separator + "monitoring.properties"));
        }
        catch (IOException e) {
            throw new MonitoringException((Throwable)e);
        }
        properties.setProperty((class$com$sun$portal$monitoring$MonitoringContext == null ? (class$com$sun$portal$monitoring$MonitoringContext = MonitoringSubsystem.class$("com.sun.portal.monitoring.MonitoringContext")) : class$com$sun$portal$monitoring$MonitoringContext).getName() + "." + MonitoringContext.PROPERTY_SUFFIX_CONFIGURATION_DIRECTORY, monConfigDir);
        properties.setProperty((class$com$sun$portal$monitoring$ConnectorContext == null ? (class$com$sun$portal$monitoring$ConnectorContext = MonitoringSubsystem.class$("com.sun.portal.monitoring.ConnectorContext")) : class$com$sun$portal$monitoring$ConnectorContext).getName() + "." + ConnectorContext.PROPERTY_SUFFIX_SSL_DISABLE, "true");
        properties.setProperty((class$com$sun$portal$monitoring$ConnectorContext == null ? (class$com$sun$portal$monitoring$ConnectorContext = MonitoringSubsystem.class$("com.sun.portal.monitoring.ConnectorContext")) : class$com$sun$portal$monitoring$ConnectorContext).getName() + "." + ConnectorContext.PROPERTY_SUFFIX_SASL_DISABLE, "true");
        return properties;
    }

    private static void initialize() {
        try {
            if (subsystem.isDisabled().booleanValue()) {
                return;
            }
            if (ServiceIdentifier.isGateway() || ServiceIdentifier.isRewriterProxy()) {
                MonitoringSubsystem.registerListeners(new RProxyResponseTimeStatistic(subsystem).initMBeans());
                MonitoringSubsystem.registerListeners(new RProxyRequestsStatistic(subsystem).initMBeans());
                MonitoringSubsystem.registerListeners(new InternalServerStatistic(subsystem));
            }
            MonitoringSubsystem.registerListeners(new ISNotificationsStatistic(subsystem).initMBeans());
            MonitoringSubsystem.registerListeners(new ISLoggingStatistics(subsystem).initMBeans());
            MonitoringSubsystem.registerListeners(new UserProfileCacheStatistic(subsystem).initMBeans());
            MonitoringSubsystem.registerListeners(new SSOOperationStatistic(subsystem).initMBeans());
            MonitoringSubsystem.registerListeners(new ThreadPoolStatistic(subsystem).initMBeans());
            if (ServiceIdentifier.isGateway() || ServiceIdentifier.isNetletProxy()) {
                MonitoringSubsystem.registerListeners(new NetletConnectionsStatistic(subsystem));
            }
            MonitoringSubsystem.registerListeners(new ThreadActivityStatistic(subsystem));
            monitoringDisabled = false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSMN_CSPM0001", e);
        }
    }

    private static void registerListeners(SRAEventListener eventListener) {
        SRAEvent[] events = eventListener.getInterestedEvents();
        for (int i = 0; i < events.length; ++i) {
            events[i].addListener(eventListener);
        }
        eventListeners.add(eventListener);
    }

    private static void shutdown() {
        for (int i = 0; i < eventListeners.size(); ++i) {
            SRAEventListener eventListener = (SRAEventListener)eventListeners.get(i);
            SRAEvent[] events = eventListener.getInterestedEvents();
            for (int j = 0; j < events.length; ++j) {
                try {
                    events[j].removeListener(eventListener);
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "PSMN_CSPM0001", e);
                }
            }
            eventListeners.remove(eventListener);
        }
    }

    public static boolean isMonitoringDisabled() {
        return monitoringDisabled;
    }

    public static void handleEvent(SRAEvent event) {
        if (monitoringDisabled) {
            return;
        }
        try {
            event.fireEvent(null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSMN_CSPM0001", e);
        }
    }

    public static void handleEvent(SRAEvent event, Object obj) {
        if (monitoringDisabled) {
            return;
        }
        try {
            event.fireEvent(obj);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSMN_CSPM0001", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        monitoringDisabled = true;
        eventListeners = new LinkedList();
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$rproxy$monitoring$MonitoringSubsystem == null ? (class$com$sun$portal$rproxy$monitoring$MonitoringSubsystem = MonitoringSubsystem.class$("com.sun.portal.rproxy.monitoring.MonitoringSubsystem")) : class$com$sun$portal$rproxy$monitoring$MonitoringSubsystem));
    }
}

