/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.monitoring;

import com.sun.portal.monitoring.Subsystem;
import com.sun.portal.monitoring.statistics.OpenStatistic;
import com.sun.portal.monitoring.statistics.StatisticWrapper;
import com.sun.portal.monitoring.utilities.ActivityTime;
import com.sun.portal.rproxy.monitoring.statistics.InternalServerStatisticImpl;
import com.sun.portal.rproxy.monitoring.statistics.InternalServerStatisticWrapper;
import com.sun.portal.rproxy.monitoring.util.RProxyEvent;
import com.sun.portal.util.SRAEvent;
import com.sun.portal.util.SRAEventListener;
import java.util.HashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class InternalServerStatistic
implements SRAEventListener {
    private Subsystem subsystem;
    private Map internalServerStatistics = new HashMap();
    private static ThreadLocal threadLocal = new ThreadLocal();
    private static ActivityTime activityTime = new ActivityTime();

    public InternalServerStatistic(Subsystem subsystem) {
        this.subsystem = subsystem;
    }

    private OpenStatistic getOpenStatistic(String destinationHostPort) {
        InternalServerStatisticWrapper internalServerStatisticWrapper = new InternalServerStatisticWrapper();
        internalServerStatisticWrapper.setCompositeTypeName(this.getClass().getName() + destinationHostPort);
        internalServerStatisticWrapper.setResourceBundleBaseName("InternalServerStatistics");
        return new OpenStatistic((StatisticWrapper)internalServerStatisticWrapper);
    }

    private ObjectName getObjectName(String destination) throws MalformedObjectNameException {
        return new ObjectName(this.subsystem.getNamingDomain() + ":type=InternalServerStatistics,destination=" + destination);
    }

    public void removeServerStatistic(ObjectName name) {
        this.internalServerStatistics.remove(name);
    }

    public void markDestination(String hostPort) {
        InternalServerStatisticImpl statistic = (InternalServerStatisticImpl)((Object)this.internalServerStatistics.get(hostPort));
        if (statistic == null) {
            OpenStatistic openStatistic = this.getOpenStatistic(hostPort);
            statistic = (InternalServerStatisticImpl)openStatistic.getStatisticWrapper().getStatisticImpl();
            statistic.setDestination(hostPort);
            this.internalServerStatistics.put(hostPort, statistic);
            try {
                this.subsystem.registerMBean((Object)openStatistic, this.getObjectName(hostPort).toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        threadLocal.set(statistic);
    }

    public void handleEvent(SRAEvent event, Object obj) {
        if (event == RProxyEvent.IDENTIFY_DESTINATION) {
            this.markDestination((String)obj);
            return;
        }
        InternalServerStatisticImpl statistic = (InternalServerStatisticImpl)((Object)threadLocal.get());
        if (statistic == null) {
            return;
        }
        if (event == RProxyEvent.RETRIEVAL_ERROR) {
            statistic.incrementServerError();
            return;
        }
        if (event == RProxyEvent.REQUEST_SENT) {
            statistic.incrementTotalRequests();
            activityTime.mark();
            return;
        }
        if (event == RProxyEvent.RESP_READ) {
            statistic.incrementBytesSent((Long)obj);
            return;
        }
        if (event == RProxyEvent.BAD_REQUEST) {
            statistic.incrementBadRequests();
            return;
        }
        if (event == RProxyEvent.RESPONSE_RECVD) {
            statistic.getResponseTime().setTime(activityTime.measure());
            statistic.incrementTotalResponses();
            return;
        }
        if (event == RProxyEvent.REQUEST_READ) {
            statistic.incrementBytesReceived((Long)obj);
            return;
        }
    }

    public SRAEvent[] getInterestedEvents() {
        return new SRAEvent[]{RProxyEvent.RETRIEVAL_ERROR, RProxyEvent.REQUEST_SENT, RProxyEvent.RESP_READ, RProxyEvent.BAD_REQUEST, RProxyEvent.IDENTIFY_DESTINATION, RProxyEvent.RESPONSE_RECVD, RProxyEvent.REQUEST_READ};
    }
}

