/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.https;

import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.Password;
import com.sun.portal.cli.cert.SRADecoderException;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.https.SRAPPasswordCallback;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.util.PasswordCallback;

public class SRAPNSSInit {
    public static String nickname = "server-cert";
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$rproxy$https$SRAPNSSInit == null ? (class$com$sun$portal$rproxy$https$SRAPNSSInit = SRAPNSSInit.class$("com.sun.portal.rproxy.https.SRAPNSSInit")) : class$com$sun$portal$rproxy$https$SRAPNSSInit));
    static /* synthetic */ Class class$com$sun$portal$rproxy$https$SRAPNSSInit;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean initialize() {
        String jssPassword;
        String certdbDir = System.getProperty("gateway.keybase", System.getProperty("SRAP_CONFIG_DIR", "/etc/opt/SUNWportal"));
        Object[] params0 = new Object[]{certdbDir};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRH026", params0);
        try {
            JSSUtil.setDefaultDecoder((String)certdbDir);
        }
        catch (SRADecoderException ex) {
            Object[] params1 = new Object[]{ex.getMessage()};
            logger.log(Level.SEVERE, "PSSRRPROXY_CSPRH027", params1);
        }
        String nicknamefile = System.getProperty("gateway.nickname", System.getProperty("SRAP_CONFIG_DIR", "/etc/opt/SUNWportal") + File.separatorChar + "cert" + File.separatorChar + ".nickname");
        Object[] params2 = new Object[]{nicknamefile};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRH028", params2);
        if (nicknamefile != null) {
            try {
                FileInputStream fis = new FileInputStream(nicknamefile);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                nickname = br.readLine();
            }
            catch (Exception ex) {
                Object[] params3 = new Object[]{nicknamefile};
                logger.log(Level.INFO, "PSSRRPROXY_CSPRH029", params3);
            }
        } else {
            logger.info("PSSRRPROXY_CSPRH030");
        }
        String pwfile = System.getProperty("gateway.pass", System.getProperty("SRAP_CONFIG_DIR", "/etc/opt/SUNWportal") + File.separatorChar + "cert" + File.separatorChar + ".jsspass");
        Object[] params5 = new Object[]{pwfile};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRH031", params5);
        if (pwfile == null) return false;
        try {
            FileInputStream fis = new FileInputStream(pwfile);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            jssPassword = br.readLine();
            Password pass = JSSUtil.decryptPassword((String)jssPassword);
            jssPassword = pass.getPassword();
            if (pass.isEncrypted()) {
                logger.info("PSSRRPROXY_CSPRH032");
            }
        }
        catch (Exception ex) {
            return false;
        }
        try {
            CryptoManager.InitializationValues vals = new CryptoManager.InitializationValues(certdbDir);
            CryptoManager.initialize((CryptoManager.InitializationValues)vals);
            CryptoManager.getInstance().setPasswordCallback((PasswordCallback)new SRAPPasswordCallback(jssPassword));
            return true;
        }
        catch (KeyDatabaseException kdbe) {
            logger.log(Level.SEVERE, "PSSRRPROXY_CSPRH033", kdbe);
            return false;
        }
        catch (CertDatabaseException cdbe) {
            logger.log(Level.SEVERE, "PSSRRPROXY_CSPRH034", cdbe);
            return false;
        }
        catch (AlreadyInitializedException aie) {
            logger.log(Level.SEVERE, "PSSRRPROXY_CSPRH035", aie);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSRRPROXY_CSPRH036", e);
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

