/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.https;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.https.ApprovalCallback;
import com.sun.portal.rproxy.https.JSSProxyRunnable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;
import sun.misc.RegexpPool;
import sun.net.www.http.HttpClient;
import sun.security.action.GetPropertyAction;

public final class HttpsClient
extends HttpClient {
    private static String secureTunnelHost = null;
    private static int secureTunnelPort = 80;
    private static RegexpPool dontProxy = null;
    private static final int httpsPortNumber = 443;
    public static int jssProxyPort = -1;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$rproxy$https$HttpsClient == null ? (class$com$sun$portal$rproxy$https$HttpsClient = HttpsClient.class$("com.sun.portal.rproxy.https.HttpsClient")) : class$com$sun$portal$rproxy$https$HttpsClient));
    private String instTunnelHost;
    private int instTunnelPort;
    private SSLSocket sslSocket = null;
    static /* synthetic */ Class class$com$sun$portal$rproxy$https$HttpsClient;

    protected int getDefaultPort() {
        return 443;
    }

    public static synchronized void resetSecureProperties() {
        String ourHost = HttpsClient.getProperty("https.proxyHost");
        Object[] params0 = new Object[]{ourHost};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRH003", params0);
        if (ourHost == null || "".equals(ourHost)) {
            secureTunnelHost = null;
            secureTunnelPort = 80;
        } else {
            secureTunnelHost = ourHost;
            secureTunnelPort = Integer.getInteger("https.proxyPort", 80);
        }
        dontProxy = new RegexpPool();
        String rawList = HttpsClient.getProperty("http.nonProxyHosts");
        Object[] params1 = new Object[]{rawList};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRH004", params1);
        if (rawList != null) {
            StringTokenizer st = new StringTokenizer(rawList, "|", false);
            try {
                while (st.hasMoreTokens()) {
                    dontProxy.add(st.nextToken().toLowerCase(), (Object)new Boolean(true));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(0, 50);
        }
        catch (IOException e) {
            ss = null;
        }
        if (ss != null) {
            jssProxyPort = ss.getLocalPort();
            JSSProxyRunnable jssProxy = new JSSProxyRunnable(ss);
            Thread t = new Thread(jssProxy);
            t.start();
        }
    }

    public HttpsClient(URL url) throws IOException {
        super(url, true);
        Object[] params2 = new Object[]{url};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRH005", params2);
    }

    public static HttpClient New(URL url) throws IOException {
        Object[] params3 = new Object[]{url};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRH006", params3);
        HttpsClient ret = (HttpsClient)kac.get(url);
        if (ret == null) {
            ret = new HttpsClient(url);
        } else {
            ret.url = url;
        }
        return ret;
    }

    protected boolean isNonProxyHost() {
        if (dontProxy.match(this.url.getHost().toLowerCase()) != null) {
            return true;
        }
        try {
            InetAddress addr = InetAddress.getByName(this.url.getHost());
            String host = addr.getHostAddress();
            if (dontProxy.match(host) != null) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    protected Socket doConnect(String host, int port) throws IOException, UnknownHostException {
        Object[] params4 = new Object[]{host, ", ", port + "", ")"};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRH007", params4);
        this.instTunnelHost = secureTunnelHost;
        int n = this.instTunnelPort = secureTunnelPort < 0 ? super.getDefaultPort() : secureTunnelPort;
        if (this.instTunnelHost == null || this.isNonProxyHost()) {
            this.sslSocket = new SSLSocket(InetAddress.getByName(host), port, null, 0, (SSLCertificateApprovalCallback)ApprovalCallback.getInstance(), null);
        } else {
            Object[] params5 = new Object[]{secureTunnelHost, ":", new Integer(secureTunnelPort)};
            logger.log(Level.INFO, "PSSRRPROXY_CSPRH008", params5);
            this.sslSocket = new SSLSocket(InetAddress.getByName("localhost"), jssProxyPort, null, 0, (SSLCertificateApprovalCallback)new ApprovalCallback(host), null);
            Integer localport = new Integer(this.sslSocket.getLocalPort());
            String info = secureTunnelHost + " " + secureTunnelPort + " " + host + " " + port;
            JSSProxyRunnable.connectHashMap.put(localport, info);
        }
        return this.sslSocket;
    }

    public String getCipherSuite() {
        String cipher = null;
        try {
            cipher = this.sslSocket.getStatus().getCipher();
        }
        catch (SocketException se) {
            logger.info("PSSRRPROXY_CSPRH009");
        }
        return cipher;
    }

    public X509Certificate[] getServerCertificateChain() {
        return null;
    }

    private static String getProperty(String prop) {
        SecurityException ex = null;
        try {
            return System.getProperty(prop);
        }
        catch (SecurityException e) {
            ex = e;
            try {
                return AccessController.doPrivileged(new GetPropertyAction("prop"));
            }
            catch (LinkageError linkageError) {
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HttpsClient.resetSecureProperties();
    }
}

