/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.SocketCache;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.SRAEvent;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLCachedSSLSocketFactory {
    private static SocketCache _cache;
    private static final String BLOCKED_SOCKET_TIMEOUT = "BlockedSocketTimeout";
    private static final int DEFAULT_SOCKET_TIMEOUT = 200;
    private static int _timeout;
    private static Logger logger;
    static /* synthetic */ Class class$com$sun$portal$rproxy$connectionhandler$SSLCachedSSLSocketFactory;

    private static CachedSocket createSocket(String host, int port, String socketType, Integer logId) {
        CachedSocket cachedSocket = null;
        SSLSocket sslSocket = null;
        Socket socket = null;
        try {
            socket = SSLSocketFactory.getDefault().createSocket(host, port);
            MonitoringSubsystem.handleEvent(SRAEvent.SSL_SOCKET_CREATED);
            if (GWLogManager.loggingEnabled) {
                GWLogManager.write("RProxy", GWLocale.getPFString("csslsf1", new Object[]{logId, socket.getInetAddress().toString(), new Integer(socket.getPort())}));
            }
            sslSocket = (SSLSocket)socket;
            sslSocket.setUseClientMode(true);
            socket.setSoTimeout(_timeout);
            cachedSocket = new CachedSocket(socket);
            cachedSocket.setType(socketType);
            cachedSocket.setActive();
            cachedSocket.setSocketCache(_cache);
            _cache.putSocket(cachedSocket);
        }
        catch (Exception e) {
            Object[] params = new Object[]{host, port + "", e};
            logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR116", params);
        }
        return cachedSocket;
    }

    public static CachedSocket createSocket(SSLSocket sslSocket) {
        CachedSocket cachedSocket = null;
        try {
            sslSocket.setUseClientMode(true);
            sslSocket.setSoTimeout(_timeout);
            cachedSocket = new CachedSocket(sslSocket);
            cachedSocket.setType(new String("ssl"));
            cachedSocket.setActive();
            cachedSocket.setSocketCache(_cache);
            _cache.putSocket(cachedSocket);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR117", e);
        }
        return cachedSocket;
    }

    public static CachedSocket getCachedSocket(String host, int port, String socketType, Integer logId) {
        CachedSocket cachedSocket = null;
        if (cachedSocket == null) {
            cachedSocket = SSLCachedSSLSocketFactory.createSocket(host, port, socketType, logId);
        }
        return cachedSocket;
    }

    public static CachedSocket getNewCachedSocket(String host, int port, String socketType, Integer logId) {
        return SSLCachedSSLSocketFactory.createSocket(host, port, socketType, logId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$rproxy$connectionhandler$SSLCachedSSLSocketFactory == null ? (class$com$sun$portal$rproxy$connectionhandler$SSLCachedSSLSocketFactory = SSLCachedSSLSocketFactory.class$("com.sun.portal.rproxy.connectionhandler.SSLCachedSSLSocketFactory")) : class$com$sun$portal$rproxy$connectionhandler$SSLCachedSSLSocketFactory));
        _timeout = GatewayProfile.getInt(BLOCKED_SOCKET_TIMEOUT, 200) * 1000;
        _cache = new SocketCache();
    }
}

