/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.HostAvailabilityEvent;
import com.sun.portal.util.HostAvailabilityListener;
import com.sun.portal.util.HostChecker;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RewriterProxyRouter
extends HostAvailabilityListener {
    static Set rewriter_proxies = new HashSet();
    public static Map _unavailable_rewriter_proxies = new HashMap();
    private static int _retry;
    private static Iterator iterator;
    private static int noOfRewriterProxies;
    private static String onlyOneRewriterProxy;
    private static final int PROXY_HTTP_PORT = 8080;
    private static Logger logger;
    private static RewriterProxyRouter instance;
    static /* synthetic */ Class class$com$sun$portal$rproxy$connectionhandler$RewriterProxyRouter;

    private RewriterProxyRouter() {
        this.addHostAvailabilityListener(this);
    }

    public static RewriterProxyRouter getInstance() {
        return instance;
    }

    private static boolean contains(String rwp) {
        if (rwp == null || rwp.trim().length() == 0) {
            return false;
        }
        if (noOfRewriterProxies == 1) {
            return onlyOneRewriterProxy.equalsIgnoreCase(rwp);
        }
        return rewriter_proxies.contains(rwp.toLowerCase());
    }

    static synchronized String getServer() {
        if (noOfRewriterProxies < 2) {
            return onlyOneRewriterProxy;
        }
        if (iterator.hasNext()) {
            return iterator.next().toString();
        }
        iterator = rewriter_proxies.iterator();
        return iterator.next().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isAlive(String rwp) {
        Map map = _unavailable_rewriter_proxies;
        synchronized (map) {
            if (!_unavailable_rewriter_proxies.isEmpty() && _unavailable_rewriter_proxies.get(rwp) != null) {
                return false;
            }
        }
        try {
            URL url = new URL(rwp);
            return HostChecker.isHostAvailable(url, 3);
        }
        catch (MalformedURLException mae) {
            logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR115", mae);
            return false;
        }
    }

    public static String getRewriterProxyAlive() {
        String rwp = null;
        boolean alive = false;
        if (noOfRewriterProxies == 1) {
            if (RewriterProxyRouter.isAlive(onlyOneRewriterProxy)) {
                return onlyOneRewriterProxy;
            }
            return null;
        }
        for (int alive_servers = rewriter_proxies.size(); !alive && alive_servers > 0; --alive_servers) {
            rwp = RewriterProxyRouter.getServer();
            alive = RewriterProxyRouter.isAlive(rwp);
        }
        if (!alive) {
            return null;
        }
        return rwp;
    }

    static boolean isRewriterProxyAlive(String rwp) {
        return RewriterProxyRouter.isAlive(rwp);
    }

    private static String getRewriterProxyAlive(String rwp) {
        if (RewriterProxyRouter.isAlive(rwp)) {
            return rwp;
        }
        return RewriterProxyRouter.getRewriterProxyAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hostAvailabilityChanged(HostAvailabilityEvent hae) {
        if (hae.getHostType() == 3) {
            Map map = _unavailable_rewriter_proxies;
            synchronized (map) {
                if (hae.getHostStatus() == 1) {
                    _unavailable_rewriter_proxies.remove(hae.getHost());
                } else if (hae.getHostStatus() == 2) {
                    long time = System.currentTimeMillis();
                    _unavailable_rewriter_proxies.put(hae.getHost(), new Long(time));
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        noOfRewriterProxies = 0;
        onlyOneRewriterProxy = null;
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$rproxy$connectionhandler$RewriterProxyRouter == null ? (class$com$sun$portal$rproxy$connectionhandler$RewriterProxyRouter = RewriterProxyRouter.class$("com.sun.portal.rproxy.connectionhandler.RewriterProxyRouter")) : class$com$sun$portal$rproxy$connectionhandler$RewriterProxyRouter));
        instance = new RewriterProxyRouter();
        _retry = GatewayProfile.getInt("ServerRetryInterval", 5);
        List allrewriter_proxies = GatewayProfile.getStringList("RewriterProxyHost");
        Iterator it = allrewriter_proxies.iterator();
        noOfRewriterProxies = allrewriter_proxies.size();
        if (noOfRewriterProxies == 1) {
            onlyOneRewriterProxy = "https://" + it.next().toString();
        } else {
            while (it.hasNext()) {
                rewriter_proxies.add("https://" + it.next().toString().toLowerCase());
            }
            iterator = rewriter_proxies.iterator();
        }
    }
}

