/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.connectionhandler.HeaderResponse;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.rproxy.monitoring.util.RProxyEvent;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class RedirectResponse
extends HeaderResponse {
    private static final String REDIRECTMESSAGE = "RedirectMessage";
    private static final String STATUS_CODE = "302";
    private static final String STATUS_TEXT = "Moved Temporarily";
    private static final String space = " ";
    private String _location;
    private boolean _needTranslation = true;

    public RedirectResponse(String location) {
        super(REDIRECTMESSAGE, "", STATUS_CODE, STATUS_TEXT, null);
        MonitoringSubsystem.handleEvent(RProxyEvent.LOGIN_REDIRECT);
        this._location = location;
        this.substituteContent(this._location);
    }

    public RedirectResponse(String location, boolean nt) {
        super(REDIRECTMESSAGE, "", STATUS_CODE, STATUS_TEXT, null);
        MonitoringSubsystem.handleEvent(RProxyEvent.LOGIN_REDIRECT);
        this._location = location;
        this._needTranslation = nt;
        this.substituteContent(this._location);
    }

    public boolean needTranslation() {
        return this._needTranslation;
    }

    public String getResponseHeader(String s) {
        if (s.regionMatches(true, 0, "location:", 0, 9)) {
            return this._location;
        }
        return null;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public String getLocation() {
        return this._location;
    }

    public byte[] getHeaderBytes() {
        ByteArrayOutputStream outBAOS = new ByteArrayOutputStream();
        try {
            DataOutputStream out = new DataOutputStream(outBAOS);
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(this.getHTTPVersion());
            strBuffer.append(space);
            strBuffer.append(this.getStatusCode());
            strBuffer.append(space);
            strBuffer.append(this.getStatusText());
            strBuffer.append("\r\n");
            strBuffer.append("Date: ");
            strBuffer.append(this.df.format(new Date()));
            strBuffer.append("\r\n");
            strBuffer.append("Server: Redirector");
            strBuffer.append("\r\n");
            strBuffer.append("Location: ");
            strBuffer.append(this.getLocation());
            strBuffer.append("\r\n");
            strBuffer.append("Content-Length: ");
            strBuffer.append(this.getContentLength());
            strBuffer.append("\r\n");
            strBuffer.append("Content-Type: ");
            strBuffer.append(this.getContentType());
            strBuffer.append("/");
            strBuffer.append(this.getContentEncoding());
            strBuffer.append("\r\n");
            out.writeBytes(strBuffer.toString());
            if (this.keepAliveToken != null) {
                out.writeBytes(this.keepAliveToken);
            }
            if (this._cookie != null) {
                out.writeBytes(this._cookie + "\r\n");
            }
            out.writeBytes("\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outBAOS.toByteArray();
    }
}

