/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.netlet.econnection.ReaderWriter;
import com.sun.portal.netlet.econnection.ReaderWriterClear;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.SRAEvent;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.jss.ssl.SSLSocket;

public class RWGroupJSSProxy
extends ReaderWriterLock {
    private Socket fromClient;
    private Socket toServer;
    private ReaderWriterClear src_to_dst;
    private ReaderWriterClear dst_to_src;
    private boolean src_to_dst_clean = false;
    private boolean dst_to_src_clean = false;
    private long startTime;
    private static Logger logger = null;

    public RWGroupJSSProxy(Socket fromSocket, Socket toSocket) {
        logger = Logger.getLogger("com.sun.portal.sra.rproxy");
        this.startTime = System.currentTimeMillis();
        this.fromClient = fromSocket;
        this.toServer = toSocket;
        try {
            this.src_to_dst = new ReaderWriterClear(this, this.fromClient.getInputStream(), this.toServer.getOutputStream());
            this.dst_to_src = new ReaderWriterClear(this, this.toServer.getInputStream(), this.fromClient.getOutputStream());
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Unable to create ReaderWriter threads.", ex);
        }
        try {
            GWThreadPool.run(this.src_to_dst);
            GWThreadPool.run(this.dst_to_src);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "Could not start ReaderWriterClear tasks", e);
        }
    }

    public synchronized void notifyFinished(ReaderWriter obj) {
        if (obj == this.src_to_dst) {
            if (this.dst_to_src.isAlive()) {
                this.dst_to_src.stop();
            }
        } else if (obj == this.dst_to_src && this.src_to_dst.isAlive()) {
            this.src_to_dst.stop();
        }
        this.cleanup();
        if (obj == this.src_to_dst) {
            this.src_to_dst_clean = true;
        } else if (obj == this.dst_to_src) {
            this.dst_to_src_clean = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (this.fromClient != null) {
            try {
                this.fromClient.close();
                if (this.fromClient instanceof SSLSocket) {
                    MonitoringSubsystem.handleEvent(SRAEvent.SSL_SOCKET_DESTROYED);
                } else {
                    MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_DESTROYED);
                }
            }
            catch (Exception e) {
            }
            finally {
                this.fromClient = null;
            }
        }
        if (this.toServer != null) {
            try {
                this.toServer.close();
                if (this.toServer instanceof SSLSocket) {
                    MonitoringSubsystem.handleEvent(SRAEvent.SSL_SOCKET_DESTROYED);
                } else {
                    MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_DESTROYED);
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.toServer = null;
            }
        }
    }

    public boolean isDone() {
        if (this.dst_to_src_clean && this.src_to_dst_clean) {
            this.dst_to_src = null;
            this.src_to_dst = null;
        }
        return this.dst_to_src_clean && this.src_to_dst_clean;
    }

    public long getLastActivityTime() {
        if (this.src_to_dst.getLastActivityTime() > this.dst_to_src.getLastActivityTime()) {
            return this.src_to_dst.getLastActivityTime();
        }
        return this.dst_to_src.getLastActivityTime();
    }

    public synchronized void stopAll() {
        if (this.dst_to_src != null) {
            this.dst_to_src.stop();
        }
        if (this.src_to_dst != null) {
            this.src_to_dst.stop();
        }
        this.cleanup();
    }

    public int getAppletSrcPort() {
        return 0;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

