/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.BasicAuthentication;
import com.sun.portal.rproxy.connectionhandler.CSBufferedInputStream;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.CachedSocketFactory;
import com.sun.portal.rproxy.connectionhandler.CookieParser;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.rproxy.connectionhandler.Retriever;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.rproxy.monitoring.util.RProxyEvent;
import com.sun.portal.util.DomainWebProxyConfig;
import com.sun.portal.util.ServiceIdentifier;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HTTPRetriever
implements Retriever {
    private static final String SET_COOKIE = "Set-Cookie";
    private static String gateway_ip;
    private static boolean cookie_management;
    private static boolean doBasicAuthentication;
    public static int numBytesRead;
    private static final int defaultBufferSize = 2048;
    private static final int MARK_MAX_VALUE = 8192;
    private static Logger logger;
    static /* synthetic */ Class class$com$sun$portal$rproxy$connectionhandler$HTTPRetriever;

    public Response getResponse2(Request req, String destinationHost, Integer logId, byte[] param) {
        HTTPResponse result;
        CachedSocket s;
        block19: {
            s = null;
            CSBufferedInputStream in = null;
            String password = null;
            boolean found_pw = false;
            if (doBasicAuthentication) {
                password = req.getRequestHeader("Authorization");
                if (password == null) {
                    found_pw = BasicAuthentication.getPassword(req, destinationHost);
                } else {
                    String basic = password.substring(password.indexOf(58) + 1).trim();
                    if (!basic.regionMatches(true, 0, "basic ", 0, 5)) {
                        password = null;
                    }
                }
            }
            if (req.getUseProxy()) {
                String proxy_passwd;
                String prxyhost = req.getProxyHost();
                String headerProxyAuth = req.getRequestHeader("Proxy-Authorization");
                if (headerProxyAuth == null && (proxy_passwd = DomainWebProxyConfig.getProxyPassword(prxyhost)) != null) {
                    req.setRequestHeader("Proxy-Authorization", "Proxy-Authorization: Basic " + proxy_passwd);
                }
            }
            result = null;
            try {
                result = new HTTPResponse();
                Object[] params0 = new Object[]{req};
                logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR070", params0);
                if (req.getUseProxy()) {
                    s = CachedSocketFactory.getCachedSocket(req.getProxyHost(), req.getProxyPort(), "plain", logId);
                    Object[] params1 = new Object[]{req.getProxyHost()};
                    logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR071", params1);
                } else {
                    s = CachedSocketFactory.getCachedSocket(req.getHost(), Integer.parseInt(req.getPort()), "plain", logId);
                    Object[] params2 = new Object[]{req.getHost()};
                    logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR072", params2);
                }
                if (s == null) {
                    logger.warning("HTTPRetriever: Null socket returned. Probably couldn't resolve host.");
                    return null;
                }
                try {
                    this.sendRequest2(req, s, param);
                    in = s.getInputStream();
                    this.getResponseHeader(result, in, req);
                }
                catch (Exception e) {
                    if (req.getUseProxy()) {
                        s = CachedSocketFactory.getNewCachedSocket(req.getProxyHost(), req.getProxyPort(), "plain", logId);
                        Object[] params3 = new Object[]{req.getProxyHost()};
                        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR073", params3);
                    } else {
                        s = CachedSocketFactory.getNewCachedSocket(req.getHost(), Integer.parseInt(req.getPort()), "plain", logId);
                        Object[] params4 = new Object[]{req.getHost()};
                        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR074", params4);
                    }
                    this.sendRequest2(req, s, param);
                    in = s.getInputStream();
                    this.getResponseHeader(result, in, req);
                }
                if (doBasicAuthentication && result.getStatusCode().compareTo("401") != 0 && result.getStatusCode().compareTo("403") != 0 && password != null) {
                    BasicAuthentication.storePassword(req, destinationHost);
                }
                String cl = result.getResponseHeader("content-length");
                int length = 0;
                length = cl != null ? Integer.parseInt(cl.substring(cl.indexOf(58) + 1).trim()) : -1;
                in.setClosed();
                in.setLength(length);
                result.setContentStream(in);
                result.setSocket(s);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR075", ex);
                result = null;
                if (s == null) break block19;
                try {
                    s.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (result != null) {
            result.setSocket(s);
        }
        return result;
    }

    public void sendRequest(Request req, CachedSocket s) throws IOException, EOFException {
        if (cookie_management && !req.getHost().equals(gateway_ip)) {
            CookieParser.restoreCookieHeader(req);
        }
        OutputStream out = s.getOutputStream();
        out.write(req.getRequestHeaderBytes());
        out.flush();
        String contentLength = req.getRequestHeader("Content-length");
        if (contentLength != null) {
            int length = Integer.parseInt(contentLength.substring(contentLength.indexOf(58) + 1).trim());
            byte[] content = new byte[2048];
            int read = 0;
            int totalRead = 0;
            BufferedInputStream reqIn = req.getContentStream();
            while (totalRead + 2048 < length) {
                read = reqIn.read(content, 0, 2048);
                if (read == -1 && totalRead < length) {
                    throw new EOFException();
                }
                if (read == 0) break;
                out.write(content, 0, read);
                totalRead += read;
            }
            int buffoffset = 0;
            while (totalRead < length) {
                read = reqIn.read(content, buffoffset, length - totalRead);
                if (read == -1 && totalRead < length) {
                    throw new EOFException();
                }
                if (read == 0) break;
                totalRead += read;
                buffoffset += read;
            }
            out.write(content, 0, buffoffset);
            req.addSize(totalRead);
            MonitoringSubsystem.handleEvent(RProxyEvent.REQUEST_READ, new Long(totalRead));
        }
        out.flush();
    }

    public void sendRequest2(Request req, CachedSocket s, byte[] content) throws IOException, EOFException {
        if (cookie_management && !req.getHost().equals(gateway_ip)) {
            CookieParser.restoreCookieHeader(req);
        }
        OutputStream out = s.getOutputStream();
        out.write(req.getRequestHeaderBytes());
        out.flush();
        String contentLength = req.getRequestHeader("Content-length");
        if (contentLength != null) {
            int length = Integer.parseInt(contentLength.substring(contentLength.indexOf(58) + 1).trim());
            out.write(content);
        }
        out.flush();
    }

    public void getResponseHeader(HTTPResponse result, CSBufferedInputStream in, Request req) throws IOException, EOFException {
        boolean toSetCookie = cookie_management && !req.getHost().equals(gateway_ip);
        boolean keepGoing = true;
        in.setLength(4000);
        ByteArrayOutputStream byteOutStrm = new ByteArrayOutputStream();
        while (keepGoing) {
            int b = in.read();
            if (b == -1) {
                keepGoing = false;
                throw new EOFException();
            }
            byteOutStrm.write(b);
            if (b != 10) continue;
            String s = byteOutStrm.toString();
            if (s.regionMatches(true, 0, SET_COOKIE, 0, SET_COOKIE.length()) && toSetCookie) {
                String s_new = CookieParser.modifyCookieHeader(result, req, s);
                if (s_new != null) {
                    result.addHeaderLine(s_new);
                }
            } else if (s.toLowerCase().startsWith("content-length")) {
                String myHeader = result.getResponseHeader("Content-Length");
                if (myHeader == null) {
                    result.addHeaderLine(s);
                }
            } else if (s.toLowerCase().startsWith("content-disposition")) {
                s = byteOutStrm.toString("ISO-8859-1");
                result.addHeaderLine(s);
            } else {
                result.addHeaderLine(s);
            }
            keepGoing = !result.isHeaderComplete();
            byteOutStrm.reset();
        }
    }

    public Response getResponse(Request req, String destinationHost, Integer logId) {
        HTTPResponse result;
        CachedSocket s;
        block21: {
            s = null;
            CSBufferedInputStream in = null;
            String password = null;
            boolean found_pw = false;
            if (doBasicAuthentication) {
                password = req.getRequestHeader("Authorization");
                if (password == null) {
                    found_pw = BasicAuthentication.getPassword(req, destinationHost);
                } else {
                    String basic = password.substring(password.indexOf(58) + 1).trim();
                    if (!basic.regionMatches(true, 0, "basic ", 0, 5)) {
                        password = null;
                    }
                }
            }
            if (req.getUseProxy()) {
                String proxy_passwd;
                String prxyhost = req.getProxyHost();
                String headerProxyAuth = req.getRequestHeader("Proxy-Authorization");
                if (headerProxyAuth == null && (proxy_passwd = DomainWebProxyConfig.getProxyPassword(prxyhost)) != null) {
                    req.setRequestHeader("Proxy-Authorization", "Proxy-Authorization: Basic " + proxy_passwd);
                }
            }
            result = null;
            try {
                result = new HTTPResponse();
                Object[] params6 = new Object[]{req};
                logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR076", params6);
                if (req.getUseProxy()) {
                    s = CachedSocketFactory.getCachedSocket(req.getProxyHost(), req.getProxyPort(), "plain", logId);
                    Object[] params7 = new Object[]{req.getProxyHost()};
                    logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR077", params7);
                } else {
                    s = CachedSocketFactory.getCachedSocket(req.getHost(), Integer.parseInt(req.getPort()), "plain", logId);
                    Object[] params8 = new Object[]{req.getHost()};
                    logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR078", params8);
                }
                if (s == null) {
                    logger.warning("HTTPRetriever: Null socket returned. Probably couldn't resolve host.");
                    return null;
                }
                try {
                    Object[] params9 = new Object[]{req};
                    logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR079", params9);
                    if (req.getContentStream() != null) {
                        req.getContentStream().mark(8192);
                    }
                    this.sendRequest(req, s);
                    in = s.getInputStream();
                    this.getResponseHeader(result, in, req);
                }
                catch (Exception e) {
                    MonitoringSubsystem.handleEvent(RProxyEvent.RETRIEVAL_ERROR);
                    logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR080", e);
                    if (req.getUseProxy()) {
                        s = CachedSocketFactory.getNewCachedSocket(req.getProxyHost(), req.getProxyPort(), "plain", logId);
                        Object[] params11 = new Object[]{req.getProxyHost()};
                        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR081", params11);
                    } else {
                        s = CachedSocketFactory.getNewCachedSocket(req.getHost(), Integer.parseInt(req.getPort()), "plain", logId);
                        Object[] params12 = new Object[]{req.getHost()};
                        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR082", params12);
                    }
                    Object[] params13 = new Object[]{req.getObject()};
                    logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR083", params13);
                    if (req.getContentStream() != null) {
                        req.getContentStream().reset();
                    }
                    this.sendRequest(req, s);
                    in = s.getInputStream();
                    this.getResponseHeader(result, in, req);
                }
                if (doBasicAuthentication && result.getStatusCode().compareTo("401") != 0 && result.getStatusCode().compareTo("403") != 0 && password != null) {
                    BasicAuthentication.storePassword(req, destinationHost);
                }
                String cl = result.getResponseHeader("content-length");
                int length = 0;
                length = cl != null ? Integer.parseInt(cl.substring(cl.indexOf(58) + 1).trim()) : -1;
                in.setClosed();
                in.setLength(length);
                result.setContentStream(in);
                result.setSocket(s);
            }
            catch (Exception ex) {
                MonitoringSubsystem.handleEvent(RProxyEvent.RETRIEVAL_ERROR);
                logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR084", ex);
                result = null;
                if (s == null) break block21;
                try {
                    s.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (result != null) {
            result.setSocket(s);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        doBasicAuthentication = false;
        numBytesRead = 0;
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$rproxy$connectionhandler$HTTPRetriever == null ? (class$com$sun$portal$rproxy$connectionhandler$HTTPRetriever = HTTPRetriever.class$("com.sun.portal.rproxy.connectionhandler.HTTPRetriever")) : class$com$sun$portal$rproxy$connectionhandler$HTTPRetriever));
        try {
            byte[] ip = InetAddress.getLocalHost().getAddress();
            gateway_ip = Integer.toString(ip[0] & 0xFF) + "." + Integer.toString(ip[1] & 0xFF) + "." + Integer.toString(ip[2] & 0xFF) + "." + Integer.toString(ip[3] & 0xFF);
        }
        catch (Exception e) {
            gateway_ip = null;
        }
        cookie_management = GatewayProfile.getBoolean("CookieManagement", false) && ServiceIdentifier.isGateway();
        doBasicAuthentication = GatewayProfile.getBoolean("DoBasicAuthentication", false) && ServiceIdentifier.isGateway();
    }
}

