/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.CookieManager;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class HTTPResponse
implements Response {
    private static final String _crlf = new String(new byte[]{13, 10});
    private static final String _lf = new String(new byte[]{10});
    private List _headerLines = new ArrayList();
    private boolean _firstLine = true;
    private static final String supportedHTTPVersion = "HTTP/1.0";
    private String _httpVersion = "HTTP/1.0";
    private boolean _headerComplete = false;
    private String _statusCode = null;
    private String _statusText = null;
    private String _contentType = null;
    private String _contentEncoding = null;
    private BufferedInputStream _contentStream = null;
    private Map _headerCache = new HashMap();
    private CachedSocket sock = null;
    private static final String allowClientCaching = SystemProperties.get("gateway.allow.client.caching");

    public void setSocket(CachedSocket socket) {
        this.sock = socket;
    }

    public void closeSocket() {
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getHTTPVersion() {
        return this._httpVersion;
    }

    public String getStatusCode() {
        return this._statusCode;
    }

    public String getStatusText() {
        return this._statusText;
    }

    public String getContentType() {
        try {
            if (this._contentType == null) {
                String header = this.getResponseHeader("Content-Type");
                int start = header.indexOf(58);
                this._contentType = start == -1 ? "" : (header.endsWith(_crlf) ? header.substring(start + 1, header.length() - 2).trim() : header.substring(start + 1, header.length() - 1).trim());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this._contentType;
    }

    public void setContentLength(int length) {
        String header = this.getResponseHeader("Content-Length");
        if (header != null) {
            int numElements = this._headerLines.size();
            for (int i = 0; i < numElements; ++i) {
                if (!header.equals((String)this._headerLines.get(i))) continue;
                this._headerLines.remove(i);
                numElements = this._headerLines.size();
            }
        }
        this._headerLines.add("Content-Length: " + length + "\r\n");
    }

    public void setClientCaching() {
        if (allowClientCaching == null) {
            return;
        }
        String header = this.getResponseHeader("Pragma");
        if (header != null) {
            this.removeHeader("Pragma");
        }
        if (allowClientCaching.toLowerCase().equals("false")) {
            this._headerLines.add("Pragma: no-cache\r\n");
        }
    }

    public void setConnectionClose() {
        String header = this.getResponseHeader("Connection");
        if (header != null) {
            int numElements = this._headerLines.size();
            for (int i = 0; i < numElements; ++i) {
                if (!header.equals((String)this._headerLines.get(i))) continue;
                this._headerLines.remove(i);
                this._headerCache.remove("connection");
                break;
            }
        }
        this._headerLines.add("Connection: close\r\n");
    }

    public void setConnectionAlive(String token) {
        String connHeader = this.getResponseHeader("Connection");
        String keepAliveHeader = this.getResponseHeader("KeepAlive");
        boolean numHeaderDone = false;
        boolean compareConnHeader = connHeader != null;
        boolean compareKeepAliveHeader = keepAliveHeader != null;
        int numHeaderToDo = 0;
        if (compareConnHeader) {
            ++numHeaderToDo;
        }
        if (compareKeepAliveHeader) {
            ++numHeaderToDo;
        }
        Iterator iter = this._headerLines.iterator();
        while (iter.hasNext()) {
            String headerValue = (String)iter.next();
            if (compareConnHeader && connHeader.equalsIgnoreCase(headerValue)) {
                iter.remove();
                this._headerCache.remove("connection");
            }
            if (!compareKeepAliveHeader || !keepAliveHeader.equalsIgnoreCase(headerValue)) continue;
            iter.remove();
            this._headerCache.remove("keepalive");
        }
        this._headerLines.add("Connection: Keep-Alive\r\n");
        this._headerLines.add("Keep-Alive: " + token + "\r\n");
    }

    public void setLocation(String location) {
        String header = this.getResponseHeader("Location");
        if (header != null) {
            int numElements = this._headerLines.size();
            for (int i = 0; i < numElements; ++i) {
                if (!header.equals((String)this._headerLines.get(i))) continue;
                this._headerLines.remove(i);
                break;
            }
        }
        if (location.toLowerCase().startsWith("location:")) {
            this._headerLines.add(location);
        } else {
            this._headerLines.add("Location: " + location + "\r\n");
        }
    }

    public void setContentLocation(String location) {
        String header = this.getResponseHeader("Content-Location");
        if (header != null) {
            int numElements = this._headerLines.size();
            for (int i = 0; i < numElements; ++i) {
                if (!header.equals((String)this._headerLines.get(i))) continue;
                this._headerLines.remove(i);
                break;
            }
        }
        if (location.toLowerCase().startsWith("content-location:")) {
            this._headerLines.add(location);
        } else {
            this._headerLines.add("Content-Location: " + location + "\r\n");
        }
    }

    public String getContentEncoding() {
        try {
            if (this._contentEncoding == null) {
                String header = this.getResponseHeader("Content-Encoding");
                int start = header.indexOf(58);
                this._contentEncoding = start == -1 ? "" : header.substring(start + 1, header.length() - 2).trim();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this._contentEncoding;
    }

    public String getResponseHeader(String header) {
        String result = (String)this._headerCache.get(header = header.toLowerCase());
        if (result == null) {
            int numElements = this._headerLines.size();
            for (int i = 0; i < numElements && result == null; ++i) {
                String s = (String)this._headerLines.get(i);
                if (!s.regionMatches(true, 0, header, 0, header.length())) continue;
                result = s;
                this._headerCache.put(header, s);
            }
        }
        return result;
    }

    public void setResponseHeader(String header, String value) {
        if (header == null || value == null) {
            return;
        }
        int vallen = value.length();
        if (value.charAt(vallen - 1) != '\n' || value.charAt(vallen - 2) != '\r') {
            value = value + _crlf;
        }
        int headerLen = header.length();
        int numHeaders = this._headerLines.size();
        for (int i = 0; i < numHeaders; ++i) {
            String s = (String)this._headerLines.get(i);
            if (!s.regionMatches(true, 0, header, 0, headerLen)) continue;
            this._headerLines.remove(i);
            this._headerLines.add(value);
            this._headerCache.remove(header);
            return;
        }
        this._headerLines.add(value);
    }

    public void appendResponseHeader(String header, String value) {
        if (header == null || value == null) {
            return;
        }
        int vallen = value.length();
        if (value.charAt(vallen - 1) != '\n' || value.charAt(vallen - 2) != '\r') {
            value = value + _crlf;
        }
        this._headerLines.add(value);
    }

    public void removeResponseHeader(String header) {
        if (header == null) {
            return;
        }
        int headerLen = header.length();
        this._headerCache.remove(header);
        Iterator iter = this._headerLines.iterator();
        while (iter.hasNext()) {
            String s = iter.next().toString();
            if (!s.regionMatches(true, 0, header, 0, headerLen)) continue;
            iter.remove();
        }
    }

    public BufferedInputStream getContentStream() {
        return this._contentStream;
    }

    public void setContentStream(BufferedInputStream in) {
        this._contentStream = in;
    }

    public boolean isHeaderComplete() {
        return this._headerComplete;
    }

    public void addHeaderLine(String s) {
        if (this._firstLine) {
            if (!s.equals(_crlf)) {
                this._firstLine = false;
                StringTokenizer st = new StringTokenizer(s);
                st.nextToken();
                this._httpVersion = supportedHTTPVersion;
                this._statusCode = st.nextToken();
                this._statusText = st.hasMoreTokens() ? s.substring(s.indexOf(this._statusCode) + this._statusCode.length(), s.length() - 2).trim() : "";
            }
        } else if (s.equals(_crlf) || s.equals(_lf)) {
            this._headerComplete = true;
        } else {
            this._headerLines.add(s);
        }
    }

    public byte[] getHeaderBytes() {
        ByteArrayOutputStream outBAOS = new ByteArrayOutputStream();
        try {
            DataOutputStream out = new DataOutputStream(outBAOS);
            out.write((this.getHTTPVersion() + " " + this.getStatusCode() + " " + this.getStatusText() + "\r\n").getBytes());
            int numElems = this._headerLines.size();
            for (int i = 0; i < numElems; ++i) {
                String s = (String)this._headerLines.get(i);
                if (!s.endsWith(_crlf)) {
                    s = s.substring(0, s.indexOf("\n")) + _crlf;
                }
                if (s.toLowerCase().startsWith("content-disposition")) {
                    out.write(s.getBytes("ISO-8859-1"));
                    continue;
                }
                out.write(s.getBytes());
            }
            out.write("\r\n".getBytes());
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outBAOS.toByteArray();
    }

    public String toString() {
        return new String(this.getHeaderBytes());
    }

    public void setStatusText(String st) {
        this._statusText = st;
    }

    public void processSetCookieHeaders(Request req) {
        if (!ServiceIdentifier.isGateway() || req.isCookieSupported()) {
            return;
        }
        CookieManager.processSetCookieHeaders(req, this);
    }

    public List getHeaderAttributeList(String header) {
        int headerLength = header.length();
        int numElements = this._headerLines.size();
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < numElements; ++i) {
            String tHeader;
            String s = this._headerLines.get(i).toString();
            int indx = s.indexOf(58);
            if (indx == -1 || !(tHeader = s.substring(0, indx).trim()).equalsIgnoreCase(header)) continue;
            list.addLast(s);
        }
        return list;
    }

    public boolean removeHeader(String header) {
        boolean removed = false;
        int numElements = this._headerLines.size();
        Iterator iter = this._headerLines.iterator();
        header = header.trim().toLowerCase();
        while (iter.hasNext()) {
            String tHeader;
            String s = iter.next().toString();
            int indx = s.indexOf(58);
            if (indx == -1 || !(tHeader = s.substring(0, indx).trim()).equalsIgnoreCase(header)) continue;
            iter.remove();
            removed = true;
        }
        this._headerCache.remove(header);
        return removed;
    }

    public void setHeader(String headerName, String headerValue) {
        int dotIndex = headerValue.indexOf(58);
        boolean needPrefixing = false;
        if (dotIndex != -1) {
            String tmpHeaderName = headerValue.substring(0, dotIndex).trim();
            if (!tmpHeaderName.equalsIgnoreCase(headerName)) {
                needPrefixing = true;
            }
        } else {
            needPrefixing = true;
        }
        if (needPrefixing) {
            headerValue = headerName + " : " + headerValue;
        }
        this._headerLines.add(headerValue);
    }

    public void setHeader(String headerName, List headers) {
        Iterator iter = headers.iterator();
        while (iter.hasNext()) {
            this.setHeader(headerName, iter.next().toString());
        }
    }
}

