/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.ClientDetector;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.Base64;
import com.sun.portal.rproxy.connectionhandler.CookieManager;
import com.sun.portal.rproxy.connectionhandler.GatewayServletInputStream;
import com.sun.portal.rproxy.connectionhandler.MatchHttps;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.ServletHTTPRequest;
import com.sun.portal.rproxy.connectionhandler.webdav.DavIf;
import com.sun.portal.rproxy.connectionhandler.webdav.ParseException;
import com.sun.portal.rproxy.connectionhandler.webdav.UnRewriter;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.rproxy.monitoring.util.RProxyEvent;
import com.sun.portal.rproxy.rewriter.SRAPTranslatorHelper;
import com.sun.portal.rproxy.server.GatewayContext;
import com.sun.portal.rproxy.server.GatewayContextFactory;
import com.sun.portal.util.DomainWebProxyConfig;
import com.sun.portal.util.SSOUtil;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HTTPRequest
implements Request,
HttpServletRequest {
    private List _headerLines = new ArrayList();
    private boolean _firstLine = true;
    private boolean _useProxy = false;
    private boolean _forwardCookie = false;
    private boolean _archiveTranslate = true;
    private String _protocol = null;
    private String _crlf = new String(new byte[]{13, 10});
    private char lf = (char)10;
    private String _method = null;
    private String _url = "";
    private String _uri = "";
    private String _port = null;
    private String _host = null;
    private String _gatewayhost = null;
    private String _object = "";
    private String _gwscheme = "";
    private String _proxyHost;
    private int _proxyPort;
    private String _httpVersion = null;
    private boolean _headerComplete = false;
    private Map _headerCache = new HashMap();
    private BufferedInputStream _contentStream;
    private int _size = 0;
    private static final String STRING_HTTP_PORT = "80";
    private static final String STRING_HTTPS_PORT = "443";
    private static String _cookieName;
    private static String cookiePrefix;
    private static String _colonString;
    private static boolean _useProxyFlag;
    private static final int PROXY_HTTP_PORT = 8080;
    private static MatchHttps UseWebProxyURL;
    private static MatchHttps DontUseWebProxyURL;
    private static MatchHttps ForwardCookieURL;
    private static String defaultGW;
    private static final String HTTP_1_0 = "HTTP/1.0";
    protected String gatewayURL;
    protected String encodedGatewayURL;
    protected String urlSessionInfo = null;
    protected static boolean usePlatformConfURL;
    protected static String httpPlatformConfURLString;
    protected static String httpsPlatformConfURLString;
    protected static URL httpPlatformConfURL;
    protected static URL httpsPlatformConfURL;
    private static Logger logger;
    protected boolean isCookieSupported = true;
    protected static final String SessionInURLDelimiter = "SessIDVal";
    protected static boolean forceURLSession;
    static /* synthetic */ Class class$com$sun$portal$rproxy$connectionhandler$HTTPRequest;

    public HTTPRequest() {
        this._gatewayhost = defaultGW;
    }

    public HTTPRequest(String urlstr) {
        this._gatewayhost = "";
        this._method = "GET";
        this.parseURI("/" + urlstr);
        this._httpVersion = HTTP_1_0;
    }

    public HTTPRequest(String protocol, int dummyPort) {
        GatewayContext gatewayContext = GatewayContextFactory.getGatewayContext();
        boolean urlDone = false;
        if (usePlatformConfURL) {
            if (protocol.equalsIgnoreCase("http") && httpPlatformConfURL != null) {
                this._gatewayhost = httpPlatformConfURL.getHost();
                this.gatewayURL = httpPlatformConfURLString;
                urlDone = true;
            }
            if (protocol.equalsIgnoreCase("https") && httpsPlatformConfURL != null) {
                this._gatewayhost = httpsPlatformConfURL.getHost();
                this.gatewayURL = httpsPlatformConfURLString;
                urlDone = true;
            }
        }
        if (!urlDone) {
            int port = protocol.equalsIgnoreCase("http") ? gatewayContext.getHttpPort() : gatewayContext.getHttpsPort();
            this._gatewayhost = defaultGW;
            StringBuffer buff = new StringBuffer();
            buff.append(protocol).append("://").append(defaultGW);
            if (protocol.equalsIgnoreCase("http")) {
                if (port != 80) {
                    buff.append(':').append(port);
                }
            } else if (port != 443) {
                buff.append(':').append(port);
            }
            buff.append('/');
            this.gatewayURL = buff.toString();
        }
        this.encodedGatewayURL = this.gatewayURL;
        this.urlSessionInfo = null;
    }

    public void addCustomHeader(String key, String value) {
        int vallen = value.length();
        if (value.charAt(vallen - 1) != '\n' || value.charAt(vallen - 2) != '\r') {
            value = value + this._crlf;
        }
        this._headerLines.add(key + ": " + value);
    }

    public void addHeader(String key, String value) {
        this.setRequestHeader(key, value + this._crlf);
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public String getMethod() {
        return this._method;
    }

    public String getURL() {
        return this._url;
    }

    public void setURL(String url) {
        this._url = url;
    }

    public String getURI() {
        return this._uri;
    }

    public String getHTTPVersion() {
        if (this._httpVersion.equals("HTTP/1.1")) {
            return HTTP_1_0;
        }
        return this._httpVersion;
    }

    public byte[] getRequestHeaderBytes() {
        ByteArrayOutputStream outBAOS = new ByteArrayOutputStream();
        try {
            DataOutputStream out = new DataOutputStream(outBAOS);
            try {
                out.write((this.getMethod() + " ").getBytes());
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                if (this._useProxy && !this._protocol.equals("https")) {
                    out.write(this.stripPsScriptReferrer(this.getURL()).getBytes("ISO-8859-1"));
                } else {
                    out.write(this.stripPsScriptReferrer(this.getObject()).getBytes("ISO-8859-1"));
                }
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            try {
                String httpVersion = this.getHTTPVersion();
                if (httpVersion.compareTo("HTTP/0.9") > 0) {
                    out.write((" " + this.getHTTPVersion()).getBytes());
                }
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            out.write("\r\n".getBytes());
            if (this._protocol != null && this._port != null) {
                if (this._protocol.equals("http") && this._port.equals(STRING_HTTP_PORT) || this._protocol.equals("https") && this._port.equals(STRING_HTTPS_PORT)) {
                    out.write(("Host: " + this.getHost() + "\r\n").getBytes());
                } else {
                    out.write(("Host: " + this.getHost() + ":" + this.getPort() + "\r\n").getBytes());
                }
            } else {
                out.write(("Host: " + this.getHost() + "\r\n").getBytes());
            }
            int numHeaders = this._headerLines.size();
            for (int i = 0; i < numHeaders; ++i) {
                int singleSlash;
                int doubleSlash;
                String s = (String)this._headerLines.get(i);
                if (s.regionMatches(true, 0, "host", 0, 4)) continue;
                if (s.regionMatches(true, 0, "referer", 0, 7)) {
                    Object[] params0 = new Object[]{s};
                    logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR045", params0);
                    doubleSlash = s.indexOf("//");
                    if (doubleSlash == -1) {
                        out.write(s.getBytes());
                        continue;
                    }
                    singleSlash = s.indexOf("/http", doubleSlash + 2);
                    if (singleSlash == -1) {
                        out.write(s.getBytes());
                        continue;
                    }
                    out.write(("Referer: " + s.substring(singleSlash + 1)).getBytes());
                    Object[] params1 = new Object[]{"Referer: ", s.substring(singleSlash + 1)};
                    logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR046", params1);
                    continue;
                }
                if (s.regionMatches(true, 0, "Destination", 0, 11)) {
                    Object[] params2 = new Object[]{s};
                    logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR047", params2);
                    doubleSlash = s.indexOf("//");
                    if (doubleSlash == -1) {
                        out.write(s.getBytes());
                        continue;
                    }
                    singleSlash = s.indexOf("/http", doubleSlash + 2);
                    if (singleSlash == -1) {
                        out.write(s.getBytes());
                        continue;
                    }
                    out.write(("Destination: " + s.substring(singleSlash + 1)).getBytes());
                    Object[] params3 = new Object[]{"Destination: ", s.substring(singleSlash, 1)};
                    logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR048", params3);
                    continue;
                }
                if (!s.regionMatches(true, 0, "cookie", 0, 6) || this._forwardCookie) {
                    out.write(s.getBytes());
                    continue;
                }
                String sc = this.removeSidFromCookie(s);
                if (sc == null) continue;
                out.write(sc.getBytes());
            }
            out.write("\r\n".getBytes());
            out.flush();
        }
        catch (IOException ex) {
            // empty catch block
        }
        byte[] result = outBAOS.toByteArray();
        MonitoringSubsystem.handleEvent(RProxyEvent.REQUEST_READ, new Long(result.length));
        return result;
    }

    private String removeSidFromCookie(String cookies) {
        if (cookies.length() < 8) {
            return cookies;
        }
        String sc = cookies.substring(7);
        StringBuffer result = new StringBuffer("Cookie:");
        StringTokenizer st = new StringTokenizer(sc, ";");
        while (st.hasMoreTokens()) {
            String cookie = st.nextToken().trim();
            if (cookie.startsWith(cookiePrefix)) continue;
            result.append(" ").append(cookie).append(";");
        }
        if (result.charAt(result.length() - 1) == ':') {
            return null;
        }
        result.setLength(result.length() - 1);
        result.append(this._crlf);
        return result.toString();
    }

    public String getRequestHeader(String header) {
        String result = (String)this._headerCache.get(header);
        if (result != null) {
            return result;
        }
        int numHeaders = this._headerLines.size();
        for (int i = 0; i < numHeaders; ++i) {
            String s = (String)this._headerLines.get(i);
            String tmps = s.substring(0, s.indexOf(":")).trim();
            if (!tmps.equalsIgnoreCase(header)) continue;
            this._headerCache.put(header, s);
            return s;
        }
        return null;
    }

    public void setRequestHeader(String header, String value) {
        boolean removeHeader = false;
        if (header == null || value == null) {
            return;
        }
        int vallen = value.length();
        if (vallen == 0) {
            removeHeader = true;
        } else if (value.charAt(vallen - 1) != '\n' || value.charAt(vallen - 2) != '\r') {
            value = value + this._crlf;
        }
        int headerLen = header.length();
        int numHeaders = this._headerLines.size();
        for (int i = 0; i < numHeaders; ++i) {
            String s = (String)this._headerLines.get(i);
            if (!s.regionMatches(true, 0, header, 0, headerLen)) continue;
            this._headerLines.remove(i);
            if (!removeHeader) {
                this._headerLines.add(value);
            }
            this._headerCache.remove(header);
            return;
        }
        if (!removeHeader) {
            this._headerLines.add(value);
        }
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getHost() {
        return this._host;
    }

    public String getGatewayHost() {
        return this._gatewayhost;
    }

    public String getPort() {
        return this._port;
    }

    public String getGatewayScheme() {
        return this._gwscheme;
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public int getProxyPort() {
        return this._proxyPort;
    }

    public boolean getUseProxy() {
        return this._useProxy;
    }

    public String getObject() {
        return this._object;
    }

    public int getSize() {
        return this._size;
    }

    public void addSize(int size) {
        this._size += size;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setPort(String port) {
        this._port = port;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setObject(String object) {
        this._object = object;
    }

    public void setGatewayHost(String gwhost) {
        this._gatewayhost = gwhost;
    }

    public void setArchiveTranslate(boolean t) {
        this._archiveTranslate = t;
    }

    public boolean getArchiveTranslate() {
        return this._archiveTranslate;
    }

    public BufferedInputStream getContentStream() {
        return this._contentStream;
    }

    public void setContentStream(BufferedInputStream in) {
        this._contentStream = in;
    }

    public void addHeaderLine(String s) {
        if (this._firstLine) {
            if (s.equals(this._crlf)) {
                logger.info("PSSRRPROXY_CSPRCONHNDLR049");
                return;
            }
            Object[] params5 = new Object[]{s};
            logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR050", params5);
            int strLength = s.length();
            if (strLength > 0 && s.charAt(strLength - 1) == this.lf) {
                if (!s.endsWith(this._crlf)) {
                    s = s.substring(0, strLength - 1) + this._crlf;
                }
                if (s.startsWith(this._crlf)) {
                    s = s.substring(2);
                } else if (s.charAt(0) == this.lf) {
                    s = s.substring(1);
                }
                if (s.equals(this._crlf)) {
                    return;
                }
                this._firstLine = false;
                StringTokenizer st = new StringTokenizer(s);
                int count = st.countTokens();
                boolean versionDone = false;
                this._method = st.nextToken();
                if (count <= 2) {
                    String tmp = st.nextToken();
                    if (tmp.toLowerCase().startsWith("http/")) {
                        this.parseURI("/");
                        this._httpVersion = tmp;
                    } else {
                        this.parseURI(this.URLDecode(tmp));
                        this._httpVersion = "HTTP/0.9";
                    }
                    this._headerComplete = true;
                    versionDone = true;
                } else {
                    this.parseURI(this.URLDecode(st.nextToken()));
                }
                if (!versionDone) {
                    try {
                        this._httpVersion = st.nextToken();
                    }
                    catch (NoSuchElementException ex) {
                        this._httpVersion = "HTTP/0.9";
                        this._headerComplete = true;
                    }
                }
            }
        } else {
            int strLength = s.length();
            if (!s.endsWith(this._crlf) && strLength > 0) {
                s = s.substring(0, strLength - 1) + this._crlf;
            }
            if (s.equals(this._crlf)) {
                this._headerComplete = true;
                this.requestPostReadProcessor();
            } else if (s.regionMatches(true, 0, "host:", 0, 5)) {
                if (s.length() > 5) {
                    this._gatewayhost = s.substring(5).trim();
                    int index = this._gatewayhost.indexOf(58);
                    if (index != -1) {
                        this._gatewayhost = this._gatewayhost.substring(0, index);
                    }
                    Object[] params6 = new Object[]{this._gatewayhost};
                    logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR051", params6);
                }
            } else {
                this._headerLines.add(s);
            }
        }
    }

    public String getProtocolFromCustomUrl(String knownProtocol) {
        if (httpPlatformConfURL != null && usePlatformConfURL) {
            return httpPlatformConfURL.getProtocol();
        }
        return knownProtocol;
    }

    public String getPortFromCustomUrl(String knownPort) {
        if (httpPlatformConfURL != null && usePlatformConfURL) {
            return httpPlatformConfURL.getPort() == -1 ? STRING_HTTP_PORT : httpPlatformConfURL.getPort() + "";
        }
        return knownPort;
    }

    private String URLDecode(String url) {
        int i;
        if (ServiceIdentifier.isGateway() && url.length() > 1) {
            url = "/" + SRAPTranslatorHelper.decodeOfuscatedURI(url.substring(1));
        }
        StringBuffer sb = new StringBuffer();
        int start = 0;
        start = url.indexOf("://");
        if (start == -1 && (start = url.indexOf(":/")) != -1) {
            sb.append(url.substring(0, start + 2)).append('/').append(url.substring(start + 2));
            url = sb.toString();
            sb.setLength(0);
        }
        start = 0;
        int indexParam = url.indexOf(63);
        if (indexParam == -1) {
            indexParam = url.length();
        }
        do {
            if ((i = url.indexOf(_colonString, start)) == -1 || i > indexParam) {
                sb.append(url.substring(start));
                break;
            }
            sb.append(url.substring(start, i));
            sb.append(':');
            start = i + _colonString.length();
        } while (i != -1);
        return sb.toString();
    }

    private String parseGatewayScheme(String url) {
        if (url.length() < 2) {
            return url;
        }
        int index = url.indexOf(47, 1);
        if (index == -1) {
            this._gwscheme = url.substring(1);
            return new String("/");
        }
        if (index == 1) {
            return url.substring(1);
        }
        int index2 = url.indexOf(58, 1);
        if (index2 == -1 || index2 > index) {
            if (index2 != -1) {
                index = url.lastIndexOf(47, index2);
            }
            this._gwscheme = url.substring(1, index);
            return url.substring(index);
        }
        return url;
    }

    private String checkURL(String s, int andBegin) {
        s = s.substring(0, andBegin) + "/" + s.substring(andBegin);
        this._url = s.substring(1);
        int tmpUriIndex = this._uri.indexOf(63, andBegin);
        this._uri = this._uri.substring(0, tmpUriIndex) + "/" + this._uri.substring(tmpUriIndex);
        return s;
    }

    private void parseURI(String s) {
        this._uri = s;
        int colonSlashIndex = this._uri.indexOf(":/");
        if (colonSlashIndex != -1) {
            int percentIndex;
            int colonIndex = this._uri.indexOf(58, colonSlashIndex + 1);
            int slashIndex = this._uri.indexOf(47, colonSlashIndex + 3);
            if (slashIndex == -1 && (slashIndex = this._uri.indexOf(63, colonSlashIndex + 3)) == -1) {
                slashIndex = this._uri.length();
            }
            if ((colonIndex == -1 || colonIndex > slashIndex) && (percentIndex = this._uri.indexOf(37, colonSlashIndex + 1)) != -1) {
                try {
                    StringBuffer sb = new StringBuffer();
                    sb.append(this._uri.substring(0, colonIndex + 3));
                    sb.append(URLDecoder.decode(this._uri.substring(colonIndex + 3, slashIndex)));
                    if (slashIndex != this._uri.length()) {
                        sb.append(this._uri.substring(slashIndex));
                    }
                    this._uri = sb.toString();
                }
                catch (Exception encodeEx) {
                    // empty catch block
                }
            }
        }
        s = this._uri;
        s = this.parseGatewayScheme(s);
        this._url = s.substring(1);
        int start = s.indexOf(58);
        if (start != -1) {
            this._protocol = s.substring(1, s.indexOf(58));
        }
        if ((start = s.indexOf("//")) == -1) {
            start = s.indexOf(":/");
        }
        if (start != -1) {
            int end = s.indexOf(47, start + 2);
            if (end == -1 && (end = s.indexOf(63, start + 2)) != -1) {
                s = this.checkURL(s, end);
            }
            String hostport = s.substring(start, end == -1 ? s.length() : end);
            int endHost = hostport.indexOf(58, 1);
            int checkBasicAuth = hostport.indexOf("@");
            if (checkBasicAuth != -1) {
                String user = null;
                String password = null;
                user = hostport.substring(2, hostport.indexOf(":"));
                password = hostport.substring(hostport.indexOf(":") + 1, hostport.indexOf(64));
                hostport = hostport.substring(hostport.indexOf(64) + 1);
                endHost = hostport.indexOf(58, 1);
                this.addBasicAuthInfo(user, password);
            } else {
                hostport = hostport.substring(2);
                endHost = hostport.indexOf(58, 1);
            }
            if (endHost == -1) {
                this._port = this._protocol.equals("https") ? STRING_HTTPS_PORT : STRING_HTTP_PORT;
                this._host = hostport;
            } else {
                this._host = hostport.substring(0, endHost);
                this._port = hostport.substring(endHost + 1);
            }
            if (end != -1) {
                this._object = s.substring(end);
            }
        }
        String testURL = this.getCondensedURL(this._protocol, this._host, this._port);
        this.populateWebProxyInfo();
        if (!ServiceIdentifier.isGateway()) {
            this._forwardCookie = true;
        } else {
            boolean bl = this._forwardCookie = ForwardCookieURL.hasMatch(testURL) || ForwardCookieURL.hasMatchPattern(this._url);
        }
        if (_useProxyFlag) {
            if (this._proxyHost != null && !DontUseWebProxyURL.hasMatch(testURL)) {
                this._useProxy = true;
            } else {
                this._useProxy = false;
                this._proxyHost = null;
            }
        } else if (this._proxyHost != null && UseWebProxyURL.hasMatch(testURL)) {
            this._useProxy = true;
        } else {
            this._useProxy = false;
            this._proxyHost = null;
        }
        Object[] params7 = new Object[]{new Boolean(this._useProxy), " testURL : ", testURL, " _proxyHost : ", this._proxyHost};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR052", params7);
    }

    private String getCondensedURL(String protocol, String host, String port) {
        if (protocol == null) {
            protocol = "";
        }
        if (port == null || port.equals(STRING_HTTP_PORT) && protocol.equals("http") || port.equals(STRING_HTTPS_PORT) && protocol.equals("https")) {
            return protocol + "://" + host;
        }
        return protocol + "://" + host + ":" + port;
    }

    public void populateWebProxyInfo() {
        String proxy_port = DomainWebProxyConfig.getWebProxy(this._protocol, this._host);
        Object[] params8 = new Object[]{proxy_port};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR053", params8);
        if (proxy_port == null || proxy_port.length() == 0) {
            this._proxyHost = null;
            this._useProxy = false;
        } else {
            this._useProxy = true;
            int i = proxy_port.indexOf(58);
            if (i == -1 || i + 1 >= proxy_port.length()) {
                this._proxyHost = proxy_port;
                this._proxyPort = 8080;
            } else {
                this._proxyHost = proxy_port.substring(0, i);
                this._proxyPort = Integer.parseInt(proxy_port.substring(i + 1));
            }
        }
    }

    public boolean isHeaderComplete() {
        return this._headerComplete;
    }

    public String getSessionID() {
        String s = this.getRequestHeader("Cookie");
        if (s == null) {
            return null;
        }
        String cookies = s.substring(s.indexOf(58) + 1);
        String result = null;
        StringTokenizer st = new StringTokenizer(cookies, ";");
        while (st.hasMoreTokens() && result == null) {
            String curCookie = st.nextToken().trim();
            int indx = curCookie.indexOf(61);
            if (indx == -1 || !curCookie.substring(0, indx).trim().equals(_cookieName)) continue;
            result = curCookie.substring(indx + 1).trim();
        }
        return result;
    }

    public Properties getNetworkInfo() {
        return null;
    }

    public byte[] getCertificate() {
        return null;
    }

    public String toString() {
        return new String(this.getRequestHeaderBytes());
    }

    public Object getAttribute(String name) {
        return null;
    }

    public Enumeration getAttributeNames() {
        return null;
    }

    public String getAuthType() {
        throw new UnsupportedOperationException("getAuthType() not supported");
    }

    public Cookie[] getCookies() {
        return null;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public int getContentLength() {
        String line = this.getRequestHeader("Content-length");
        StringTokenizer tokens = new StringTokenizer(line, " ");
        tokens.nextToken();
        String length = tokens.nextToken().trim();
        return Integer.parseInt(length);
    }

    public String getContentType() {
        return null;
    }

    public String getContextPath() {
        return null;
    }

    public long getDateHeader(String name) {
        throw new UnsupportedOperationException("getDateHeader() not supported");
    }

    public String getHeader(String name) {
        return this.getRequestHeader(name);
    }

    public Enumeration getHeaders(String name) {
        throw new UnsupportedOperationException("getHeaders() not supported");
    }

    public Enumeration getHeaderNames() {
        throw new UnsupportedOperationException("getHeaderNames() not supported");
    }

    public ServletInputStream getInputStream() {
        GatewayServletInputStream ret = new GatewayServletInputStream(this._contentStream);
        return ret;
    }

    public int getIntHeader(String name) {
        throw new UnsupportedOperationException("getIntHeader() not supported");
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration getLocales() {
        return null;
    }

    public String getParameter(String name) {
        return null;
    }

    public Enumeration getParameterNames() {
        return null;
    }

    public String[] getParameterValues(String name) {
        return null;
    }

    public String getPathInfo() {
        throw new UnsupportedOperationException("getPathInfo() not supported");
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException("getPathTranslated() not supported");
    }

    public String getQueryString() {
        throw new UnsupportedOperationException("getQueryString() not supported");
    }

    public BufferedReader getReader() {
        return null;
    }

    public String getRealPath(String name) {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public String getRemoteUser() {
        throw new UnsupportedOperationException("getRemoteUser() not supported");
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException("getRequestedSessionId() not supported");
    }

    public String getRequestURI() {
        throw new UnsupportedOperationException("getRequestURI() not supported");
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public String getServletPath() {
        throw new UnsupportedOperationException("getServletPath() not supported");
    }

    public HttpSession getSession() {
        throw new UnsupportedOperationException("getSession() not supported");
    }

    public HttpSession getSession(boolean create) {
        throw new UnsupportedOperationException("getSession() not supported");
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public void removeAttribute(String name) {
    }

    public void setAttribute(String name, Object obj) {
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException("isRequestedSessionIdFromCookie() not supported");
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException("isRequestedSessionIdFromUrl() not supported");
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException("isRequestedSessionIdFromURL() not supported");
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException("isRequestedSessionIdValid() not supported");
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isUserInRole(String s) {
        return false;
    }

    public String getGatewayURL() {
        return this.encodedGatewayURL;
    }

    public String getUnEncodedGatewayURL() {
        return this.gatewayURL;
    }

    public List getHeaderAttributeList(String header) {
        int numElements = this._headerLines.size();
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < numElements; ++i) {
            String tHeader;
            String s = this._headerLines.get(i).toString();
            int indx = s.indexOf(58);
            if (indx == -1 || !(tHeader = s.substring(0, indx).trim()).equalsIgnoreCase(header)) continue;
            list.addLast(s);
        }
        return list;
    }

    public boolean removeHeader(String header) {
        boolean removed = false;
        Iterator iter = this._headerLines.iterator();
        header = header.trim().toLowerCase();
        while (iter.hasNext()) {
            String tHeader;
            String s = iter.next().toString();
            int indx = s.indexOf(58);
            if (indx == -1 || !(tHeader = s.substring(0, indx).trim()).equalsIgnoreCase(header)) continue;
            iter.remove();
            removed = true;
        }
        this._headerCache.remove(header);
        return removed;
    }

    protected void requestPostReadProcessor() {
        String dest;
        this.parseUrlCookie();
        List ifHeaders = this.getHeaderAttributeList("If");
        if (ifHeaders.size() > 0) {
            this.removeHeader("If");
            LinkedList<String> newList = new LinkedList<String>();
            Iterator iter = ifHeaders.iterator();
            while (iter.hasNext()) {
                String ifHeaderStr = iter.next().toString();
                try {
                    newList.add(DavIf.parseIfHeader(ifHeaderStr, this.getGatewayURL(), true) + this._crlf);
                }
                catch (ParseException pex) {
                    newList.add(ifHeaderStr);
                }
            }
            iter = newList.iterator();
            while (iter.hasNext()) {
                this.addHeader("if", iter.next().toString());
            }
        }
        if ((dest = this.getHeader("Destination")) != null) {
            this.removeHeader("Destination");
            this.addHeader("Destination", "Destination: " + UnRewriter.unrewrite(dest.substring(dest.indexOf(58) + 1).trim()));
        }
    }

    public void setGatewayURL(String url) {
        this.gatewayURL = url;
        if (!this.gatewayURL.endsWith("/")) {
            this.gatewayURL = this.gatewayURL + "/";
        }
        this.encodedGatewayURL = this.urlSessionInfo != null ? this.gatewayURL + this.urlSessionInfo + "/" : this.gatewayURL;
    }

    public boolean isCookieSupported() {
        return this.isCookieSupported;
    }

    protected String removeAndGetSIDFromScheme() {
        String retval = "";
        if (this._gwscheme == null || this._gwscheme.length() == 0) {
            return retval;
        }
        int indx = this._gwscheme.indexOf(SessionInURLDelimiter);
        if (indx == -1) {
            return retval;
        }
        int indx1 = this._gwscheme.indexOf(47, indx);
        if (indx != 0) {
            String prevscheme = this._gwscheme;
            this._gwscheme = prevscheme.substring(0, indx - 1);
            if (indx1 != -1) {
                this._gwscheme = this._gwscheme + prevscheme.substring(indx1);
                retval = prevscheme.substring(indx, indx1);
                retval = retval.substring(SessionInURLDelimiter.length()).trim();
            } else {
                retval = prevscheme.substring(indx);
                retval = retval.substring(SessionInURLDelimiter.length()).trim();
            }
        } else if (indx1 != -1 && indx1 < this._gwscheme.length()) {
            retval = this._gwscheme.substring(0, indx1);
            retval = retval.substring(SessionInURLDelimiter.length()).trim();
            this._gwscheme = this._gwscheme.substring(indx1 + 1);
        } else {
            retval = this._gwscheme;
            retval = retval.substring(SessionInURLDelimiter.length()).trim();
            this._gwscheme = "";
        }
        return retval;
    }

    protected void parseUrlCookie() {
        if (!ServiceIdentifier.isGateway()) {
            return;
        }
        boolean bl = this.isCookieSupported = this.detectCookie() && !forceURLSession;
        if (this.isCookieSupported) {
            this.removeAndGetSIDFromScheme();
            return;
        }
        Object[] params9 = new Object[]{new Boolean(forceURLSession)};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR054", params9);
        String ourSid = this.removeAndGetSIDFromScheme();
        Object[] params10 = new Object[]{ourSid};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR055", params10);
        String sid = null;
        if ((sid == null || sid.trim().length() == 0) && this._url != null && this._url.trim().length() > 0) {
            ServletHTTPRequest request = null;
            try {
                SSOTokenManager manager = SSOTokenManager.getInstance();
                request = new ServletHTTPRequest(this);
                Object[] params11 = new Object[]{request};
                logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR056", params11);
                logger.info("PSSRRPROXY_CSPRCONHNDLR057");
                SSOToken token = manager.createSSOToken((HttpServletRequest)request);
                sid = token.getTokenID().toString();
                sid = URLEncoder.encode(sid);
                Object[] params13 = new Object[]{sid};
                logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR058", params13);
                SSOUtil.getSSOToken((String)sid);
            }
            catch (Exception ex) {
                Object[] params14 = new Object[]{request.getRequestURI()};
                logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR059", params14);
                logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR060", ex);
            }
        }
        if (sid == null && ourSid != null && ourSid.trim().length() > 0) {
            Object[] params16 = new Object[]{ourSid};
            logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR061", params16);
            sid = new String(Base64.decode(ourSid.getBytes()));
        }
        Object[] params17 = new Object[]{sid};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR062", params17);
        Object[] params18 = new Object[]{this.getRequestHeader("Cookie")};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR063", params18);
        if (sid != null && sid.length() > 0) {
            this.urlSessionInfo = SessionInURLDelimiter + Base64.encode(sid);
            this.encodedGatewayURL = this.gatewayURL + this.urlSessionInfo + "/";
            String cookie = this.getRequestHeader("Cookie");
            if (cookie != null && cookie.length() > 0) {
                int cookieLen = cookie.length();
                if (cookie.charAt(cookieLen - 1) == '\r' || cookie.charAt(cookieLen - 1) == '\n') {
                    cookie = cookie.substring(0, cookieLen - 1);
                    --cookieLen;
                }
                if (cookie.charAt(cookieLen - 1) == '\r' || cookie.charAt(cookieLen - 1) == '\n') {
                    cookie = cookie.substring(0, cookieLen - 1);
                    --cookieLen;
                }
                int indx = cookie.indexOf(_cookieName);
                while (indx != -1) {
                    int indx1 = cookie.indexOf("=", indx + 1);
                    if (indx1 == -1) {
                        indx = -1;
                        continue;
                    }
                    if (cookie.substring(indx, indx1).trim().equals(_cookieName)) break;
                    indx = cookie.indexOf(_cookieName, indx + 1);
                }
                Object[] params19 = new Object[]{new Integer(indx)};
                logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR064", params19);
                Object[] params20 = new Object[]{new Boolean(forceURLSession)};
                logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR065", params20);
                Object[] params21 = new Object[]{cookie};
                logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR066", params21);
                if (indx != -1) {
                    if (forceURLSession) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(cookie.substring(0, indx));
                        sb.append(cookiePrefix);
                        indx = cookie.indexOf(59, indx);
                        sb.append(sid);
                        if (indx != -1) {
                            sb.append(cookie.substring(indx));
                        }
                        this.setRequestHeader("Cookie", sb.toString());
                    } else {
                        Object[] params = new Object[]{"\n"};
                        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR067", params);
                        logger.info("PSSRRPROXY_CSPRCONHNDLR068");
                        StringBuffer sb = new StringBuffer();
                        sb.append(cookie.substring(0, indx));
                        sb.append(cookiePrefix);
                        indx = cookie.indexOf(59, indx);
                        sb.append(sid);
                        if (indx != -1) {
                            sb.append(cookie.substring(indx));
                        }
                        this.setRequestHeader("Cookie", sb.toString());
                    }
                } else {
                    StringBuffer sb = new StringBuffer().append(cookie);
                    if (!cookie.trim().endsWith(";")) {
                        sb.append(";");
                    }
                    sb.append(cookiePrefix).append(sid).append(this._crlf).toString();
                    this.setRequestHeader("Cookie", sb.toString());
                }
            } else {
                this.setRequestHeader("Cookie", "Cookie: " + cookiePrefix + sid + this._crlf);
            }
        }
        CookieManager.processCookies(this);
    }

    public void setSessionValue(String value) {
        if (value == null) {
            return;
        }
        this.urlSessionInfo = SessionInURLDelimiter + Base64.encode(value);
        this.encodedGatewayURL = this.gatewayURL + this.urlSessionInfo + "/";
    }

    private void addBasicAuthInfo(String user, String password) {
        this.addHeader("Authorization", "Authorization: Basic " + Base64.encode(user + ":" + password));
    }

    public int getGatewayPort() {
        try {
            URL gwURL = new URL(this.encodedGatewayURL);
            return gwURL.getPort();
        }
        catch (MalformedURLException mae) {
            Object[] params24 = new Object[]{this.encodedGatewayURL, mae};
            logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR069", params24);
            return -1;
        }
    }

    public String getGatewayProtocol() {
        if (this.encodedGatewayURL.toLowerCase().startsWith("https")) {
            return "https";
        }
        return "http";
    }

    public boolean isGatewayProtocolSecure() {
        return this.encodedGatewayURL.toLowerCase().startsWith("https");
    }

    private boolean detectCookie() {
        String cookieSupport = ClientDetector.isCookieSupported(this);
        if (cookieSupport.trim().toLowerCase().equals("false")) {
            return false;
        }
        if (cookieSupport.trim().toLowerCase().equals("true")) {
            return true;
        }
        String s = this.getRequestHeader("Cookie");
        return s != null;
    }

    public boolean isForwardCookieHost() {
        return this._forwardCookie;
    }

    private String stripPsScriptReferrer(String url) {
        int startIdx = url.indexOf("?psScriptReferrer=");
        if (startIdx == -1) {
            return url;
        }
        String result = "";
        result = result + url.substring(0, startIdx);
        int endIdx = url.indexOf(".END.");
        if (endIdx > -1) {
            result = result + url.substring(endIdx + 5);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _colonString = "%3A";
        UseWebProxyURL = new MatchHttps("UseWebProxyURL");
        DontUseWebProxyURL = new MatchHttps("DontUseWebProxyURL");
        ForwardCookieURL = new MatchHttps("ForwardCookieURL");
        usePlatformConfURL = false;
        httpPlatformConfURLString = "";
        httpsPlatformConfURLString = "";
        httpPlatformConfURL = null;
        httpsPlatformConfURL = null;
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$rproxy$connectionhandler$HTTPRequest == null ? (class$com$sun$portal$rproxy$connectionhandler$HTTPRequest = HTTPRequest.class$("com.sun.portal.rproxy.connectionhandler.HTTPRequest")) : class$com$sun$portal$rproxy$connectionhandler$HTTPRequest));
        _useProxyFlag = GatewayProfile.getBoolean("UseProxy", false);
        List all_servers = GatewayProfile.getStringList("PortalServerList");
        Iterator iterator = all_servers.iterator();
        while (iterator.hasNext()) {
            try {
                String name = iterator.next().toString();
                URL url = new URL(name);
                String protocol = url.getProtocol();
                String host = url.getHost();
                int port = url.getPort();
                boolean isDefaultPort = false;
                ForwardCookieURL.add(name);
                if (port == 80 && protocol.equals("http") || port == 443 && protocol.equals("https")) {
                    isDefaultPort = true;
                    ForwardCookieURL.add(protocol + "://" + host);
                }
                String ip = InetAddress.getByName(host).getHostAddress();
                ForwardCookieURL.add(protocol + "://" + ip + ":" + port);
                if (!isDefaultPort) continue;
                ForwardCookieURL.add(protocol + "://" + ip);
            }
            catch (Exception e) {}
        }
        defaultGW = SystemProperties.get("gateway.host", "");
        _cookieName = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
        cookiePrefix = _cookieName + "=";
        String strUsePlatformConfURL = SystemProperties.get("gateway.enable.customurl", "false");
        if (strUsePlatformConfURL != null) {
            usePlatformConfURL = strUsePlatformConfURL.trim().equalsIgnoreCase("true");
        }
        if ((httpPlatformConfURLString = SystemProperties.get("gateway.httpurl")) != null) {
            if (!(httpPlatformConfURLString = httpPlatformConfURLString.trim()).endsWith("/")) {
                httpPlatformConfURLString = httpPlatformConfURLString.concat("/");
            }
            try {
                httpPlatformConfURL = new URL(httpPlatformConfURLString);
            }
            catch (MalformedURLException mfex) {
                httpPlatformConfURL = null;
                httpPlatformConfURLString = null;
            }
        }
        if ((httpsPlatformConfURLString = SystemProperties.get("gateway.httpsurl")) != null) {
            if (!(httpsPlatformConfURLString = httpsPlatformConfURLString.trim()).endsWith("/")) {
                httpsPlatformConfURLString = httpsPlatformConfURLString.concat("/");
            }
            try {
                httpsPlatformConfURL = new URL(httpsPlatformConfURLString);
            }
            catch (MalformedURLException mfex) {
                httpsPlatformConfURL = null;
                httpsPlatformConfURLString = null;
            }
        }
        forceURLSession = GatewayProfile.getBoolean("MapForceURLSession", false);
    }
}

