/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.CookieList;
import com.sun.portal.rproxy.connectionhandler.HTTPRequest;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.InternalCookie;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.util.SSOUtil;
import com.sun.portal.util.ServiceIdentifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CookieManager {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$rproxy$connectionhandler$CookieManager == null ? (class$com$sun$portal$rproxy$connectionhandler$CookieManager = CookieManager.class$("com.sun.portal.rproxy.connectionhandler.CookieManager")) : class$com$sun$portal$rproxy$connectionhandler$CookieManager));
    public static final boolean isCookieManager = GatewayProfile.getBoolean("EnableCookieManager", true);
    private static final String sessionCookieName = SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
    private static final String SRAP_SET_COOKIE_PROPERTY = "internalSRAPSetCookieProperty";
    private static boolean cookie_management = GatewayProfile.getBoolean("CookieManagement", false) && ServiceIdentifier.isGateway();
    static /* synthetic */ Class class$com$sun$portal$rproxy$connectionhandler$CookieManager;

    private static String getReqSessionCookie(Request req) {
        String s = req.getRequestHeader("Cookie");
        if (s == null) {
            return null;
        }
        String cookies = s.substring(s.indexOf(58) + 1);
        String result = null;
        StringTokenizer st = new StringTokenizer(cookies, ";");
        while (st.hasMoreTokens() && result == null) {
            String curCookie = st.nextToken().trim();
            int indx = curCookie.indexOf(61);
            if (indx == -1 || !curCookie.substring(0, indx).trim().equals(sessionCookieName)) continue;
            result = curCookie.substring(indx + 1).trim();
        }
        return result;
    }

    public static SSOToken getUserSession(Request req, HTTPResponse res) {
        String sessid = null;
        SSOToken token = null;
        sessid = req instanceof HTTPRequest ? ((HTTPRequest)req).getSessionID() : CookieManager.getReqSessionCookie(req);
        Object[] params0 = new Object[]{sessid};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR016", params0);
        if (sessid != null) {
            try {
                token = SSOUtil.getSSOToken((String)sessid);
                Object[] params1 = new Object[]{token};
                logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR017", params1);
            }
            catch (Exception ex) {
                token = null;
                logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR018", ex);
            }
        }
        Object[] params3 = new Object[]{token};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR019", params3);
        if (token != null) {
            return token;
        }
        logger.info("PSSRRPROXY_CSPRCONHNDLR020");
        List list = res.getHeaderAttributeList("set-cookie");
        Iterator iter = list.iterator();
        sessid = null;
        while (iter.hasNext()) {
            String name;
            String cookie = iter.next().toString();
            int indx = cookie.indexOf(58);
            if (indx == -1 || (indx = (cookie = cookie.substring(indx + 1).trim()).indexOf(61)) == -1 || !(name = cookie.substring(0, indx).trim()).equals(sessionCookieName)) continue;
            int indx1 = cookie.indexOf(59, indx);
            indx1 = indx1 == -1 ? cookie.length() : indx1;
            sessid = cookie.substring(indx + 1, indx1).trim();
            break;
        }
        if (sessid != null) {
            try {
                token = SSOUtil.getSSOToken((String)sessid);
            }
            catch (Exception ex) {
                token = null;
            }
        }
        if (token == null) {
            Object[] params5 = new Object[]{sessid};
            logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR021", params5);
        } else {
            Object[] params6 = new Object[]{sessid};
            logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR022", params6);
        }
        return token;
    }

    public static void processSetCookieHeaders(Request req, HTTPResponse res) {
        List list = res.getHeaderAttributeList("set-cookie");
        Iterator iter = list.iterator();
        boolean sessionCookieDone = false;
        boolean haveUserSession = false;
        SSOToken ssotoken = null;
        CookieList cookieList = null;
        while (iter.hasNext()) {
            String cookie = iter.next().toString();
            int indx = cookie.indexOf(sessionCookieName);
            if (indx != -1) {
                boolean thisSessionCookie = false;
                int indx1 = cookie.indexOf("=", indx);
                if (indx1 != -1 && cookie.substring(indx, indx1).trim().equals(sessionCookieName)) {
                    thisSessionCookie = true;
                }
                if (thisSessionCookie) {
                    if (sessionCookieDone) continue;
                    String sessionValue = null;
                    indx = cookie.indexOf(";", indx1 + 1);
                    if (indx == -1) {
                        indx = cookie.length();
                    }
                    sessionValue = cookie.substring(indx1 + 1, indx).trim();
                    req.setSessionValue(sessionValue);
                    sessionCookieDone = true;
                    continue;
                }
            }
            if (!isCookieManager) continue;
            if (!haveUserSession) {
                ssotoken = CookieManager.getUserSession(req, res);
                if (ssotoken == null) {
                    logger.info("PSSRRPROXY_CSPRCONHNDLR023");
                    continue;
                }
                haveUserSession = true;
                String savedCookies = null;
                try {
                    savedCookies = ssotoken.getProperty(SRAP_SET_COOKIE_PROPERTY);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR024", ex);
                }
                if (savedCookies != null) {
                    cookieList = new CookieList(savedCookies);
                    Object[] params9 = new Object[]{savedCookies};
                    logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR025", params9);
                } else {
                    cookieList = new CookieList();
                    logger.info("PSSRRPROXY_CSPRCONHNDLR026");
                }
            }
            cookieList.processCookie(cookie, req.getHost());
        }
        if (cookieList != null && cookieList.isModified()) {
            logger.info("PSSRRPROXY_CSPRCONHNDLR027");
            try {
                ssotoken.setProperty(SRAP_SET_COOKIE_PROPERTY, cookieList.getEncodedValue());
            }
            catch (SSOException ex) {
                logger.severe("PSSRRPROXY_CSPRCONHNDLR028");
            }
        } else if (cookieList != null) {
            logger.info("PSSRRPROXY_CSPRCONHNDLR029");
        } else {
            logger.info("PSSRRPROXY_CSPRCONHNDLR030");
        }
    }

    public static void processCookies(Request req) {
        if (!ServiceIdentifier.isGateway()) {
            return;
        }
        if (!isCookieManager) {
            return;
        }
        String session = req.getSessionID();
        SSOToken ssotoken = null;
        try {
            ssotoken = SSOUtil.getSSOToken((String)session);
        }
        catch (Exception ex) {
            ssotoken = null;
        }
        if (ssotoken == null) {
            logger.info("PSSRRPROXY_CSPRCONHNDLR031");
            return;
        }
        String savedCookies = null;
        try {
            savedCookies = ssotoken.getProperty(SRAP_SET_COOKIE_PROPERTY);
        }
        catch (SSOException ex) {
            logger.severe("PSSRRPROXY_CSPRCONHNDLR032");
        }
        if (savedCookies == null || savedCookies.trim().length() == 0) {
            Object[] params17 = new Object[]{savedCookies};
            logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR033", params17);
            return;
        }
        CookieList cookieList = new CookieList(savedCookies);
        if (cookieList.isModified()) {
            try {
                ssotoken.setProperty(SRAP_SET_COOKIE_PROPERTY, cookieList.getEncodedValue());
            }
            catch (SSOException ex) {
                logger.severe("PSSRRPROXY_CSPRCONHNDLR034");
            }
        }
        Hashtable table = CookieManager.getCookiesAsHashtable(req.getRequestHeader("Cookie"));
        Object[] params19 = new Object[]{table};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR035", params19);
        if (CookieManager.processRequestCookieList(table, cookieList, req.getHost(), req.getObject())) {
            Object[] params20 = new Object[]{table};
            logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR036", params20);
            Enumeration enumeration = table.elements();
            StringBuffer sb = new StringBuffer().append("Cookie : ").append(enumeration.nextElement().toString());
            while (enumeration.hasMoreElements()) {
                sb.append(" ; ").append(enumeration.nextElement().toString());
            }
            req.setRequestHeader("Cookie", sb.toString());
        } else {
            Object[] params21 = new Object[]{table};
            logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR037", params21);
        }
    }

    private static boolean processRequestCookieList(Hashtable table, CookieList cookieList, String host, String path) {
        boolean changed = false;
        if (cookieList == null || cookieList.length() == 0) {
            Object[] params22 = new Object[]{cookieList};
            logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR038", params22);
            if (cookieList != null) {
                Object[] params23 = new Object[]{cookieList.length() + ""};
                logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR039", params23);
            }
            return changed;
        }
        if (cookie_management) {
            Enumeration enumeration = cookieList.enumerate();
            InternalCookie cookie = null;
            while (enumeration.hasMoreElements()) {
                cookie = (InternalCookie)enumeration.nextElement();
                Object[] params24 = new Object[]{cookie};
                logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR040", params24);
                table.put(cookie.getName(), cookie.getNameValue());
            }
            return true;
        }
        if (host == null) {
            Object[] params25 = new Object[]{host};
            logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR041", params25);
            return changed;
        }
        host = host.trim().toLowerCase();
        if (path != null) {
            path = path.trim();
        }
        Enumeration enumeration = cookieList.enumerate();
        InternalCookie cookie = null;
        while (enumeration.hasMoreElements()) {
            cookie = (InternalCookie)enumeration.nextElement();
            Object[] params26 = new Object[]{cookie};
            logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR042", params26);
            boolean checkPath = false;
            String cdomain = cookie.getDomain();
            Object[] params27 = new Object[]{cdomain};
            logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR043", params27);
            Object[] params28 = new Object[]{cookie.getPath()};
            logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR044", params28);
            if (cdomain == null) {
                if (host.equalsIgnoreCase(cookie.getHost())) {
                    checkPath = true;
                }
            } else if (host.endsWith(cdomain = cdomain.trim().toLowerCase())) {
                checkPath = true;
            }
            if (!checkPath) continue;
            String cpath = cookie.getPath();
            if (cpath == null) {
                table.put(cookie.getName(), cookie.getNameValue());
                changed = true;
                continue;
            }
            if (!path.startsWith(cpath.trim())) continue;
            table.put(cookie.getName(), cookie.getNameValue());
            changed = true;
        }
        return changed;
    }

    private static Hashtable getCookiesAsHashtable(String cookieHeader) {
        Hashtable<String, String> retval = new Hashtable<String, String>();
        if (cookieHeader == null || cookieHeader.trim().length() == 0) {
            return retval;
        }
        int indx = cookieHeader.indexOf(58);
        if (indx == -1) {
            return retval;
        }
        cookieHeader = cookieHeader.substring(indx + 1).trim();
        StringTokenizer st = new StringTokenizer(cookieHeader, ";");
        while (st.hasMoreTokens()) {
            String cookie = st.nextToken();
            indx = cookie.indexOf(61);
            if (indx == -1) continue;
            retval.put(cookie.substring(0, indx).trim(), cookie);
        }
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

